/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.vertices;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.SchemaSource;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeUtil;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.tinkerpop.blueprints.Direction;
import java.util.List;
import javax.annotation.Nullable;

public abstract class RelationTypeVertex
extends TitanSchemaVertex
implements InternalRelationType {
    private ConsistencyModifier consistency = null;
    private List<IndexType> indexes = null;

    public RelationTypeVertex(StandardTitanTx tx, long id, byte lifecycle) {
        super(tx, id, lifecycle);
    }

    @Override
    public long[] getSortKey() {
        return this.getDefinition().getValue(TypeDefinitionCategory.SORT_KEY, long[].class);
    }

    @Override
    public Order getSortOrder() {
        return this.getDefinition().getValue(TypeDefinitionCategory.SORT_ORDER, Order.class);
    }

    @Override
    public long[] getSignature() {
        return this.getDefinition().getValue(TypeDefinitionCategory.SIGNATURE, long[].class);
    }

    @Override
    public boolean isHiddenType() {
        return this.getDefinition().getValue(TypeDefinitionCategory.HIDDEN, Boolean.class);
    }

    @Override
    public Multiplicity getMultiplicity() {
        return this.getDefinition().getValue(TypeDefinitionCategory.MULTIPLICITY, Multiplicity.class);
    }

    @Override
    public ConsistencyModifier getConsistencyModifier() {
        if (this.consistency == null) {
            this.consistency = TypeUtil.getConsistencyModifier(this);
        }
        return this.consistency;
    }

    @Override
    public InternalRelationType getBaseType() {
        SchemaSource.Entry entry = (SchemaSource.Entry)Iterables.getOnlyElement(this.getRelated(TypeDefinitionCategory.RELATIONTYPE_INDEX, Direction.IN), null);
        if (entry == null) {
            return null;
        }
        assert (entry.getSchemaType() instanceof InternalRelationType);
        return (InternalRelationType)((Object)entry.getSchemaType());
    }

    @Override
    public Iterable<InternalRelationType> getRelationIndexes() {
        return Iterables.concat((Iterable)ImmutableList.of((Object)this), (Iterable)Iterables.transform(this.getRelated(TypeDefinitionCategory.RELATIONTYPE_INDEX, Direction.OUT), (Function)new Function<SchemaSource.Entry, InternalRelationType>(){

            @Nullable
            public InternalRelationType apply(@Nullable SchemaSource.Entry entry) {
                assert (entry.getSchemaType() instanceof InternalRelationType);
                return (InternalRelationType)((Object)entry.getSchemaType());
            }
        }));
    }

    @Override
    public Iterable<IndexType> getKeyIndexes() {
        ImmutableList result = this.indexes;
        if (result == null) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (SchemaSource.Entry entry : this.getRelated(TypeDefinitionCategory.INDEX_FIELD, Direction.IN)) {
                SchemaSource index = entry.getSchemaType();
                b.add((Object)index.asIndexType());
            }
            this.indexes = result = b.build();
        }
        assert (result != null);
        return result;
    }

    @Override
    public void resetCache() {
        super.resetCache();
        this.indexes = null;
    }
}

