/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.indextype;

import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.graphdb.types.ExternalIndexType;
import com.thinkaurelius.titan.graphdb.types.ParameterIndexField;
import com.thinkaurelius.titan.graphdb.types.SchemaSource;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.indextype.IndexTypeWrapper;
import com.tinkerpop.blueprints.Direction;

public class ExternalIndexTypeWrapper
extends IndexTypeWrapper
implements ExternalIndexType {
    public static final String NAME_PREFIX = "extindex";
    ParameterIndexField[] fields = null;

    public ExternalIndexTypeWrapper(SchemaSource base) {
        super(base);
    }

    @Override
    public boolean isInternalIndex() {
        return false;
    }

    @Override
    public boolean isExternalIndex() {
        return true;
    }

    @Override
    public ParameterIndexField[] getFieldKeys() {
        ParameterIndexField[] result = this.fields;
        if (result == null) {
            Iterable<SchemaSource.Entry> entries = this.base.getRelated(TypeDefinitionCategory.INDEX_FIELD, Direction.OUT);
            int numFields = Iterables.size(entries);
            result = new ParameterIndexField[numFields];
            int pos = 0;
            for (SchemaSource.Entry entry : entries) {
                assert (entry.getSchemaType() instanceof PropertyKey);
                assert (entry.getModifier() instanceof Parameter[]);
                result[pos++] = ParameterIndexField.of((PropertyKey)((Object)entry.getSchemaType()), (Parameter[])entry.getModifier());
            }
            this.fields = result;
        }
        assert (result != null);
        return result;
    }

    @Override
    public ParameterIndexField getField(PropertyKey key) {
        return (ParameterIndexField)super.getField(key);
    }

    @Override
    public void resetCache() {
        super.resetCache();
        this.fields = null;
    }

    @Override
    public String getStoreName() {
        return this.base.getDefinition().getValue(TypeDefinitionCategory.INDEXSTORE_NAME, String.class);
    }
}

