/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.types.IndexField;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.InternalIndexType;
import com.thinkaurelius.titan.graphdb.types.SchemaSource;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TypeUtil {
    public static boolean hasSimpleInternalVertexKeyIndex(TitanRelation rel) {
        if (!(rel instanceof TitanProperty)) {
            return false;
        }
        return TypeUtil.hasSimpleInternalVertexKeyIndex((TitanProperty)rel);
    }

    public static boolean hasSimpleInternalVertexKeyIndex(TitanProperty prop) {
        return TypeUtil.hasSimpleInternalVertexKeyIndex(prop.getPropertyKey());
    }

    public static boolean hasSimpleInternalVertexKeyIndex(PropertyKey key) {
        InternalRelationType type = (InternalRelationType)((Object)key);
        for (IndexType index : type.getKeyIndexes()) {
            if (index.getElement() != ElementCategory.VERTEX || !index.isInternalIndex() || !index.indexesKey(key)) continue;
            return true;
        }
        return false;
    }

    public static InternalRelationType getBaseType(InternalRelationType type) {
        InternalRelationType baseType = type.getBaseType();
        if (baseType == null) {
            return type;
        }
        return baseType;
    }

    public static Set<PropertyKey> getIndexedKeys(IndexType index) {
        HashSet s = Sets.newHashSet();
        for (IndexField f : index.getFieldKeys()) {
            s.add(f.getFieldKey());
        }
        return s;
    }

    public static List<InternalIndexType> getUniqueIndexes(PropertyKey key) {
        ArrayList<InternalIndexType> indexes = new ArrayList<InternalIndexType>();
        for (IndexType index : ((InternalRelationType)((Object)key)).getKeyIndexes()) {
            if (!index.isInternalIndex()) continue;
            InternalIndexType iIndex = (InternalIndexType)index;
            assert (index.indexesKey(key));
            if (iIndex.getCardinality() != Cardinality.SINGLE) continue;
            assert (iIndex.getElement() == ElementCategory.VERTEX);
            indexes.add(iIndex);
        }
        return indexes;
    }

    public static ConsistencyModifier getConsistencyModifier(SchemaSource schema) {
        SchemaSource.Entry entry = (SchemaSource.Entry)Iterables.getFirst(schema.getRelated(TypeDefinitionCategory.CONSISTENCY_MODIFIER, Direction.OUT), null);
        if (entry == null) {
            return ConsistencyModifier.DEFAULT;
        }
        return entry.getSchemaType().getDefinition().getValue(TypeDefinitionCategory.CONSISTENCY_LEVEL, ConsistencyModifier.class);
    }
}

