/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.SchemaStatus;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import com.tinkerpop.blueprints.Direction;

public interface SchemaSource {
    public long getID();

    public String getName();

    public SchemaStatus getStatus();

    public TypeDefinitionMap getDefinition();

    public Iterable<Entry> getRelated(TypeDefinitionCategory var1, Direction var2);

    public void resetCache();

    public IndexType asIndexType();

    public static class Entry {
        private final SchemaSource schemaType;
        private final Object modifier;

        public Entry(SchemaSource schemaType, Object modifier) {
            Preconditions.checkNotNull((Object)schemaType);
            this.schemaType = schemaType;
            this.modifier = modifier;
        }

        public SchemaSource getSchemaType() {
            return this.schemaType;
        }

        public Object getModifier() {
            return this.modifier;
        }
    }
}

