/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.schema.Parameter;
import org.apache.commons.lang.StringUtils;

public enum ParameterType {
    MAPPING("mapping"),
    INDEX_POSITION("index-pos"),
    MAPPED_NAME("mapped-name"),
    STATUS("status");

    private final String name;

    private ParameterType(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public <V> V findParameter(Parameter[] parameters, V defaultValue) {
        V result = null;
        for (Parameter p : parameters) {
            if (!p.getKey().equalsIgnoreCase(this.name)) continue;
            Object value = p.getValue();
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Invalid mapping specified: %s", (Object[])new Object[]{value});
            Preconditions.checkArgument((result == null ? 1 : 0) != 0, (Object)"Multiple mappings specified");
            result = value;
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public <V> Parameter<V> getParameter(V value) {
        return new Parameter<V>(this.name, value);
    }
}

