/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.transaction;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TransactionBuilder;
import com.thinkaurelius.titan.core.schema.DefaultSchemaMaker;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.UserModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.transaction.TransactionConfiguration;
import java.util.concurrent.TimeUnit;

public class StandardTransactionBuilder
implements TransactionConfiguration,
TransactionBuilder {
    private boolean isReadOnly = false;
    private boolean hasEnabledBatchLoading = false;
    private boolean assignIDsImmediately = false;
    private DefaultSchemaMaker defaultSchemaMaker;
    private boolean verifyExternalVertexExistence = true;
    private boolean verifyInternalVertexExistence = false;
    private boolean verifyUniqueness = true;
    private boolean acquireLocks = true;
    private boolean propertyPrefetching = true;
    private boolean singleThreaded = false;
    private boolean threadBound = false;
    private int vertexCacheSize;
    private int dirtyVertexSize;
    private long indexCacheWeight;
    private String logIdentifier;
    private int[] restrictedPartitions = new int[0];
    private Timepoint userCommitTime = null;
    private String groupName;
    private final boolean forceIndexUsage;
    private final UserModifiableConfiguration storageConfiguration;
    private final StandardTitanGraph graph;

    public StandardTransactionBuilder(GraphDatabaseConfiguration graphConfig, StandardTitanGraph graph) {
        Preconditions.checkNotNull((Object)graphConfig);
        Preconditions.checkNotNull((Object)graph);
        if (graphConfig.isReadOnly()) {
            this.readOnly();
        }
        if (graphConfig.isBatchLoading()) {
            this.enableBatchLoading();
        }
        this.graph = graph;
        this.defaultSchemaMaker = graphConfig.getDefaultSchemaMaker();
        this.assignIDsImmediately = graphConfig.hasFlushIDs();
        this.forceIndexUsage = graphConfig.hasForceIndexUsage();
        this.groupName = graphConfig.getMetricsPrefix();
        this.logIdentifier = null;
        this.propertyPrefetching = graphConfig.hasPropertyPrefetching();
        this.storageConfiguration = new UserModifiableConfiguration(GraphDatabaseConfiguration.buildConfiguration());
        this.setVertexCacheSize(graphConfig.getTxVertexCacheSize());
        this.setDirtyVertexSize(graphConfig.getTxDirtyVertexSize());
    }

    public StandardTransactionBuilder threadBound() {
        this.threadBound = true;
        this.singleThreaded = true;
        return this;
    }

    @Override
    public StandardTransactionBuilder readOnly() {
        this.isReadOnly = true;
        return this;
    }

    @Override
    public StandardTransactionBuilder enableBatchLoading() {
        this.hasEnabledBatchLoading = true;
        this.verifyUniqueness = false;
        this.verifyExternalVertexExistence = false;
        this.acquireLocks = false;
        return this;
    }

    @Override
    public StandardTransactionBuilder setVertexCacheSize(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0);
        this.vertexCacheSize = size;
        this.indexCacheWeight = size / 2;
        return this;
    }

    @Override
    public TransactionBuilder setDirtyVertexSize(int size) {
        this.dirtyVertexSize = size;
        return this;
    }

    @Override
    public StandardTransactionBuilder checkInternalVertexExistence() {
        this.verifyInternalVertexExistence = true;
        return this;
    }

    @Override
    public StandardTransactionBuilder setCommitTime(long timestampSinceEpoch, TimeUnit unit) {
        this.userCommitTime = this.getTimestampProvider().getTime(timestampSinceEpoch, unit);
        return this;
    }

    @Override
    public void setCommitTime(Timepoint time) {
        throw new UnsupportedOperationException("Use setCommitTime(lnog,TimeUnit)");
    }

    @Override
    public StandardTransactionBuilder setGroupName(String p) {
        this.groupName = p;
        return this;
    }

    @Override
    public StandardTransactionBuilder setLogIdentifier(String logName) {
        this.logIdentifier = logName;
        return this;
    }

    @Override
    public TransactionBuilder setRestrictedPartitions(int[] partitions) {
        Preconditions.checkNotNull((Object)partitions);
        this.restrictedPartitions = partitions;
        return this;
    }

    @Override
    public TransactionBuilder setCustomOption(String k, Object v) {
        this.storageConfiguration.set(k, v);
        return this;
    }

    @Override
    public TitanTransaction start() {
        ImmutableTxCfg immutable = new ImmutableTxCfg(this.isReadOnly, this.hasEnabledBatchLoading, this.assignIDsImmediately, this.forceIndexUsage, this.verifyExternalVertexExistence, this.verifyInternalVertexExistence, this.acquireLocks, this.verifyUniqueness, this.propertyPrefetching, this.singleThreaded, this.threadBound, this.getTimestampProvider(), this.userCommitTime, this.indexCacheWeight, this.getVertexCacheSize(), this.getDirtyVertexSize(), this.logIdentifier, this.restrictedPartitions, this.groupName, this.defaultSchemaMaker, new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.storageConfiguration.getConfiguration(), BasicConfiguration.Restriction.NONE));
        return this.graph.newTransaction(immutable);
    }

    @Override
    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public final boolean hasAssignIDsImmediately() {
        return this.assignIDsImmediately;
    }

    @Override
    public final boolean hasForceIndexUsage() {
        return this.forceIndexUsage;
    }

    @Override
    public boolean hasEnabledBatchLoading() {
        return this.hasEnabledBatchLoading;
    }

    @Override
    public final boolean hasVerifyExternalVertexExistence() {
        return this.verifyExternalVertexExistence;
    }

    @Override
    public final boolean hasVerifyInternalVertexExistence() {
        return this.verifyInternalVertexExistence;
    }

    @Override
    public final boolean hasAcquireLocks() {
        return this.acquireLocks;
    }

    @Override
    public final DefaultSchemaMaker getAutoSchemaMaker() {
        return this.defaultSchemaMaker;
    }

    @Override
    public final boolean hasVerifyUniqueness() {
        return this.verifyUniqueness;
    }

    @Override
    public boolean hasPropertyPrefetching() {
        return this.propertyPrefetching;
    }

    @Override
    public final boolean isSingleThreaded() {
        return this.singleThreaded;
    }

    @Override
    public final boolean isThreadBound() {
        return this.threadBound;
    }

    @Override
    public final int getVertexCacheSize() {
        return this.vertexCacheSize;
    }

    @Override
    public final int getDirtyVertexSize() {
        return this.dirtyVertexSize;
    }

    @Override
    public final long getIndexCacheWeight() {
        return this.indexCacheWeight;
    }

    @Override
    public String getLogIdentifier() {
        return this.logIdentifier;
    }

    @Override
    public int[] getRestrictedPartitions() {
        return this.restrictedPartitions;
    }

    @Override
    public boolean hasRestrictedPartitions() {
        return this.restrictedPartitions.length > 0;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public boolean hasGroupName() {
        return null != this.groupName;
    }

    @Override
    public Timepoint getCommitTime() {
        return this.userCommitTime;
    }

    @Override
    public boolean hasCommitTime() {
        return this.userCommitTime != null;
    }

    @Override
    public <V> V getCustomOption(ConfigOption<V> opt) {
        return this.getCustomOptions().get(opt, new String[0]);
    }

    @Override
    public Configuration getCustomOptions() {
        return new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.storageConfiguration.getConfiguration(), BasicConfiguration.Restriction.NONE);
    }

    @Override
    public TimestampProvider getTimestampProvider() {
        return this.graph.getConfiguration().getTimestampProvider();
    }

    private static class ImmutableTxCfg
    implements TransactionConfiguration {
        private final boolean isReadOnly;
        private final boolean hasEnabledBatchLoading;
        private final boolean hasAssignIDsImmediately;
        private final boolean hasForceIndexUsage;
        private final boolean hasVerifyExternalVertexExistence;
        private final boolean hasVerifyInternalVertexExistence;
        private final boolean hasAcquireLocks;
        private final boolean hasVerifyUniqueness;
        private final boolean hasPropertyPrefetching;
        private final boolean isSingleThreaded;
        private final boolean isThreadBound;
        private final long indexCacheWeight;
        private final int vertexCacheSize;
        private final int dirtyVertexSize;
        private final String logIdentifier;
        private final int[] restrictedPartitions;
        private final DefaultSchemaMaker defaultSchemaMaker;
        private final BaseTransactionConfig handleConfig;

        public ImmutableTxCfg(boolean isReadOnly, boolean hasEnabledBatchLoading, boolean hasAssignIDsImmediately, boolean hasForceIndexUsage, boolean hasVerifyExternalVertexExistence, boolean hasVerifyInternalVertexExistence, boolean hasAcquireLocks, boolean hasVerifyUniqueness, boolean hasPropertyPrefetching, boolean isSingleThreaded, boolean isThreadBound, TimestampProvider times, Timepoint commitTime, long indexCacheWeight, int vertexCacheSize, int dirtyVertexSize, String logIdentifier, int[] restrictedPartitions, String groupName, DefaultSchemaMaker defaultSchemaMaker, Configuration storageConfiguration) {
            this.isReadOnly = isReadOnly;
            this.hasEnabledBatchLoading = hasEnabledBatchLoading;
            this.hasAssignIDsImmediately = hasAssignIDsImmediately;
            this.hasForceIndexUsage = hasForceIndexUsage;
            this.hasVerifyExternalVertexExistence = hasVerifyExternalVertexExistence;
            this.hasVerifyInternalVertexExistence = hasVerifyInternalVertexExistence;
            this.hasAcquireLocks = hasAcquireLocks;
            this.hasVerifyUniqueness = hasVerifyUniqueness;
            this.hasPropertyPrefetching = hasPropertyPrefetching;
            this.isSingleThreaded = isSingleThreaded;
            this.isThreadBound = isThreadBound;
            this.indexCacheWeight = indexCacheWeight;
            this.vertexCacheSize = vertexCacheSize;
            this.dirtyVertexSize = dirtyVertexSize;
            this.logIdentifier = logIdentifier;
            this.restrictedPartitions = restrictedPartitions;
            this.defaultSchemaMaker = defaultSchemaMaker;
            this.handleConfig = new StandardBaseTransactionConfig.Builder().commitTime(commitTime).timestampProvider(times).groupName(groupName).customOptions(storageConfiguration).build();
        }

        @Override
        public boolean hasEnabledBatchLoading() {
            return this.hasEnabledBatchLoading;
        }

        @Override
        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        @Override
        public boolean hasAssignIDsImmediately() {
            return this.hasAssignIDsImmediately;
        }

        @Override
        public final boolean hasForceIndexUsage() {
            return this.hasForceIndexUsage;
        }

        @Override
        public boolean hasVerifyExternalVertexExistence() {
            return this.hasVerifyExternalVertexExistence;
        }

        @Override
        public boolean hasVerifyInternalVertexExistence() {
            return this.hasVerifyInternalVertexExistence;
        }

        @Override
        public boolean hasAcquireLocks() {
            return this.hasAcquireLocks;
        }

        @Override
        public DefaultSchemaMaker getAutoSchemaMaker() {
            return this.defaultSchemaMaker;
        }

        @Override
        public boolean hasVerifyUniqueness() {
            return this.hasVerifyUniqueness;
        }

        @Override
        public boolean hasPropertyPrefetching() {
            return this.hasPropertyPrefetching;
        }

        @Override
        public boolean isSingleThreaded() {
            return this.isSingleThreaded;
        }

        @Override
        public boolean isThreadBound() {
            return this.isThreadBound;
        }

        @Override
        public int getVertexCacheSize() {
            return this.vertexCacheSize;
        }

        @Override
        public int getDirtyVertexSize() {
            return this.dirtyVertexSize;
        }

        @Override
        public long getIndexCacheWeight() {
            return this.indexCacheWeight;
        }

        @Override
        public String getLogIdentifier() {
            return this.logIdentifier;
        }

        @Override
        public int[] getRestrictedPartitions() {
            return this.restrictedPartitions;
        }

        @Override
        public boolean hasRestrictedPartitions() {
            return this.restrictedPartitions.length > 0;
        }

        @Override
        public Timepoint getCommitTime() {
            return this.handleConfig.getCommitTime();
        }

        @Override
        public void setCommitTime(Timepoint time) {
            this.handleConfig.setCommitTime(time);
        }

        @Override
        public boolean hasCommitTime() {
            return this.handleConfig.hasCommitTime();
        }

        @Override
        public String getGroupName() {
            return this.handleConfig.getGroupName();
        }

        @Override
        public boolean hasGroupName() {
            return this.handleConfig.hasGroupName();
        }

        @Override
        public <V> V getCustomOption(ConfigOption<V> opt) {
            return this.handleConfig.getCustomOption(opt);
        }

        @Override
        public Configuration getCustomOptions() {
            return this.handleConfig.getCustomOptions();
        }

        @Override
        public TimestampProvider getTimestampProvider() {
            return this.handleConfig.getTimestampProvider();
        }
    }
}

