/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.relations;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.relations.AbstractTypedRelation;

public abstract class AbstractProperty
extends AbstractTypedRelation
implements TitanProperty {
    private InternalVertex vertex;
    private final Object value;

    public AbstractProperty(long id, PropertyKey type, InternalVertex vertex, Object value) {
        super(id, type);
        Preconditions.checkNotNull((Object)vertex);
        Preconditions.checkNotNull((Object)value);
        this.vertex = vertex;
        this.value = value;
    }

    public String toString() {
        String valueStr = String.valueOf(this.value);
        valueStr = valueStr.substring(0, Math.min(valueStr.length(), 20));
        return "e[" + this.getId() + "]" + "[" + this.getVertex().getId() + "-" + this.getPropertyKey() + "->" + valueStr + "]";
    }

    public void setVertexAt(int pos, InternalVertex vertex) {
        Preconditions.checkArgument((pos == 0 && vertex != null && this.vertex.equals(vertex) ? 1 : 0) != 0);
        this.vertex = vertex;
    }

    @Override
    public InternalVertex getVertex(int pos) {
        if (pos == 0) {
            return this.vertex;
        }
        throw new IllegalArgumentException("Invalid position: " + pos);
    }

    @Override
    public final int getArity() {
        return 1;
    }

    @Override
    public final int getLen() {
        return 1;
    }

    @Override
    public PropertyKey getPropertyKey() {
        return (PropertyKey)((Object)this.type);
    }

    @Override
    public TitanVertex getVertex() {
        return this.vertex;
    }

    @Override
    public <O> O getValue() {
        return (O)this.value;
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public boolean isEdge() {
        return false;
    }
}

