/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.vertex;

import com.carrotsearch.hppc.LongArrayList;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexArrayList;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexListInternal;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.util.datastructures.AbstractLongListUtil;
import java.util.Arrays;
import java.util.Iterator;

public class VertexLongList
implements VertexListInternal {
    private final StandardTitanTx tx;
    private LongArrayList vertices;
    private boolean sorted;

    public VertexLongList(StandardTitanTx tx, LongArrayList vertices, boolean sorted) {
        assert (!sorted || AbstractLongListUtil.isSorted(vertices));
        this.tx = tx;
        this.vertices = vertices;
        this.sorted = sorted;
    }

    @Override
    public void add(TitanVertex n) {
        if (!this.vertices.isEmpty()) {
            this.sorted = this.sorted && this.vertices.get(this.vertices.size() - 1) <= n.getID();
        }
        this.vertices.add(n.getID());
    }

    @Override
    public long getID(int pos) {
        return this.vertices.get(pos);
    }

    @Override
    public LongArrayList getIDs() {
        return this.vertices;
    }

    @Override
    public TitanVertex get(int pos) {
        return this.tx.getInternalVertex(this.getID(pos));
    }

    @Override
    public void sort() {
        if (this.sorted) {
            return;
        }
        Arrays.sort(this.vertices.buffer, 0, this.vertices.size());
        this.sorted = true;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public VertexList subList(int fromPosition, int length) {
        LongArrayList subList = new LongArrayList(length);
        subList.add(this.vertices.buffer, fromPosition, length);
        assert (subList.size() == length);
        return new VertexLongList(this.tx, subList, this.sorted);
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    @Override
    public void addAll(VertexList vertexlist) {
        LongArrayList othervertexids = null;
        if (vertexlist instanceof VertexLongList) {
            othervertexids = ((VertexLongList)vertexlist).vertices;
        } else if (vertexlist instanceof VertexArrayList) {
            VertexArrayList other = (VertexArrayList)vertexlist;
            othervertexids = new LongArrayList(other.size());
            for (int i = 0; i < other.size(); ++i) {
                othervertexids.add(other.getID(i));
            }
        } else {
            throw new IllegalArgumentException("Unsupported vertex-list: " + vertexlist.getClass());
        }
        if (this.sorted && vertexlist.isSorted()) {
            this.vertices = AbstractLongListUtil.mergeSort(this.vertices, othervertexids);
        } else {
            this.sorted = false;
            this.vertices.add(othervertexids.buffer, 0, othervertexids.size());
        }
    }

    public VertexArrayList toVertexArrayList() {
        VertexArrayList list = new VertexArrayList(this.tx);
        for (int i = 0; i < this.vertices.size(); ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    @Override
    public Iterator<TitanVertex> iterator() {
        return new Iterator<TitanVertex>(){
            private int pos = -1;

            @Override
            public boolean hasNext() {
                return this.pos + 1 < VertexLongList.this.size();
            }

            @Override
            public TitanVertex next() {
                ++this.pos;
                return VertexLongList.this.get(this.pos);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Vertices cannot be removed from neighborhood list");
            }
        };
    }
}

