/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.vertex.AbstractVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.vertex.BaseVertexCentricQuery;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexCentricQueryBuilder
extends AbstractVertexCentricQueryBuilder<VertexCentricQueryBuilder>
implements TitanVertexQuery<VertexCentricQueryBuilder> {
    private static final Logger log = LoggerFactory.getLogger(VertexCentricQueryBuilder.class);
    private final InternalVertex vertex;

    public VertexCentricQueryBuilder(InternalVertex v) {
        super(v.tx());
        Preconditions.checkNotNull((Object)v);
        this.vertex = v;
    }

    @Override
    protected VertexCentricQueryBuilder getThis() {
        return this;
    }

    protected <Q> Q execute(RelationCategory returnType, AbstractVertexCentricQueryBuilder.ResultConstructor<Q> resultConstructor) {
        List<InternalVertex> vertices;
        BaseVertexCentricQuery bq = super.constructQuery(returnType);
        if (bq.isEmpty()) {
            return resultConstructor.emptyResult();
        }
        if (this.isPartitionedVertex(this.vertex) && (vertices = this.allRepresentatives(this.vertex)).size() > 1) {
            for (BackendQueryHolder<SliceQuery> sq : bq.getQueries()) {
                this.tx.executeMultiQuery(vertices, sq.getBackendQuery());
            }
        }
        return resultConstructor.getResult(this.vertex, bq);
    }

    @Override
    public Iterable<TitanEdge> titanEdges() {
        return this.execute(RelationCategory.EDGE, new AbstractVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Iterable<TitanProperty> properties() {
        return this.isImplicitKeyQuery(RelationCategory.PROPERTY) ? this.executeImplicitKeyQuery(this.vertex) : this.execute(RelationCategory.PROPERTY, new AbstractVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Iterable<TitanRelation> relations() {
        return this.isImplicitKeyQuery(RelationCategory.RELATION) ? this.executeImplicitKeyQuery(this.vertex) : this.execute(RelationCategory.RELATION, new AbstractVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Iterable<Edge> edges() {
        return this.titanEdges();
    }

    public Iterable<Vertex> vertices() {
        return this.execute(RelationCategory.EDGE, new AbstractVertexCentricQueryBuilder.VertexConstructor(this));
    }

    @Override
    public VertexList vertexIds() {
        return this.execute(RelationCategory.EDGE, new AbstractVertexCentricQueryBuilder.VertexIdConstructor(this));
    }

    @Override
    public long count() {
        return this.vertexIds().size();
    }

    @Override
    public long propertyCount() {
        return Iterables.size(this.properties());
    }
}

