/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.vertex;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexLongList;
import com.thinkaurelius.titan.graphdb.transaction.RelationConstructor;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.util.datastructures.Retriever;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVertexQueryProcessor
implements Iterable<Entry> {
    private static final Logger log = LoggerFactory.getLogger(SimpleVertexQueryProcessor.class);
    private final VertexCentricQuery query;
    private final StandardTitanTx tx;
    private final EdgeSerializer edgeSerializer;
    private final InternalVertex vertex;
    private SliceQuery sliceQuery;

    public SimpleVertexQueryProcessor(VertexCentricQuery query, StandardTitanTx tx) {
        Preconditions.checkArgument((boolean)query.isSimple());
        this.query = query;
        this.tx = tx;
        this.sliceQuery = query.getSubQuery(0).getBackendQuery();
        this.vertex = query.getVertex();
        this.edgeSerializer = tx.getEdgeSerializer();
    }

    @Override
    public Iterator<Entry> iterator() {
        LimitAdjustingIterator iter = this.sliceQuery.hasLimit() && this.sliceQuery.getLimit() != this.query.getLimit() ? new LimitAdjustingIterator() : this.getBasicIterator();
        return iter;
    }

    public Iterable<TitanRelation> relations() {
        return RelationConstructor.readRelation(this.vertex, this, this.tx);
    }

    public VertexList vertexIds() {
        LongArrayList list = new LongArrayList();
        long previousId = 0L;
        for (Long id : Iterables.transform((Iterable)this, (Function)new Function<Entry, Long>(){

            @Nullable
            public Long apply(@Nullable Entry entry) {
                return SimpleVertexQueryProcessor.this.edgeSerializer.readRelation(entry, true, SimpleVertexQueryProcessor.this.tx).getOtherVertexId();
            }
        })) {
            list.add(id.longValue());
            if (id >= previousId && previousId >= 0L) {
                previousId = id;
                continue;
            }
            previousId = -1L;
        }
        return new VertexLongList(this.tx, list, previousId >= 0L);
    }

    private Iterator<Entry> getBasicIterator() {
        EntryList result = this.vertex.loadRelations(this.sliceQuery, new Retriever<SliceQuery, EntryList>(){

            @Override
            public EntryList get(SliceQuery query) {
                return SimpleVertexQueryProcessor.this.tx.getGraph().edgeQuery(SimpleVertexQueryProcessor.this.vertex.getID(), query, SimpleVertexQueryProcessor.this.tx.getTxHandle());
            }
        });
        return result.iterator();
    }

    private final class LimitAdjustingIterator
    extends com.thinkaurelius.titan.graphdb.query.LimitAdjustingIterator<Entry> {
        private LimitAdjustingIterator() {
            super(SimpleVertexQueryProcessor.this.query.getLimit(), SimpleVertexQueryProcessor.this.sliceQuery.getLimit());
        }

        @Override
        public Iterator<Entry> getNewIterator(int newLimit) {
            if (newLimit > SimpleVertexQueryProcessor.this.sliceQuery.getLimit()) {
                SimpleVertexQueryProcessor.this.sliceQuery = SimpleVertexQueryProcessor.this.sliceQuery.updateLimit(newLimit);
            }
            return SimpleVertexQueryProcessor.this.getBasicIterator();
        }
    }
}

