/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.graphdb.query.BackendQuery;
import com.thinkaurelius.titan.graphdb.query.BaseQuery;
import com.thinkaurelius.titan.graphdb.types.ExternalIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.InternalIndexType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class JointIndexQuery
extends BaseQuery
implements BackendQuery<JointIndexQuery> {
    private final List<Subquery> queries;

    private JointIndexQuery(List<Subquery> queries) {
        Preconditions.checkArgument((queries != null ? 1 : 0) != 0);
        this.queries = queries;
    }

    public JointIndexQuery() {
        this.queries = new ArrayList<Subquery>(4);
    }

    public void add(ExternalIndexType index, IndexQuery query) {
        this.queries.add(new Subquery(index, query));
    }

    public void add(InternalIndexType index, KeySliceQuery query) {
        this.queries.add(new Subquery(index, query));
    }

    public int size() {
        return this.queries.size();
    }

    public Subquery getQuery(int pos) {
        return this.queries.get(pos);
    }

    public boolean isEmpty() {
        return this.queries.isEmpty();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.queries).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        JointIndexQuery oth = (JointIndexQuery)other;
        return oth.queries.equals(this.queries);
    }

    public String toString() {
        return this.queries.toString();
    }

    @Override
    public JointIndexQuery updateLimit(int newLimit) {
        JointIndexQuery ji = new JointIndexQuery(Lists.newArrayList(this.queries));
        ji.setLimit(newLimit);
        return ji;
    }

    public static class Subquery
    implements BackendQuery<Subquery> {
        private final IndexType index;
        private final BackendQuery query;

        private Subquery(IndexType index, BackendQuery query) {
            assert (index != null && query != null && (query instanceof KeySliceQuery || query instanceof IndexQuery));
            this.index = index;
            this.query = query;
        }

        public IndexType getIndex() {
            return this.index;
        }

        public IndexQuery getExternalQuery() {
            Preconditions.checkArgument((this.index.isExternalIndex() && this.query instanceof IndexQuery ? 1 : 0) != 0);
            return (IndexQuery)this.query;
        }

        public KeySliceQuery getInternalQuery() {
            Preconditions.checkArgument((this.index.isInternalIndex() && this.query instanceof KeySliceQuery ? 1 : 0) != 0);
            return (KeySliceQuery)this.query;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.index).append((Object)this.query).toHashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!this.getClass().isInstance(other)) {
                return false;
            }
            Subquery oth = (Subquery)other;
            return this.index.equals(oth.index) && this.query.equals(oth.query);
        }

        public String toString() {
            return this.index.toString() + ":" + this.query.toString();
        }

        @Override
        public Subquery updateLimit(int newLimit) {
            return new Subquery(this.index, (BackendQuery)this.query.updateLimit(newLimit));
        }

        @Override
        public boolean hasLimit() {
            return this.query.hasLimit();
        }

        @Override
        public int getLimit() {
            return this.query.getLimit();
        }
    }
}

