/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.condition;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.MultiCondition;
import com.thinkaurelius.titan.graphdb.query.condition.Not;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import javax.annotation.Nullable;

public class ConditionUtil {
    public static final <E extends TitanElement> Condition<E> literalTransformation(Condition<E> condition, final Function<Condition<E>, Condition<E>> transformation) {
        return ConditionUtil.transformation(condition, new Function<Condition<E>, Condition<E>>(){

            @Nullable
            public Condition<E> apply(@Nullable Condition<E> cond) {
                if (cond.getType() == Condition.Type.LITERAL) {
                    return (Condition)transformation.apply(cond);
                }
                return null;
            }
        });
    }

    public static final <E extends TitanElement> Condition<E> transformation(Condition<E> condition, Function<Condition<E>, Condition<E>> transformation) {
        Condition transformed = (Condition)transformation.apply(condition);
        if (transformed != null) {
            return transformed;
        }
        if (condition.getType() == Condition.Type.LITERAL) {
            return condition;
        }
        if (condition instanceof Not) {
            return Not.of(ConditionUtil.transformation(((Not)condition).getChild(), transformation));
        }
        if (condition instanceof And) {
            And<E> newand = new And<E>(condition.numChildren());
            for (Condition<E> child : condition.getChildren()) {
                newand.add(ConditionUtil.transformation(child, transformation));
            }
            return newand;
        }
        if (condition instanceof Or) {
            Or<E> newor = new Or<E>(condition.numChildren());
            for (Condition<E> child : condition.getChildren()) {
                newor.add(ConditionUtil.transformation(child, transformation));
            }
            return newor;
        }
        throw new IllegalArgumentException("Unexpected condition type: " + condition);
    }

    public static final boolean containsType(Condition<?> condition, Condition.Type type) {
        if (condition.getType() == type) {
            return true;
        }
        if (condition.numChildren() > 0) {
            for (Condition<?> child : condition.getChildren()) {
                if (!ConditionUtil.containsType(child, type)) continue;
                return true;
            }
        }
        return false;
    }

    public static final <E extends TitanElement> void traversal(Condition<E> condition, Predicate<Condition<E>> evaluator) {
        if (!evaluator.apply(condition)) {
            return;
        }
        if (condition.getType() == Condition.Type.LITERAL) {
            return;
        }
        if (condition instanceof Not) {
            ConditionUtil.traversal(((Not)condition).getChild(), evaluator);
        } else if (condition instanceof MultiCondition) {
            for (Condition<E> child : condition.getChildren()) {
                ConditionUtil.traversal(child, evaluator);
            }
        } else {
            throw new IllegalArgumentException("Unexpected condition type: " + condition);
        }
    }
}

