/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.core.QueryDescription;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.Query;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.graph.GraphCentricQuery;
import com.thinkaurelius.titan.graphdb.query.graph.JointIndexQuery;
import com.thinkaurelius.titan.graphdb.query.vertex.BaseVertexCentricQuery;
import java.util.ArrayList;
import java.util.List;

public class StandardQueryDescription
implements QueryDescription {
    private final int noCombinedQueries;
    private final Condition queryCondition;
    private final OrderList queryOrder;
    private final String toString;
    private final List<StandardSubQuery> subQueries;

    public StandardQueryDescription(int numKeys, GraphCentricQuery query) {
        this(numKeys, query.getCondition(), query.getOrder(), query, StandardQueryDescription.convert(query));
    }

    public StandardQueryDescription(int numVertices, BaseVertexCentricQuery query) {
        this(numVertices, query.getCondition(), query.getOrders(), query, StandardQueryDescription.convert(query));
    }

    private static List<StandardSubQuery> convert(GraphCentricQuery query) {
        ArrayList<StandardSubQuery> result = new ArrayList<StandardSubQuery>(query.numSubQueries());
        for (int i = 0; i < query.numSubQueries(); ++i) {
            BackendQueryHolder<JointIndexQuery> sq = query.getSubQuery(i);
            JointIndexQuery iq = sq.getBackendQuery();
            ArrayList<String> indexes = new ArrayList<String>(iq.size());
            for (int j = 0; j < iq.size(); ++j) {
                indexes.add(iq.getQuery(j).getIndex().getName());
            }
            result.add(new StandardSubQuery(sq, indexes));
        }
        return result;
    }

    private static List<StandardSubQuery> convert(BaseVertexCentricQuery query) {
        ArrayList<StandardSubQuery> result = new ArrayList<StandardSubQuery>(query.numSubQueries());
        for (int i = 0; i < query.numSubQueries(); ++i) {
            result.add(new StandardSubQuery((BackendQueryHolder)query.getSubQuery(i)));
        }
        return result;
    }

    private StandardQueryDescription(int numCombinedQueries, Condition queryCondition, OrderList queryOrder, Query query, List<StandardSubQuery> subQueries) {
        Preconditions.checkArgument((numCombinedQueries >= 1 && query != null && subQueries != null && queryCondition != null && queryOrder != null ? 1 : 0) != 0);
        this.noCombinedQueries = numCombinedQueries;
        this.queryCondition = queryCondition;
        this.queryOrder = queryOrder;
        this.toString = query.toString();
        this.subQueries = subQueries;
    }

    @Override
    public String toString() {
        return this.toString;
    }

    public OrderList getQueryOrder() {
        return this.queryOrder;
    }

    public Condition getQueryCondition() {
        return this.queryCondition;
    }

    @Override
    public int getNoCombinedQueries() {
        return this.noCombinedQueries;
    }

    public List<StandardSubQuery> getSubQueries() {
        return this.subQueries;
    }

    @Override
    public int getNoSubQueries() {
        return this.subQueries.size();
    }

    public static class StandardSubQuery
    implements QueryDescription.SubQuery {
        private final boolean isFitted;
        private final boolean isSorted;
        private List<String> intersectingQueries;

        private StandardSubQuery(BackendQueryHolder bqh, List<String> intersectingQueries) {
            this(bqh);
            Preconditions.checkArgument((intersectingQueries != null ? 1 : 0) != 0);
            this.intersectingQueries = intersectingQueries;
        }

        private StandardSubQuery(BackendQueryHolder bqh) {
            this.isFitted = bqh.isFitted();
            this.isSorted = bqh.isSorted();
            this.intersectingQueries = ImmutableList.of((Object)"default");
        }

        public int numIntersectingQueries() {
            return this.intersectingQueries.size();
        }

        public List<String> getIntersectingQueries() {
            return this.intersectingQueries;
        }

        @Override
        public boolean isFitted() {
            return this.isFitted;
        }

        @Override
        public boolean isSorted() {
            return this.isSorted;
        }
    }
}

