/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.internal;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.graphdb.types.VertexLabelVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.EdgeLabelVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.PropertyKeyVertex;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;

public final class ElementCategory
extends Enum<ElementCategory> {
    public static final /* enum */ ElementCategory VERTEX = new ElementCategory();
    public static final /* enum */ ElementCategory EDGE = new ElementCategory();
    public static final /* enum */ ElementCategory PROPERTY = new ElementCategory();
    private static final /* synthetic */ ElementCategory[] $VALUES;

    public static ElementCategory[] values() {
        return (ElementCategory[])$VALUES.clone();
    }

    public static ElementCategory valueOf(String name) {
        return Enum.valueOf(ElementCategory.class, name);
    }

    public Class<? extends Element> getElementType() {
        switch (this) {
            case VERTEX: {
                return TitanVertex.class;
            }
            case EDGE: {
                return TitanEdge.class;
            }
            case PROPERTY: {
                return TitanProperty.class;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isValidConstraint(TitanSchemaType type) {
        Preconditions.checkNotNull((Object)type);
        switch (this) {
            case VERTEX: {
                return type instanceof VertexLabelVertex;
            }
            case EDGE: {
                return type instanceof EdgeLabelVertex;
            }
            case PROPERTY: {
                return type instanceof PropertyKeyVertex;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean matchesConstraint(TitanSchemaType type, TitanElement element) {
        Preconditions.checkArgument((type != null && element != null ? 1 : 0) != 0);
        assert (this.isInstance(element));
        assert (this.isValidConstraint(type));
        switch (this) {
            case VERTEX: {
                return ((TitanVertex)element).getVertexLabel().equals(type);
            }
            case EDGE: {
                return ((TitanEdge)element).getEdgeLabel().equals(type);
            }
            case PROPERTY: {
                return ((TitanProperty)element).getPropertyKey().equals(type);
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isInstance(TitanElement element) {
        Preconditions.checkNotNull((Object)element);
        return this.getElementType().isAssignableFrom(element.getClass());
    }

    public boolean subsumedBy(Class<? extends Element> clazz) {
        return clazz.isAssignableFrom(this.getElementType());
    }

    public String getName() {
        return this.toString().toLowerCase();
    }

    public static final ElementCategory getByClazz(Class<? extends Element> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Need to provide a element class argument");
        if (Vertex.class.isAssignableFrom(clazz)) {
            return VERTEX;
        }
        if (Edge.class.isAssignableFrom(clazz)) {
            return EDGE;
        }
        if (TitanProperty.class.isAssignableFrom(clazz)) {
            return PROPERTY;
        }
        throw new IllegalArgumentException("Invalid clazz provided: " + clazz);
    }

    public static final ElementCategory getByName(String name) {
        for (ElementCategory category : ElementCategory.values()) {
            if (!category.toString().equalsIgnoreCase(name)) continue;
            return category;
        }
        throw new IllegalArgumentException("Unrecognized name: " + name);
    }

    static {
        $VALUES = new ElementCategory[]{VERTEX, EDGE, PROPERTY};
    }
}

