/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.internal;

import com.google.common.primitives.Longs;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.ElementLifeCycle;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;

public abstract class AbstractElement
implements InternalElement {
    private long id;

    public AbstractElement(long id) {
        this.id = id;
    }

    public static boolean isTemporaryId(long elementId) {
        return elementId < 0L;
    }

    public static boolean isImplicitId(long elementId) {
        return elementId == 0L;
    }

    public int hashCode() {
        return Longs.hashCode((long)this.getCompareId());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof AbstractElement) {
            if (this.getCompareId() != ((AbstractElement)other).getCompareId()) {
                return false;
            }
        } else if (other instanceof TitanElement) {
            if (this.getCompareId() != ((TitanElement)other).getID()) {
                return false;
            }
        } else {
            return false;
        }
        if (this instanceof TitanVertex && other instanceof TitanVertex) {
            return true;
        }
        return this instanceof TitanRelation && other instanceof TitanRelation;
    }

    @Override
    public int compareTo(TitanElement other) {
        return Longs.compare((long)this.getCompareId(), (long)(other instanceof AbstractElement ? ((AbstractElement)other).getCompareId() : other.getID()));
    }

    public InternalVertex clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected long getCompareId() {
        return this.getID();
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public boolean hasId() {
        return !AbstractElement.isTemporaryId(this.getID());
    }

    @Override
    public void setID(long id) {
        assert (id > 0L);
        this.id = id;
    }

    @Override
    public boolean isHidden() {
        return IDManager.VertexIDType.Hidden.is(this.id);
    }

    @Override
    public boolean isNew() {
        return ElementLifeCycle.isNew(this.it().getLifeCycle());
    }

    @Override
    public boolean isLoaded() {
        return ElementLifeCycle.isLoaded(this.it().getLifeCycle());
    }

    @Override
    public boolean isRemoved() {
        return ElementLifeCycle.isRemoved(this.it().getLifeCycle());
    }
}

