/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.fulgora;

import com.google.common.base.Predicate;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraExecutor;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.VertexLabelVertex;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.types.system.BaseVertexLabel;
import com.thinkaurelius.titan.graphdb.vertices.CacheVertex;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FulgoraVertex<S>
extends CacheVertex {
    private final FulgoraExecutor<S> executor;
    private Map<String, Object> processedProperties;

    FulgoraVertex(StandardTitanTx tx, long id, FulgoraExecutor<S> executor) {
        super(tx, id, (byte)2);
        this.executor = executor;
    }

    void setProcessedProperties(Map<String, Object> processedProperties) {
        assert (processedProperties != null);
        this.processedProperties = processedProperties;
    }

    public <A> A getProperty(String key) {
        if (key.equals(this.executor.stateKey)) {
            return (A)this.executor.getVertexState(this.getID());
        }
        if (this.processedProperties.containsKey(key)) {
            return (A)this.processedProperties.get(key);
        }
        return null;
    }

    public <A> A getProperty(PropertyKey key) {
        return this.getProperty(key.getName());
    }

    @Override
    protected void addToQueryCache(SliceQuery query, EntryList entries) {
        super.addToQueryCache(query, entries);
    }

    @Override
    public VertexCentricQueryBuilder query() {
        throw new UnsupportedOperationException("All edges and properties have been pre-processed. Retrieve them via getProperty");
    }

    @Override
    public VertexLabel getVertexLabel() {
        Long labelid = (Long)this.getProperty(BaseLabel.VertexLabelEdge.getName());
        if (labelid == null) {
            return BaseVertexLabel.DEFAULT_VERTEXLABEL;
        }
        return (VertexLabelVertex)this.tx().getInternalVertex(labelid);
    }

    @Override
    public List<InternalRelation> getAddedRelations(Predicate<InternalRelation> query) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean hasLoadedRelations(SliceQuery query) {
        return true;
    }

    @Override
    public boolean hasRemovedRelations() {
        return false;
    }

    @Override
    public boolean hasAddedRelations() {
        return false;
    }

    @Override
    public byte getLifeCycle() {
        return 2;
    }

    @Override
    public void removeRelation(InternalRelation e) {
        throw new UnsupportedOperationException("Element mutation is not supported in OLAP");
    }

    @Override
    public boolean addRelation(InternalRelation e) {
        throw new UnsupportedOperationException("Element mutation is not supported in OLAP");
    }
}

