/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.attribute.AttributeHandler;
import com.thinkaurelius.titan.core.attribute.AttributeSerializer;
import com.thinkaurelius.titan.core.attribute.Decimal;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.attribute.Precision;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.StandardTimepoint;
import com.thinkaurelius.titan.graphdb.database.log.LogTxStatus;
import com.thinkaurelius.titan.graphdb.database.management.MgmtLogType;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeHandling;
import com.thinkaurelius.titan.graphdb.database.serialize.OrderPreservingSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.BooleanArraySerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.BooleanSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.ByteArraySerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.ByteSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.CharArraySerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.CharacterSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.DateSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.DoubleArraySerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.DoubleSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.FloatArraySerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.FloatSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.IntArraySerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.IntegerSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.LongArraySerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.LongSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.ShortArraySerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.ShortSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.StringArraySerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.StringSerializer;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.types.ParameterType;
import com.thinkaurelius.titan.graphdb.types.SchemaStatus;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionDescription;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StandardAttributeHandling
implements AttributeHandling {
    public static final List<Class<? extends Object>> DEFAULT_REGISTRATIONS = ImmutableList.of(ArrayList.class, HashMap.class, Object.class, TypeDefinitionCategory.class, TypeDefinitionDescription.class, TitanSchemaCategory.class, Parameter.class, Parameter[].class, ParameterType.class, Order.class, Multiplicity.class, Cardinality.class, (Object[])new Class[]{Direction.class, ElementCategory.class, ConsistencyModifier.class, SchemaStatus.class, LogTxStatus.class, MgmtLogType.class, StandardDuration.class, StandardTimepoint.class});
    private final Map<Class, AttributeHandler> handlers = new HashMap<Class, AttributeHandler>(60);

    public StandardAttributeHandling() {
        this.registerClass((Class)Byte.class, (AttributeHandler<V>)new ByteSerializer());
        this.registerClass((Class)Short.class, (AttributeHandler<V>)new ShortSerializer());
        this.registerClass((Class)Integer.class, (AttributeHandler<V>)new IntegerSerializer());
        this.registerClass((Class)Long.class, (AttributeHandler<V>)new LongSerializer());
        this.registerClass((Class)Decimal.class, (AttributeHandler<V>)new Decimal.DecimalSerializer());
        this.registerClass((Class)Precision.class, (AttributeHandler<V>)new Precision.PrecisionSerializer());
        this.registerClass((Class)Character.class, (AttributeHandler<V>)new CharacterSerializer());
        this.registerClass((Class)Boolean.class, (AttributeHandler<V>)new BooleanSerializer());
        this.registerClass((Class)Date.class, (AttributeHandler<V>)new DateSerializer());
        this.registerClass((Class)Geoshape.class, (AttributeHandler<V>)new Geoshape.GeoshapeSerializer());
        this.registerClass((Class)String.class, (AttributeHandler<V>)new StringSerializer());
        this.registerClass((Class)Float.class, (AttributeHandler<V>)new FloatSerializer());
        this.registerClass((Class)Double.class, (AttributeHandler<V>)new DoubleSerializer());
        this.registerClass((Class)byte[].class, (AttributeHandler<V>)new ByteArraySerializer());
        this.registerClass((Class)short[].class, (AttributeHandler<V>)new ShortArraySerializer());
        this.registerClass((Class)int[].class, (AttributeHandler<V>)new IntArraySerializer());
        this.registerClass((Class)long[].class, (AttributeHandler<V>)new LongArraySerializer());
        this.registerClass((Class)float[].class, (AttributeHandler<V>)new FloatArraySerializer());
        this.registerClass((Class)double[].class, (AttributeHandler<V>)new DoubleArraySerializer());
        this.registerClass((Class)char[].class, (AttributeHandler<V>)new CharArraySerializer());
        this.registerClass((Class)boolean[].class, (AttributeHandler<V>)new BooleanArraySerializer());
        this.registerClass((Class)String[].class, (AttributeHandler<V>)new StringArraySerializer());
    }

    public synchronized <V> void registerClass(Class<V> datatype, AttributeHandler<V> handler) {
        Preconditions.checkNotNull(datatype);
        Preconditions.checkNotNull(handler);
        Preconditions.checkArgument((!this.handlers.containsKey(datatype) ? 1 : 0) != 0, (String)"DataType has already been registered: %s", (Object[])new Object[]{datatype});
        this.handlers.put(datatype, handler);
    }

    @Override
    public <V> void verifyAttribute(Class<V> datatype, Object value) {
        Preconditions.checkNotNull(datatype);
        Preconditions.checkNotNull((Object)value);
        AttributeHandler handler = this.handlers.get(datatype);
        if (handler != null) {
            handler.verifyAttribute(value);
        }
    }

    @Override
    public <V> V convert(Class<V> datatype, Object value) {
        Preconditions.checkNotNull(datatype);
        Preconditions.checkNotNull((Object)value);
        AttributeHandler handler = this.handlers.get(datatype);
        if (handler != null) {
            return handler.convert(value);
        }
        return null;
    }

    @Override
    public boolean isOrderPreservingDatatype(Class<?> datatype) {
        return this.getSerializer(datatype) instanceof OrderPreservingSerializer;
    }

    protected <V> AttributeSerializer<V> getSerializer(Class<V> datatype) {
        Preconditions.checkNotNull(datatype);
        AttributeHandler handler = this.handlers.get(datatype);
        if (handler != null && handler instanceof AttributeSerializer) {
            return (AttributeSerializer)handler;
        }
        return null;
    }
}

