/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.management;

import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.graphdb.types.ExternalIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexField;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.InternalIndexType;
import com.tinkerpop.blueprints.Element;

public class TitanGraphIndexWrapper
implements TitanGraphIndex {
    private final IndexType index;

    public TitanGraphIndexWrapper(IndexType index) {
        this.index = index;
    }

    IndexType getBaseIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.index.getName();
    }

    @Override
    public String getBackingIndex() {
        return this.index.getBackingIndexName();
    }

    @Override
    public Class<? extends Element> getIndexedElement() {
        return this.index.getElement().getElementType();
    }

    @Override
    public PropertyKey[] getFieldKeys() {
        IndexField[] fields = this.index.getFieldKeys();
        PropertyKey[] keys = new PropertyKey[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            keys[i] = fields[i].getFieldKey();
        }
        return keys;
    }

    @Override
    public Parameter[] getParametersFor(PropertyKey key) {
        if (this.index.isInternalIndex()) {
            return new Parameter[0];
        }
        return ((ExternalIndexType)this.index).getField(key).getParameters();
    }

    @Override
    public boolean isUnique() {
        if (this.index.isExternalIndex()) {
            return false;
        }
        return ((InternalIndexType)this.index).getCardinality() == Cardinality.SINGLE;
    }
}

