/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.management;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.schema.RelationTypeIndex;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.tinkerpop.blueprints.Direction;

public class RelationTypeIndexWrapper
implements RelationTypeIndex {
    public static final char RELATION_INDEX_SEPARATOR = ':';
    private final InternalRelationType type;

    public RelationTypeIndexWrapper(InternalRelationType type) {
        Preconditions.checkArgument((type != null && type.getBaseType() != null ? 1 : 0) != 0);
        this.type = type;
    }

    @Override
    public RelationType getType() {
        return this.type.getBaseType();
    }

    @Override
    public String getName() {
        String typeName = this.type.getName();
        int index = typeName.lastIndexOf(58);
        Preconditions.checkArgument((index > 0 && index < typeName.length() - 1 ? 1 : 0) != 0, (String)"Invalid name encountered: %s", (Object[])new Object[]{typeName});
        return typeName.substring(index + 1, typeName.length());
    }

    @Override
    public Order getSortOrder() {
        return this.type.getSortOrder();
    }

    @Override
    public RelationType[] getSortKey() {
        StandardTitanTx tx = this.type.tx();
        long[] ids = this.type.getSortKey();
        RelationType[] keys = new RelationType[ids.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = tx.getExistingRelationType(ids[i]);
        }
        return keys;
    }

    @Override
    public Direction getDirection() {
        if (this.type.isUnidirected(Direction.BOTH)) {
            return Direction.BOTH;
        }
        if (this.type.isUnidirected(Direction.OUT)) {
            return Direction.OUT;
        }
        if (this.type.isUnidirected(Direction.IN)) {
            return Direction.IN;
        }
        throw new AssertionError();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object oth) {
        if (oth == null) {
            return false;
        }
        if (oth == this) {
            return true;
        }
        if (!this.getClass().isInstance(oth)) {
            return false;
        }
        return this.type.equals(((RelationTypeIndexWrapper)oth).type);
    }
}

