/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.management;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.EdgeLabelMaker;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.PropertyKeyMaker;
import com.thinkaurelius.titan.core.schema.RelationTypeIndex;
import com.thinkaurelius.titan.core.schema.TitanConfiguration;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.core.schema.VertexLabelMaker;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.TransactionalConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.UserModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.backend.KCVSConfiguration;
import com.thinkaurelius.titan.diskstorage.log.Log;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.management.ManagementLogger;
import com.thinkaurelius.titan.graphdb.database.management.MgmtLogType;
import com.thinkaurelius.titan.graphdb.database.management.RelationTypeIndexWrapper;
import com.thinkaurelius.titan.graphdb.database.management.TitanGraphIndexWrapper;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.internal.Token;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.ExternalIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexField;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.InternalIndexType;
import com.thinkaurelius.titan.graphdb.types.ParameterType;
import com.thinkaurelius.titan.graphdb.types.SchemaSource;
import com.thinkaurelius.titan.graphdb.types.SchemaStatus;
import com.thinkaurelius.titan.graphdb.types.StandardEdgeLabelMaker;
import com.thinkaurelius.titan.graphdb.types.StandardPropertyKeyMaker;
import com.thinkaurelius.titan.graphdb.types.StandardRelationTypeMaker;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionDescription;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import com.thinkaurelius.titan.graphdb.types.indextype.IndexTypeWrapper;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.types.vertices.PropertyKeyVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.RelationTypeVertex;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ManagementSystem
implements TitanManagement {
    private final StandardTitanGraph graph;
    private final Log sysLog;
    private final ManagementLogger mgmtLogger;
    private final KCVSConfiguration baseConfig;
    private final TransactionalConfiguration transactionalConfig;
    private final ModifiableConfiguration modifyConfig;
    private final UserModifiableConfiguration userConfig;
    private final StandardTitanTx transaction;
    private final Set<TitanSchemaVertex> updatedTypes;
    private final Set<Callable<Boolean>> updatedTypeTriggers;
    private boolean graphShutdownRequired;
    private boolean isOpen;
    private final UserModifiableConfiguration.ConfigVerifier configVerifier = new UserModifiableConfiguration.ConfigVerifier(){

        @Override
        public void verifyModification(ConfigOption option) {
            Preconditions.checkArgument((option.getType() != ConfigOption.Type.FIXED ? 1 : 0) != 0, (String)"Cannot change the fixed configuration option: %s", (Object[])new Object[]{option});
            Preconditions.checkArgument((option.getType() != ConfigOption.Type.LOCAL ? 1 : 0) != 0, (String)"Cannot change the local configuration option: %s", (Object[])new Object[]{option});
            if (option.getType() == ConfigOption.Type.GLOBAL_OFFLINE) {
                Set openInstances = ManagementSystem.this.getOpenInstances();
                assert (openInstances.size() > 0);
                Preconditions.checkArgument((openInstances.size() < 2 ? 1 : 0) != 0, (String)"Cannot change offline config option [%s] since multiple instances are currently open: %s", (Object[])new Object[]{option, openInstances});
                Preconditions.checkArgument((boolean)openInstances.contains(ManagementSystem.this.graph.getConfiguration().getUniqueGraphId()), (Object)("Only one open instance (" + (String)openInstances.iterator().next() + "), but it's not the current one (" + ManagementSystem.this.graph.getConfiguration().getUniqueGraphId() + ")"));
                ManagementSystem.this.graphShutdownRequired = true;
            }
        }
    };

    public ManagementSystem(StandardTitanGraph graph, KCVSConfiguration config, Log sysLog, ManagementLogger mgmtLogger) {
        Preconditions.checkArgument((config != null && graph != null && sysLog != null && mgmtLogger != null ? 1 : 0) != 0);
        this.graph = graph;
        this.baseConfig = config;
        this.sysLog = sysLog;
        this.mgmtLogger = mgmtLogger;
        this.transactionalConfig = new TransactionalConfiguration(this.baseConfig);
        this.modifyConfig = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.transactionalConfig, BasicConfiguration.Restriction.GLOBAL);
        this.userConfig = new UserModifiableConfiguration(this.modifyConfig, this.configVerifier);
        this.updatedTypes = new HashSet<TitanSchemaVertex>();
        this.updatedTypeTriggers = new HashSet<Callable<Boolean>>();
        this.graphShutdownRequired = false;
        this.transaction = (StandardTitanTx)graph.newTransaction();
        this.isOpen = true;
    }

    private Set<String> getOpenInstances() {
        return this.modifyConfig.getContainedNamespaces(GraphDatabaseConfiguration.REGISTRATION_NS, new String[0]);
    }

    private void ensureOpen() {
        Preconditions.checkState((boolean)this.isOpen, (Object)"This management system instance has been closed");
    }

    @Override
    public synchronized void commit() {
        this.ensureOpen();
        if (this.transactionalConfig.hasMutations()) {
            DataOutput out = this.graph.getDataSerializer().getDataOutput(128);
            out.writeObjectNotNull((Object)MgmtLogType.CONFIG_MUTATION);
            this.transactionalConfig.logMutations(out);
            this.sysLog.add(out.getStaticBuffer());
        }
        this.transactionalConfig.commit();
        this.transaction.commit();
        if (!this.updatedTypes.isEmpty()) {
            this.mgmtLogger.sendCacheEviction(this.updatedTypes, this.updatedTypeTriggers, this.getOpenInstances());
        }
        if (this.graphShutdownRequired) {
            this.graph.shutdown();
        }
        this.close();
    }

    @Override
    public synchronized void rollback() {
        this.ensureOpen();
        this.transactionalConfig.rollback();
        this.transaction.rollback();
        this.close();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    private void close() {
        this.isOpen = false;
    }

    public TitanSchemaElement getSchemaElement(long id) {
        TitanSchemaVertex sv;
        TitanVertex v = this.transaction.getVertex(id);
        if (v == null) {
            return null;
        }
        if (v instanceof RelationType) {
            if (((InternalRelationType)v).getBaseType() == null) {
                return (RelationType)v;
            }
            return new RelationTypeIndexWrapper((InternalRelationType)v);
        }
        if (v instanceof TitanSchemaVertex && (sv = (TitanSchemaVertex)v).getDefinition().containsKey((Object)TypeDefinitionCategory.INTERNAL_INDEX)) {
            return new TitanGraphIndexWrapper(sv.asIndexType());
        }
        throw new IllegalArgumentException("Not a valid schema element vertex: " + id);
    }

    @Override
    public RelationTypeIndex createEdgeIndex(EdgeLabel label, String name, Direction direction, RelationType ... sortKeys) {
        return this.createEdgeIndex(label, name, direction, Order.ASC, sortKeys);
    }

    @Override
    public RelationTypeIndex createEdgeIndex(EdgeLabel label, String name, Direction direction, Order sortOrder, RelationType ... sortKeys) {
        return this.createRelationTypeIndex(label, name, direction, sortOrder, sortKeys);
    }

    @Override
    public RelationTypeIndex createPropertyIndex(PropertyKey key, String name, RelationType ... sortKeys) {
        return this.createPropertyIndex(key, name, Order.ASC, sortKeys);
    }

    @Override
    public RelationTypeIndex createPropertyIndex(PropertyKey key, String name, Order sortOrder, RelationType ... sortKeys) {
        return this.createRelationTypeIndex(key, name, Direction.OUT, sortOrder, sortKeys);
    }

    private RelationTypeIndex createRelationTypeIndex(RelationType type, String name, Direction direction, Order sortOrder, RelationType ... sortKeys) {
        StandardRelationTypeMaker maker;
        StandardRelationTypeMaker lm;
        Preconditions.checkArgument((type != null && direction != null && sortOrder != null && sortKeys != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (String)"Name cannot be blank: %s", (Object[])new Object[]{name});
        Token.verifyName(name);
        Preconditions.checkArgument((sortKeys.length > 0 ? 1 : 0) != 0, (Object)"Need to specify sort keys");
        for (RelationType key : sortKeys) {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Keys cannot be null");
        }
        Preconditions.checkArgument((boolean)type.isNew(), (Object)"Can only install indexes on new types (current limitation)");
        Preconditions.checkArgument((!(type instanceof EdgeLabel) || !((EdgeLabel)type).isUnidirected() || direction == Direction.OUT ? 1 : 0) != 0, (String)"Can only index uni-directed labels in the out-direction: %s", (Object[])new Object[]{type});
        Preconditions.checkArgument((!((InternalRelationType)type).getMultiplicity().isConstrained(direction) ? 1 : 0) != 0, (String)"The relation type [%s] has a multiplicity or cardinality constraint in direction [%s] and can therefore not be indexed", (Object[])new Object[]{type, direction});
        String composedName = ManagementSystem.composeRelationTypeIndexName(type, name);
        if (type.isEdgeLabel()) {
            lm = (StandardEdgeLabelMaker)this.transaction.makeEdgeLabel(composedName);
            ((StandardEdgeLabelMaker)lm).unidirected(direction);
            maker = lm;
        } else {
            assert (type.isPropertyKey());
            assert (direction == Direction.OUT);
            lm = (StandardPropertyKeyMaker)this.transaction.makePropertyKey(composedName);
            ((StandardPropertyKeyMaker)lm).dataType((Class)((PropertyKey)type).getDataType());
            maker = lm;
        }
        maker.hidden();
        maker.multiplicity(Multiplicity.MULTI);
        maker.sortKey(sortKeys);
        maker.sortOrder(sortOrder);
        long[] typeSig = ((InternalRelationType)type).getSignature();
        HashSet signature = Sets.newHashSet();
        for (long typeId : typeSig) {
            signature.add(this.transaction.getExistingRelationType(typeId));
        }
        for (RelationType sortType : sortKeys) {
            signature.remove(sortType);
        }
        if (!signature.isEmpty()) {
            RelationType[] relationTypeArray = signature.toArray(new RelationType[signature.size()]);
            maker.signature(relationTypeArray);
        }
        RelationType relationType = maker.make();
        this.addSchemaEdge(type, relationType, TypeDefinitionCategory.RELATIONTYPE_INDEX, null);
        return new RelationTypeIndexWrapper((InternalRelationType)relationType);
    }

    private static String composeRelationTypeIndexName(RelationType type, String name) {
        return type.getName() + ':' + name;
    }

    private TitanEdge addSchemaEdge(TitanVertex out, TitanVertex in, TypeDefinitionCategory def, Object modifier) {
        assert (def.isEdge());
        TitanEdge edge = this.transaction.addEdge(out, in, BaseLabel.SchemaDefinitionEdge);
        TypeDefinitionDescription desc = new TypeDefinitionDescription(def, modifier);
        edge.setProperty(BaseKey.SchemaDefinitionDesc, (Object)desc);
        return edge;
    }

    @Override
    public boolean containsRelationIndex(RelationType type, String name) {
        return this.getRelationIndex(type, name) != null;
    }

    @Override
    public RelationTypeIndex getRelationIndex(RelationType type, String name) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        String composedName = ManagementSystem.composeRelationTypeIndexName(type, name);
        TitanVertex v = (TitanVertex)Iterables.getOnlyElement(this.transaction.getVertices(BaseKey.SchemaName, (Object)TitanSchemaCategory.getRelationTypeName(composedName)), null);
        if (v == null) {
            return null;
        }
        assert (v instanceof InternalRelationType);
        return new RelationTypeIndexWrapper((InternalRelationType)v);
    }

    @Override
    public Iterable<RelationTypeIndex> getRelationIndexes(final RelationType type) {
        Preconditions.checkArgument((type != null && type instanceof InternalRelationType ? 1 : 0) != 0, (String)"Invalid relation type provided: %s", (Object[])new Object[]{type});
        return Iterables.transform((Iterable)Iterables.filter(((InternalRelationType)type).getRelationIndexes(), (Predicate)new Predicate<InternalRelationType>(){

            public boolean apply(@Nullable InternalRelationType internalRelationType) {
                return !type.equals(internalRelationType);
            }
        }), (Function)new Function<InternalRelationType, RelationTypeIndex>(){

            @Nullable
            public RelationTypeIndex apply(@Nullable InternalRelationType internalType) {
                return new RelationTypeIndexWrapper(internalType);
            }
        });
    }

    public static IndexType getGraphIndexDirect(String name, StandardTitanTx transaction) {
        TitanSchemaVertex v = transaction.getSchemaVertex(TitanSchemaCategory.GRAPHINDEX.getSchemaName(name));
        if (v == null) {
            return null;
        }
        return v.asIndexType();
    }

    @Override
    public boolean containsGraphIndex(String name) {
        return this.getGraphIndex(name) != null;
    }

    @Override
    public TitanGraphIndex getGraphIndex(String name) {
        IndexType index = ManagementSystem.getGraphIndexDirect(name, this.transaction);
        return index == null ? null : new TitanGraphIndexWrapper(index);
    }

    @Override
    public Iterable<TitanGraphIndex> getGraphIndexes(final Class<? extends Element> elementType) {
        return Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.transform(this.transaction.getVertices(BaseKey.SchemaCategory, (Object)TitanSchemaCategory.GRAPHINDEX), (Function)new Function<TitanVertex, IndexType>(){

            @Nullable
            public IndexType apply(@Nullable TitanVertex titanVertex) {
                assert (titanVertex instanceof TitanSchemaVertex);
                return ((TitanSchemaVertex)titanVertex).asIndexType();
            }
        }), (Predicate)new Predicate<IndexType>(){

            public boolean apply(@Nullable IndexType indexType) {
                return indexType.getElement().subsumedBy(elementType);
            }
        }), (Function)new Function<IndexType, TitanGraphIndex>(){

            @Nullable
            public TitanGraphIndex apply(@Nullable IndexType indexType) {
                return new TitanGraphIndexWrapper(indexType);
            }
        });
    }

    private TitanGraphIndex createExternalIndex(String indexName, ElementCategory elementCategory, TitanSchemaType constraint, String backingIndex) {
        Preconditions.checkArgument((boolean)this.graph.getIndexSerializer().containsIndex(backingIndex), (String)"Unknown external index backend: %s", (Object[])new Object[]{backingIndex});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)indexName));
        Preconditions.checkArgument((this.getGraphIndex(indexName) == null ? 1 : 0) != 0, (String)"An index with name '%s' has already been defined", (Object[])new Object[]{indexName});
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.INTERNAL_INDEX, false);
        def.setValue(TypeDefinitionCategory.ELEMENT_CATEGORY, (Object)elementCategory);
        def.setValue(TypeDefinitionCategory.BACKING_INDEX, backingIndex);
        def.setValue(TypeDefinitionCategory.INDEXSTORE_NAME, indexName);
        def.setValue(TypeDefinitionCategory.INDEX_CARDINALITY, (Object)Cardinality.LIST);
        def.setValue(TypeDefinitionCategory.STATUS, (Object)SchemaStatus.ENABLED);
        TitanSchemaVertex v = this.transaction.makeSchemaVertex(TitanSchemaCategory.GRAPHINDEX, indexName, def);
        Preconditions.checkArgument((constraint == null || elementCategory.isValidConstraint(constraint) && constraint instanceof TitanSchemaVertex ? 1 : 0) != 0);
        if (constraint != null) {
            this.addSchemaEdge(v, (TitanSchemaVertex)((Object)constraint), TypeDefinitionCategory.INDEX_SCHEMA_CONSTRAINT, null);
        }
        return new TitanGraphIndexWrapper(v.asIndexType());
    }

    @Override
    public void addIndexKey(TitanGraphIndex index, PropertyKey key, Parameter ... parameters) {
        Preconditions.checkArgument((index != null && key != null && index instanceof TitanGraphIndexWrapper && !(key instanceof BaseKey) ? 1 : 0) != 0, (Object)"Need to provide valid index and key");
        if (parameters == null) {
            parameters = new Parameter[]{};
        }
        IndexType indexType = ((TitanGraphIndexWrapper)index).getBaseIndex();
        Preconditions.checkArgument((boolean)(indexType instanceof ExternalIndexType), (String)"Can only add keys to an external index, not %s", (Object[])new Object[]{index.getName()});
        Preconditions.checkArgument((indexType instanceof IndexTypeWrapper && key instanceof TitanSchemaVertex && ((IndexTypeWrapper)indexType).getSchemaBase() instanceof TitanSchemaVertex ? 1 : 0) != 0);
        Preconditions.checkArgument((key.getCardinality() == Cardinality.SINGLE || indexType.getElement() != ElementCategory.VERTEX ? 1 : 0) != 0, (String)"Can only index single-valued property keys on vertices [%s]", (Object[])new Object[]{key});
        Preconditions.checkArgument((boolean)key.isNew(), (Object)"Can only index new keys (current limitation)");
        TitanSchemaVertex indexVertex = (TitanSchemaVertex)((IndexTypeWrapper)indexType).getSchemaBase();
        for (IndexField field : indexType.getFieldKeys()) {
            Preconditions.checkArgument((!field.getFieldKey().equals(key) ? 1 : 0) != 0, (String)"Key [%s] has already been added to index %s", (Object[])new Object[]{key.getName(), index.getName()});
        }
        Parameter[] extendedParas = new Parameter[parameters.length + 1];
        System.arraycopy(parameters, 0, extendedParas, 0, parameters.length);
        extendedParas[parameters.length] = ParameterType.STATUS.getParameter(SchemaStatus.ENABLED);
        this.addSchemaEdge(indexVertex, key, TypeDefinitionCategory.INDEX_FIELD, extendedParas);
        indexType.resetCache();
        try {
            IndexSerializer.register((ExternalIndexType)indexType, key, this.transaction.getTxHandle());
        }
        catch (StorageException e) {
            throw new TitanException("Could not register new index field with index backend", e);
        }
    }

    private TitanGraphIndex createInternalIndex(String indexName, ElementCategory elementCategory, boolean unique, TitanSchemaType constraint, PropertyKey ... keys) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)indexName));
        Preconditions.checkArgument((this.getGraphIndex(indexName) == null ? 1 : 0) != 0, (String)"An index with name '%s' has already been defined", (Object[])new Object[]{indexName});
        Preconditions.checkArgument((keys != null && keys.length > 0 ? 1 : 0) != 0, (String)"Need to provide keys to index [%s]", (Object[])new Object[]{indexName});
        Preconditions.checkArgument((!unique || elementCategory == ElementCategory.VERTEX ? 1 : 0) != 0, (String)"Unique indexes can only be created on vertices [%s]", (Object[])new Object[]{indexName});
        boolean allSingleKeys = true;
        boolean oneNewKey = false;
        for (PropertyKey key : keys) {
            Preconditions.checkArgument((key != null && key instanceof PropertyKeyVertex ? 1 : 0) != 0, (String)"Need to provide valid keys: %s", (Object[])new Object[]{key});
            if (key.getCardinality() != Cardinality.SINGLE) {
                allSingleKeys = false;
            }
            if (!key.isNew()) continue;
            oneNewKey = true;
        }
        Preconditions.checkArgument((boolean)oneNewKey, (Object)"At least one of the indexed keys must be new (current limitation)");
        Cardinality indexCardinality = unique ? Cardinality.SINGLE : (allSingleKeys ? Cardinality.SET : Cardinality.LIST);
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.INTERNAL_INDEX, true);
        def.setValue(TypeDefinitionCategory.ELEMENT_CATEGORY, (Object)elementCategory);
        def.setValue(TypeDefinitionCategory.BACKING_INDEX, "internalindex");
        def.setValue(TypeDefinitionCategory.INDEXSTORE_NAME, indexName);
        def.setValue(TypeDefinitionCategory.INDEX_CARDINALITY, (Object)indexCardinality);
        def.setValue(TypeDefinitionCategory.STATUS, (Object)SchemaStatus.ENABLED);
        TitanSchemaVertex indexVertex = this.transaction.makeSchemaVertex(TitanSchemaCategory.GRAPHINDEX, indexName, def);
        for (int i = 0; i < keys.length; ++i) {
            Parameter[] paras = new Parameter[]{ParameterType.INDEX_POSITION.getParameter(i)};
            this.addSchemaEdge(indexVertex, keys[i], TypeDefinitionCategory.INDEX_FIELD, paras);
        }
        Preconditions.checkArgument((constraint == null || elementCategory.isValidConstraint(constraint) && constraint instanceof TitanSchemaVertex ? 1 : 0) != 0);
        if (constraint != null) {
            this.addSchemaEdge(indexVertex, (TitanSchemaVertex)((Object)constraint), TypeDefinitionCategory.INDEX_SCHEMA_CONSTRAINT, null);
        }
        return new TitanGraphIndexWrapper(indexVertex.asIndexType());
    }

    @Override
    public TitanManagement.IndexBuilder buildIndex(String indexName, Class<? extends Element> elementType) {
        return new IndexBuilder(indexName, ElementCategory.getByClazz(elementType));
    }

    @Override
    public ConsistencyModifier getConsistency(TitanSchemaElement element) {
        Preconditions.checkArgument((element != null ? 1 : 0) != 0);
        if (element instanceof RelationType) {
            return ((InternalRelationType)element).getConsistencyModifier();
        }
        if (element instanceof TitanGraphIndex) {
            IndexType index = ((TitanGraphIndexWrapper)element).getBaseIndex();
            if (index.isExternalIndex()) {
                return ConsistencyModifier.DEFAULT;
            }
            return ((InternalIndexType)index).getConsistencyModifier();
        }
        return ConsistencyModifier.DEFAULT;
    }

    @Override
    public void setConsistency(TitanSchemaElement element, ConsistencyModifier consistency) {
        TitanSchemaVertex vertex;
        Preconditions.checkArgument((consistency != null ? 1 : 0) != 0);
        if (this.getConsistency(element) == consistency) {
            return;
        }
        if (element instanceof RelationType) {
            vertex = (RelationTypeVertex)element;
            Preconditions.checkArgument((consistency != ConsistencyModifier.FORK || !vertex.getMultiplicity().isConstrained() ? 1 : 0) != 0, (String)"Cannot apply FORK consistency mode to constraint relation type: %s", (Object[])new Object[]{vertex.getName()});
        } else if (element instanceof TitanGraphIndex) {
            IndexType index = ((TitanGraphIndexWrapper)element).getBaseIndex();
            if (index.isExternalIndex()) {
                throw new IllegalArgumentException("Cannot change consistency on an external index: " + element);
            }
            assert (index instanceof IndexTypeWrapper);
            SchemaSource base = ((IndexTypeWrapper)index).getSchemaBase();
            assert (base instanceof TitanSchemaVertex);
            vertex = (TitanSchemaVertex)base;
        } else {
            throw new IllegalArgumentException("Cannot change consistency of schema element: " + element);
        }
        for (TitanEdge edge : vertex.getEdges(TypeDefinitionCategory.CONSISTENCY_MODIFIER, Direction.OUT)) {
            edge.remove();
            edge.getVertex(Direction.IN).remove();
        }
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.CONSISTENCY_LEVEL, (Object)consistency);
        TitanSchemaVertex cVertex = this.transaction.makeSchemaVertex(TitanSchemaCategory.MODIFIER, null, def);
        this.addSchemaEdge(vertex, cVertex, TypeDefinitionCategory.CONSISTENCY_MODIFIER, null);
        this.updatedTypes.add(vertex);
    }

    @Override
    public boolean containsRelationType(String name) {
        return this.transaction.containsRelationType(name);
    }

    @Override
    public RelationType getRelationType(String name) {
        return this.transaction.getRelationType(name);
    }

    @Override
    public PropertyKey getPropertyKey(String name) {
        return this.transaction.getPropertyKey(name);
    }

    @Override
    public EdgeLabel getEdgeLabel(String name) {
        return this.transaction.getEdgeLabel(name);
    }

    @Override
    public PropertyKeyMaker makePropertyKey(String name) {
        return this.transaction.makePropertyKey(name);
    }

    @Override
    public EdgeLabelMaker makeEdgeLabel(String name) {
        return this.transaction.makeEdgeLabel(name);
    }

    @Override
    public <T extends RelationType> Iterable<T> getRelationTypes(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        Iterable types = null;
        if (PropertyKey.class.equals(clazz)) {
            types = this.transaction.getVertices(BaseKey.SchemaCategory, (Object)TitanSchemaCategory.PROPERTYKEY);
        } else if (EdgeLabel.class.equals(clazz)) {
            types = this.transaction.getVertices(BaseKey.SchemaCategory, (Object)TitanSchemaCategory.EDGELABEL);
        } else if (RelationType.class.equals(clazz)) {
            types = Iterables.concat(this.getRelationTypes(EdgeLabel.class), this.getRelationTypes(PropertyKey.class));
        } else {
            throw new IllegalArgumentException("Unknown type class: " + clazz);
        }
        return Iterables.filter((Iterable)Iterables.filter(types, clazz), (Predicate)new Predicate<T>(){

            public boolean apply(@Nullable T t) {
                return ((InternalRelationType)t).getBaseType() == null;
            }
        });
    }

    @Override
    public boolean containsVertexLabel(String name) {
        return this.transaction.containsVertexLabel(name);
    }

    @Override
    public VertexLabel getVertexLabel(String name) {
        return this.transaction.getVertexLabel(name);
    }

    @Override
    public VertexLabelMaker makeVertexLabel(String name) {
        return this.transaction.makeVertexLabel(name);
    }

    @Override
    public Iterable<VertexLabel> getVertexLabels() {
        return Iterables.filter(this.transaction.getVertices(BaseKey.SchemaCategory, (Object)TitanSchemaCategory.VERTEXLABEL), VertexLabel.class);
    }

    @Override
    public synchronized String get(String path) {
        this.ensureOpen();
        return this.userConfig.get(path);
    }

    @Override
    public synchronized TitanConfiguration set(String path, Object value) {
        this.ensureOpen();
        return this.userConfig.set(path, value);
    }

    private class IndexBuilder
    implements TitanManagement.IndexBuilder {
        private final String indexName;
        private final ElementCategory elementCategory;
        private boolean unique = false;
        private TitanSchemaType constraint = null;
        private Map<PropertyKey, Parameter[]> keys = new HashMap<PropertyKey, Parameter[]>();

        private IndexBuilder(String indexName, ElementCategory elementCategory) {
            this.indexName = indexName;
            this.elementCategory = elementCategory;
        }

        @Override
        public TitanManagement.IndexBuilder indexKey(PropertyKey key) {
            Preconditions.checkArgument((key != null && key instanceof PropertyKeyVertex ? 1 : 0) != 0, (String)"Key must be a user defined key: %s", (Object[])new Object[]{key});
            this.keys.put(key, null);
            return this;
        }

        @Override
        public TitanManagement.IndexBuilder indexKey(PropertyKey key, Parameter ... parameters) {
            Preconditions.checkArgument((key != null && key instanceof PropertyKeyVertex ? 1 : 0) != 0, (String)"Key must be a user defined key: %s", (Object[])new Object[]{key});
            this.keys.put(key, parameters);
            return this;
        }

        @Override
        public TitanManagement.IndexBuilder indexOnly(TitanSchemaType schemaType) {
            Preconditions.checkNotNull((Object)schemaType);
            Preconditions.checkArgument((boolean)this.elementCategory.isValidConstraint(schemaType), (String)"Need to specify a valid schema type for this index definition: %s", (Object[])new Object[]{schemaType});
            this.constraint = schemaType;
            return this;
        }

        @Override
        public TitanManagement.IndexBuilder unique() {
            this.unique = true;
            return this;
        }

        @Override
        public TitanGraphIndex buildInternalIndex() {
            Preconditions.checkArgument((!this.keys.isEmpty() ? 1 : 0) != 0, (Object)"Need to specify at least one key for the composite index");
            PropertyKey[] keyArr = new PropertyKey[this.keys.size()];
            int pos = 0;
            for (Map.Entry<PropertyKey, Parameter[]> entry : this.keys.entrySet()) {
                Preconditions.checkArgument((entry.getValue() == null ? 1 : 0) != 0, (String)"Cannot specify parameters for composite index: %s", (Object[])new Object[]{entry.getKey()});
                keyArr[pos++] = entry.getKey();
            }
            return ManagementSystem.this.createInternalIndex(this.indexName, this.elementCategory, this.unique, this.constraint, keyArr);
        }

        @Override
        public TitanGraphIndex buildExternalIndex(String backingIndex) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)backingIndex), (Object)"Need to specify backing index name");
            Preconditions.checkArgument((!this.unique ? 1 : 0) != 0, (Object)"An external index cannot be unique");
            TitanGraphIndex index = ManagementSystem.this.createExternalIndex(this.indexName, this.elementCategory, this.constraint, backingIndex);
            for (Map.Entry<PropertyKey, Parameter[]> entry : this.keys.entrySet()) {
                ManagementSystem.this.addIndexKey(index, entry.getKey(), entry.getValue());
            }
            return index;
        }
    }

    private class IndexRegistration {
        private final ExternalIndexType index;
        private final PropertyKey key;

        private IndexRegistration(ExternalIndexType index, PropertyKey key) {
            this.index = index;
            this.key = key;
        }

        private void register() throws StorageException {
        }
    }
}

