/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.thinkaurelius.titan.core.TitanConfigurationException;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.attribute.AttributeHandler;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.core.schema.DefaultSchemaMaker;
import com.thinkaurelius.titan.diskstorage.Backend;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.MergedConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.MixedConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.backend.CommonsConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.backend.KCVSConfiguration;
import com.thinkaurelius.titan.diskstorage.idmanagement.ConflictAvoidanceMode;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingStore;
import com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLog;
import com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLogManager;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.diskstorage.util.time.Timestamps;
import com.thinkaurelius.titan.diskstorage.util.time.ZeroDuration;
import com.thinkaurelius.titan.graphdb.blueprints.BlueprintsDefaultSchemaMaker;
import com.thinkaurelius.titan.graphdb.configuration.RegisteredAttributeClass;
import com.thinkaurelius.titan.graphdb.configuration.TitanConstants;
import com.thinkaurelius.titan.graphdb.database.cache.MetricInstrumentedSchemaCache;
import com.thinkaurelius.titan.graphdb.database.cache.SchemaCache;
import com.thinkaurelius.titan.graphdb.database.cache.StandardSchemaCache;
import com.thinkaurelius.titan.graphdb.database.idassigner.VertexIDAssigner;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.database.serialize.StandardSerializer;
import com.thinkaurelius.titan.graphdb.types.typemaker.DisableDefaultSchemaMaker;
import com.thinkaurelius.titan.util.encoding.LongEncoding;
import com.thinkaurelius.titan.util.stats.MetricManager;
import com.thinkaurelius.titan.util.stats.NumberUtil;
import com.thinkaurelius.titan.util.system.NetworkUtil;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDatabaseConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GraphDatabaseConfiguration.class);
    public static ConfigNamespace ROOT_NS = new ConfigNamespace(null, "root", "Root Configuration Namespace for the Titan Graph Database");
    public static final ConfigOption<String> AUTO_TYPE = new ConfigOption<String>(ROOT_NS, "autotype", "Configures the DefaultTypeMaker to be used by this graph. If set to 'none', automatic creation of types is disabled.", ConfigOption.Type.MASKABLE, "blueprints", new Predicate<String>(){

        public boolean apply(@Nullable String s) {
            return s != null && preregisteredAutoType.containsKey(s);
        }
    });
    private static final Map<String, DefaultSchemaMaker> preregisteredAutoType = new HashMap<String, DefaultSchemaMaker>(){
        {
            this.put("none", DisableDefaultSchemaMaker.INSTANCE);
            this.put("blueprints", BlueprintsDefaultSchemaMaker.INSTANCE);
        }
    };
    public static final ConfigOption<Boolean> PROPERTY_PREFETCHING = new ConfigOption<Boolean>(ROOT_NS, "fast-property", "Whether to pre-fetch all properties on first vertex property access. This can eliminate backend calls on subsequentproperty access for the same vertex at the expense of retrieving all properties at once.", ConfigOption.Type.MASKABLE, Boolean.class);
    public static final ConfigOption<Boolean> ALLOW_SETTING_VERTEX_ID = new ConfigOption<Boolean>(ROOT_NS, "set-vertex-id", "Whether user provided vertex ids should be enabled and Titan's automatic id allocation be disabled. Useful when operating Titan in concert with another storage system that assigns long ids but disables someof Titan's advanced features. EXPERT FEATURE - USE WITH GREAT CARE.", ConfigOption.Type.FIXED, false);
    public static final ConfigOption<Boolean> FORCE_INDEX_USAGE = new ConfigOption<Boolean>(ROOT_NS, "force-index", "Whether Titan should throw an exception if a graph query cannot be answered using an index. Doing solimits the functionality of Titan's graph queries but ensures that slow graph queries are avoided.", ConfigOption.Type.MASKABLE, false);
    public static final ConfigOption<Boolean> IGNORE_UNKNOWN_INDEX_FIELD = new ConfigOption<Boolean>(ROOT_NS, "ignore-unknown-index-key", "Whether to ignore undefined types encountered in user-provided index queries", ConfigOption.Type.MASKABLE, false);
    public static final String UKNOWN_FIELD_NAME = "unknown_key";
    public static final ConfigOption<Timestamps> TIMESTAMP_PROVIDER = new ConfigOption<Timestamps>(ROOT_NS, "timestamps", "The timestamp resolution to use when writing to storage and indices", ConfigOption.Type.FIXED, Timestamps.MICRO);
    public static final ConfigOption<Boolean> SYSTEM_LOG_TRANSACTIONS = new ConfigOption<Boolean>(ROOT_NS, "log-tx", "Whether transaction mutations should be logged to Titan's system log", ConfigOption.Type.GLOBAL, false);
    public static final ConfigOption<String> UNIQUE_INSTANCE_ID = new ConfigOption<String>(ROOT_NS, "unique-instance-id", "Unique identifier for this Titan instance.  This must be unique among all instances concurrently accessing the same stores or indexes.  It's automatically generated by concatenating the hostname, process id, and a static (process-wide) counter. Leaving it unset is recommended.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<Short> UNIQUE_INSTANCE_ID_SUFFIX = new ConfigOption<Short>(ROOT_NS, "unique-instance-id-suffix", "When this is set and " + UNIQUE_INSTANCE_ID.getName() + " is not, this Titan " + "instance's unique identifier is generated by concatenating the hostname to the " + "provided number.  This is a legacy option which is currently only useful if the JVM's " + "ManagementFactory.getRuntimeMXBean().getName() is not unique between processes.", ConfigOption.Type.LOCAL, Short.class);
    public static final ConfigOption<String> INITIAL_TITAN_VERSION = new ConfigOption<String>(ROOT_NS, "titan-version", "The version of Titan with which this database was created.  Don't manually set this property.", ConfigOption.Type.FIXED, String.class);
    public static final ConfigNamespace REGISTRATION_NS = new ConfigNamespace(ROOT_NS, "system-registration", "This is used internally to keep track of open instances.", true);
    public static final ConfigOption<Timepoint> REGISTRATION_TIME = new ConfigOption<Timepoint>(REGISTRATION_NS, "startup-time", "Timestamp when this instance was started.  Automatically set.", ConfigOption.Type.GLOBAL, Timepoint.class);
    public static final ConfigNamespace CACHE_NS = new ConfigNamespace(ROOT_NS, "cache", "Configuration options that modify Titan's caching behavior");
    public static final ConfigOption<Boolean> DB_CACHE = new ConfigOption<Boolean>(CACHE_NS, "db-cache", "Whether to enable Titan's database-level cache, which is shared across all transactions. Enabling this option speeds up traversals by holding hot graph elements in memory, but also increases the likelihood of reading stale data.  Disabling it forces each transaction to indepedendently fetch graph elements from storage before reading/writing them.", ConfigOption.Type.MASKABLE, false);
    public static final ConfigOption<Double> DB_CACHE_SIZE = new ConfigOption<Double>(CACHE_NS, "db-cache-size", "Size of Titan's database level cache.  Values between 0 and 1 are interpreted as a percentage of VM heap, while larger values are interpreted as an absolute size in bytes.", ConfigOption.Type.MASKABLE, 0.3);
    public static final ConfigOption<Integer> DB_CACHE_CLEAN_WAIT = new ConfigOption<Integer>(CACHE_NS, "db-cache-clean-wait", "How long, in milliseconds, database-level cache will keep entries after flushing them.This option is only useful on distributed storage backends that are capable of acknowledging writes without necessarily making them immediately visible.", ConfigOption.Type.GLOBAL_OFFLINE, 50);
    public static final ConfigOption<Long> DB_CACHE_TIME = new ConfigOption<Long>(CACHE_NS, "db-cache-time", "Default expiration time, in milliseconds, for entries in the database-level cache. Entries are evicted when they reach this age even if the cache has room to spare. Set to 0 to disable expiration (cache entries live forever).", ConfigOption.Type.GLOBAL_OFFLINE, 10000L);
    public static final ConfigOption<Integer> TX_CACHE_SIZE = new ConfigOption<Integer>(CACHE_NS, "tx-cache-size", "Maximum size of the transaction-level cache of recently-used vertices.", ConfigOption.Type.MASKABLE, 20000);
    public static final ConfigOption<Integer> TX_DIRTY_SIZE = new ConfigOption<Integer>(CACHE_NS, "tx-dirty-size", "Initial size of the transaction-level cache of uncommitted dirty vertices. This is a performance hint for write-heavy, performance-sensitive transactional workloads. If set, it should roughly match the median vertices modified per transaction.", ConfigOption.Type.MASKABLE, Integer.class);
    private static final int TX_DIRTY_SIZE_DEFAULT_WITHOUT_BATCH = 32;
    private static final int TX_DIRTY_SIZE_DEFAULT_WITH_BATCH = 4096;
    public static final ConfigNamespace STORAGE_NS = new ConfigNamespace(ROOT_NS, "storage", "Configuration options for the storage backend.  Some options are applicable only for certain backends.");
    public static final ConfigNamespace STORAGE_SSL_NS = new ConfigNamespace(STORAGE_NS, "ssl", "Configuration options for SSL");
    public static final ConfigNamespace STORAGE_SSL_TRUSTSTORE = new ConfigNamespace(STORAGE_SSL_NS, "truststore", "Configuration options for SSL Truststore.");
    public static final ConfigOption<String> STORAGE_DIRECTORY = new ConfigOption<String>(STORAGE_NS, "directory", "Storage directory for those storage backends that require local storage", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<String> STORAGE_CONF_FILE = new ConfigOption<String>(STORAGE_NS, "conf-file", "Path to a configuration file for those storage backends that require/support a separate config file", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<String> STORAGE_BACKEND = new ConfigOption<String>(STORAGE_NS, "backend", "Either the package and classname of a StoreManager implementation or one of Titan's built-in shorthand names for its standard storage backends.", ConfigOption.Type.LOCAL, "local");
    public static final ConfigOption<Boolean> STORAGE_READONLY = new ConfigOption<Boolean>(STORAGE_NS, "read-only", "Read-only database", ConfigOption.Type.LOCAL, false);
    public static final ConfigOption<Boolean> STORAGE_BATCH = new ConfigOption<Boolean>(STORAGE_NS, "batch-loading", "Whether to enable batch loading into the storage backend", ConfigOption.Type.LOCAL, false);
    public static final ConfigOption<Boolean> STORAGE_TRANSACTIONAL = new ConfigOption<Boolean>(STORAGE_NS, "transactions", "Enables transactions on storage backends that support them", ConfigOption.Type.MASKABLE, true);
    public static final ConfigOption<Integer> BUFFER_SIZE = new ConfigOption<Integer>(STORAGE_NS, "buffer-size", "Size of the batch in which mutations are persisted", ConfigOption.Type.MASKABLE, 1024, ConfigOption.positiveInt());
    public static final ConfigOption<Duration> STORAGE_WRITE_WAITTIME = new ConfigOption<StandardDuration>(STORAGE_NS, "write-time", "Maximum time (in ms) to wait for a backend write operation to complete successfully. If a backend write operationfails temporarily, Titan will backoff exponentially and retry the operation until the wait time has been exhausted. ", ConfigOption.Type.MASKABLE, new StandardDuration(100000L, TimeUnit.MILLISECONDS));
    public static final ConfigOption<Duration> STORAGE_READ_WAITTIME = new ConfigOption<StandardDuration>(STORAGE_NS, "read-time", "Maximum time (in ms) to wait for a backend read operation to complete successfully. If a backend read operationfails temporarily, Titan will backoff exponentially and retry the operation until the wait time has been exhausted. ", ConfigOption.Type.MASKABLE, new StandardDuration(10000L, TimeUnit.MILLISECONDS));
    public static final ConfigOption<Boolean> PARALLEL_BACKEND_OPS = new ConfigOption<Boolean>(STORAGE_NS, "parallel-backend-ops", "Whether Titan should attempt to parallelize storage operations", ConfigOption.Type.MASKABLE, true);
    public static final ConfigOption<String[]> STORAGE_HOSTS = new ConfigOption<String[]>(STORAGE_NS, "hostname", "Configuration key for the hostname or list of hostname of remote storage backend servers to connect to", ConfigOption.Type.LOCAL, new String[]{NetworkUtil.getLoopbackAddress()});
    public static final ConfigOption<Integer> STORAGE_PORT = new ConfigOption<Integer>(STORAGE_NS, "port", "Configuration key for the port on which to connect to remote storage backend servers", ConfigOption.Type.LOCAL, Integer.class);
    public static final ConfigOption<Boolean> STORAGE_COMPRESSION = new ConfigOption<Boolean>(STORAGE_NS, "compression", "Whether the storage backend should use compression when storing the data", ConfigOption.Type.FIXED, true);
    public static final ConfigOption<Integer> STORAGE_COMPRESSION_SIZE = new ConfigOption<Integer>(STORAGE_NS, "compression-block-size", "The size of the compression blocks in kilobytes", ConfigOption.Type.FIXED, 64);
    public static final ConfigOption<Integer> REPLICATION_FACTOR = new ConfigOption<Integer>(STORAGE_NS, "replication-factor", "The number of data replicas (including the original copy) that should be kept. This is only meaningful for storage backends that natively support data replication.", ConfigOption.Type.GLOBAL_OFFLINE, 1);
    public static final ConfigOption<String> AUTH_USERNAME = new ConfigOption<String>(STORAGE_NS, "username", "Username to authenticate against backend", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<String> AUTH_PASSWORD = new ConfigOption<String>(STORAGE_NS, "password", "Password to authenticate against backend", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<Duration> CONNECTION_TIMEOUT = new ConfigOption<StandardDuration>(STORAGE_NS, "connection-timeout", "Default timeout, in milliseconds, when connecting to a remote database instance", ConfigOption.Type.MASKABLE, Duration.class, new StandardDuration(10000L, TimeUnit.MILLISECONDS));
    public static final ConfigOption<Duration> SETUP_WAITTIME = new ConfigOption<StandardDuration>(STORAGE_NS, "setup-wait", "Time in milliseconds for backend manager to wait for the storage backends to become available when Titan is run in server mode", ConfigOption.Type.MASKABLE, Duration.class, new StandardDuration(60000L, TimeUnit.MILLISECONDS));
    public static final ConfigOption<Integer> CONNECTION_POOL_SIZE = new ConfigOption<Integer>(STORAGE_NS, "connection-pool-size", "Default number of connections to pool when connecting to a remote database", ConfigOption.Type.MASKABLE, 32);
    public static final ConfigOption<Integer> PAGE_SIZE = new ConfigOption<Integer>(STORAGE_NS, "page-size", "Titan break requests that may return many results from distributed storage backends into a series of requests for small chunks/pages of results, where each chunk contains up to this many elements.", ConfigOption.Type.MASKABLE, 100);
    public static final ConfigOption<Integer> LOCK_RETRY = new ConfigOption<Integer>(STORAGE_NS, "lock-retries", "Number of times the system attempts to acquire a lock before giving up and throwing an exception", ConfigOption.Type.MASKABLE, 3);
    public static final ConfigOption<Duration> LOCK_WAIT = new ConfigOption<StandardDuration>(STORAGE_NS, "lock-wait-time", "Number of milliseconds the system waits for a lock application to be acknowledged by the storage backend", ConfigOption.Type.GLOBAL_OFFLINE, Duration.class, new StandardDuration(100L, TimeUnit.MILLISECONDS));
    public static final ConfigOption<Duration> LOCK_EXPIRE = new ConfigOption<StandardDuration>(STORAGE_NS, "lock-expiry-time", "Number of milliseconds the system waits for a lock application to be acknowledged by the storage backend", ConfigOption.Type.GLOBAL_OFFLINE, Duration.class, new StandardDuration(300000L, TimeUnit.MILLISECONDS));
    public static final ConfigOption<Boolean> LOCK_CLEAN_EXPIRED = new ConfigOption<Boolean>(STORAGE_NS, "lock-clean-expired", "Whether to delete expired locks from the storage backend", ConfigOption.Type.MASKABLE, false);
    public static final ConfigOption<String> LOCK_BACKEND = new ConfigOption<String>(STORAGE_NS, "lock-backend", "Locker type to use", ConfigOption.Type.GLOBAL_OFFLINE, "consistentkey");
    public static final ConfigNamespace STORE_META_NS = new ConfigNamespace(STORAGE_NS, "meta", "Meta data to include in storage backend retrievals", true);
    public static final ConfigOption<Boolean> STORE_META_TIMESTAMPS = new ConfigOption<Boolean>(STORE_META_NS, "timestamps", "Whether to include timestamps in retrieved entries for storage backends that automatically annotated entries with timestamps", ConfigOption.Type.GLOBAL, false);
    public static final ConfigOption<Boolean> STORE_META_TTL = new ConfigOption<Boolean>(STORE_META_NS, "ttl", "Whether to include ttl in retrieved entries for storage backends that automatically annotated entries with timestamps", ConfigOption.Type.GLOBAL, false);
    public static final ConfigOption<Boolean> STORE_META_VISIBILITY = new ConfigOption<Boolean>(STORE_META_NS, "visibility", "Whether to include visibility in retrieved entries for storage backends that automatically annotated entries with timestamps", ConfigOption.Type.GLOBAL, true);
    public static final ConfigNamespace CLUSTER_NS = new ConfigNamespace(ROOT_NS, "cluster", "Configuration options for multi-machine deployments");
    public static final ConfigOption<Boolean> CLUSTER_PARTITION = new ConfigOption<Boolean>(CLUSTER_NS, "partition", "Whether the graph's element IDs should be randomly distributed across the space of available IDs (true) or allocated in increasing order (false). Unless explicitly set, this defaults false for  stores that hash keys and defaults true for stores that preserve key order (such as HBase and Cassandra with ByteOrderedPartitioner).", ConfigOption.Type.FIXED, false);
    public static final ConfigOption<Integer> CLUSTER_MAX_PARTITIONS = new ConfigOption<Integer>(CLUSTER_NS, "max-partitions", "The maximum number of ID partitions in the graph. Must be bigger than 1 and a power of 2.", ConfigOption.Type.FIXED, 64, new Predicate<Integer>(){

        public boolean apply(@Nullable Integer integer) {
            return integer != null && integer > 1 && NumberUtil.isPowerOf2(integer.intValue());
        }
    });
    public static final ConfigNamespace IDS_NS = new ConfigNamespace(ROOT_NS, "ids", "General configuration options for graph element IDs");
    public static final ConfigOption<Integer> IDS_BLOCK_SIZE = new ConfigOption<Integer>(IDS_NS, "block-size", "Globally reserve graph element IDs in chunks of this size.  Setting this too low will make commits frequently block on slow reservation requests.  Setting it too high will result in IDs wasted when a graph instance shuts down with reserved but mostly-unused blocks.", ConfigOption.Type.GLOBAL_OFFLINE, 10000);
    public static final ConfigOption<Boolean> IDS_FLUSH = new ConfigOption<Boolean>(IDS_NS, "flush", "When true, vertices and edges are assigned IDs immediately upon creation.  When false, IDs are assigned only when the transaction commits.", ConfigOption.Type.MASKABLE, true);
    public static final ConfigOption<Duration> IDS_RENEW_TIMEOUT = new ConfigOption<StandardDuration>(IDS_NS, "renew-timeout", "The number of milliseconds that the Titan id pool manager will wait before giving up on allocating a new block of ids", ConfigOption.Type.MASKABLE, Duration.class, new StandardDuration(120000L, TimeUnit.MILLISECONDS));
    public static final ConfigOption<Double> IDS_RENEW_BUFFER_PERCENTAGE = new ConfigOption<Double>(IDS_NS, "renew-percentage", "When the most-recently-reserved ID block has only this percentage of its total IDs remaining (expressed as a value between 0 and 1), Titan asynchronously begins reserving another block. This helps avoid transaction commits waiting on ID reservation even if the block size is relatively small.", ConfigOption.Type.MASKABLE, 0.3);
    public static final ConfigNamespace IDAUTHORITY_NS = new ConfigNamespace(IDS_NS, "authority", "Configuration options for graph element ID reservation/allocation");
    public static final ConfigOption<Duration> IDAUTHORITY_WAIT = new ConfigOption<StandardDuration>(IDAUTHORITY_NS, "wait-time", "The number of milliseconds the system waits for an ID block reservation to be acknowledged by the storage backend", ConfigOption.Type.GLOBAL_OFFLINE, Duration.class, new StandardDuration(300L, TimeUnit.MILLISECONDS));
    public static final ConfigOption<ConflictAvoidanceMode> IDAUTHORITY_CONFLICT_AVOIDANCE = new ConfigOption<ConflictAvoidanceMode>(IDAUTHORITY_NS, "conflict-avoidance-mode", "This setting helps separate Titan instances sharing a single graph storage backend avoid contention when reserving ID blocks, increasing overall throughput.", ConfigOption.Type.GLOBAL_OFFLINE, ConflictAvoidanceMode.NONE);
    public static final ConfigOption<Integer> IDAUTHORITY_CAV_RETRIES = new ConfigOption<Integer>(IDAUTHORITY_NS, "randomized-conflict-avoidance-retries", "Number of times the system attempts attempts ID block reservations with random conflict avoidance tags before giving up and throwing an exception", ConfigOption.Type.MASKABLE, 5);
    public static final ConfigOption<Integer> IDAUTHORITY_CAV_BITS = new ConfigOption<Integer>(IDAUTHORITY_NS, "conflict-avoidance-tag-bits", "Configures the number of bits of Titan-assigned element IDs that are reserved for the conflict avoidance tag", ConfigOption.Type.FIXED, 5, new Predicate<Integer>(){

        public boolean apply(@Nullable Integer uniqueIdBitWidth) {
            return uniqueIdBitWidth >= 0 && uniqueIdBitWidth <= 16;
        }
    });
    public static final ConfigOption<Integer> IDAUTHORITY_CAV_TAG = new ConfigOption<Integer>(IDAUTHORITY_NS, "conflict-avoidance-tag", "Conflict avoidance tag to be used by this Titan instance when allocating IDs", ConfigOption.Type.LOCAL, 0);
    public static final String INDEX_NAMESPACE = "index";
    public static final ConfigNamespace INDEX_NS = new ConfigNamespace(ROOT_NS, "index", "Configuration options for the individual indexing backends", true);
    public static final ConfigOption<String> INDEX_BACKEND = new ConfigOption<String>(INDEX_NS, "backend", "Define the indexing backed to use for index support", ConfigOption.Type.GLOBAL_OFFLINE, "elasticsearch");
    public static final ConfigOption<String> INDEX_DIRECTORY = new ConfigOption<String>(INDEX_NS, "directory", "Directory to store index data locally", ConfigOption.Type.GLOBAL_OFFLINE, String.class);
    public static final ConfigOption<String> INDEX_NAME = new ConfigOption<String>(INDEX_NS, "index-name", "Name of the index if required by the indexing backend", ConfigOption.Type.GLOBAL_OFFLINE, "titan");
    public static final ConfigOption<String[]> INDEX_HOSTS = new ConfigOption<String[]>(INDEX_NS, "hostname", "Hostname of the indexing backend", ConfigOption.Type.GLOBAL, new String[]{NetworkUtil.getLoopbackAddress()});
    public static final ConfigOption<Integer> INDEX_PORT = new ConfigOption<Integer>(INDEX_NS, "port", "Configuration key for the port on which to connect to remote indexing backend servers", ConfigOption.Type.MASKABLE, Integer.class);
    public static final ConfigOption<String> INDEX_CONF_FILE = new ConfigOption<String>(INDEX_NS, "conffile", "Path to a configuration file for those indexing backends that require/support a separate config file", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigNamespace LOG_NS = new ConfigNamespace(ROOT_NS, "log", "Configuration options for Titan's logging system", true);
    public static final String MANAGEMENT_LOG = "titan";
    public static final String TRANSACTION_LOG = "tx";
    public static final String TRIGGER_LOG = "trigger";
    public static final ConfigOption<String> LOG_BACKEND = new ConfigOption<String>(LOG_NS, "backend", "Define the log backed to use", ConfigOption.Type.GLOBAL_OFFLINE, "default");
    public static final ConfigOption<Integer> LOG_NUM_BUCKETS = new ConfigOption<Integer>(LOG_NS, "num-buckets", "The number of buckets to split log entries into for load balancing", ConfigOption.Type.GLOBAL_OFFLINE, 1, ConfigOption.positiveInt());
    public static final ConfigOption<Integer> LOG_SEND_BATCH_SIZE = new ConfigOption<Integer>(LOG_NS, "send-batch-size", "Maximum number of log messages to batch up for sending for logging implementations that support batch sending", ConfigOption.Type.MASKABLE, 256, ConfigOption.positiveInt());
    public static final ConfigOption<Integer> LOG_READ_BATCH_SIZE = new ConfigOption<Integer>(LOG_NS, "read-batch-size", "Maximum number of log messages to read at a time for logging implementations that read messages in batches", ConfigOption.Type.MASKABLE, 1024, ConfigOption.positiveInt());
    public static final ConfigOption<Duration> LOG_SEND_DELAY = new ConfigOption<StandardDuration>(LOG_NS, "send-delay", "Maximum time in ms that messages can be buffered locally before sending in batch", ConfigOption.Type.MASKABLE, Duration.class, new StandardDuration(1000L, TimeUnit.MILLISECONDS));
    public static final ConfigOption<Duration> LOG_READ_INTERVAL = new ConfigOption<StandardDuration>(LOG_NS, "read-interval", "Time in ms between message readings from the backend for this logging implementations that read message in batch", ConfigOption.Type.MASKABLE, Duration.class, new StandardDuration(5000L, TimeUnit.MILLISECONDS));
    public static final ConfigOption<Integer> LOG_READ_THREADS = new ConfigOption<Integer>(LOG_NS, "read-threads", "Number of threads to be used in reading and processing log messages", ConfigOption.Type.MASKABLE, 1, ConfigOption.positiveInt());
    public static final String ATTRIBUTE_NAMESPACE = "attributes";
    public static final ConfigNamespace ATTRIBUTE_NS = new ConfigNamespace(ROOT_NS, "attributes", "Configuration options for attribute handling");
    public static final ConfigOption<Boolean> ATTRIBUTE_ALLOW_ALL_SERIALIZABLE = new ConfigOption<Boolean>(ATTRIBUTE_NS, "allow-all", "Enables Titan to store any kind of attribute value in the database", ConfigOption.Type.GLOBAL_OFFLINE, true);
    public static final ConfigNamespace CUSTOM_ATTRIBUTE_NS = new ConfigNamespace(ATTRIBUTE_NS, "custom", "Custom attribute serialization and handling", true);
    public static final String ATTRIBUTE_PREFIX = "attribute";
    public static final ConfigOption<String> CUSTOM_ATTRIBUTE_CLASS = new ConfigOption<String>(CUSTOM_ATTRIBUTE_NS, "attribute-class", "Class of the custom attribute to be registered", ConfigOption.Type.GLOBAL_OFFLINE, String.class);
    public static final ConfigOption<String> CUSTOM_SERIALIZER_CLASS = new ConfigOption<String>(CUSTOM_ATTRIBUTE_NS, "serializer-class", "Class of the custom attribute serializer to be registered", ConfigOption.Type.GLOBAL_OFFLINE, String.class);
    public static final ConfigNamespace METRICS_NS = new ConfigNamespace(ROOT_NS, "metrics", "Configuration options for metrics reporting");
    public static final ConfigOption<Boolean> BASIC_METRICS = new ConfigOption<Boolean>(METRICS_NS, "enabled", "Whether to enable basic timing and operation count monitoring on backend", ConfigOption.Type.MASKABLE, false);
    public static final String METRICS_PREFIX_DEFAULT = "com.thinkaurelius.titan";
    public static final String METRICS_SYSTEM_PREFIX_DEFAULT = "com.thinkaurelius.titan.sys";
    public static final ConfigOption<String> METRICS_PREFIX = new ConfigOption<String>(METRICS_NS, "prefix", "The default name prefix for Metrics reported by Titan.", ConfigOption.Type.MASKABLE, "com.thinkaurelius.titan");
    public static final ConfigOption<Boolean> METRICS_MERGE_STORES = new ConfigOption<Boolean>(METRICS_NS, "merge-stores", "Whether to aggregate measurements for the edge store, vertex index, edge index, and ID store", ConfigOption.Type.MASKABLE, true);
    public static final ConfigNamespace METRICS_CONSOLE_NS = new ConfigNamespace(METRICS_NS, "console", "Configuration options for metrics reporting to console");
    public static final ConfigOption<Duration> METRICS_CONSOLE_INTERVAL = new ConfigOption<Duration>(METRICS_CONSOLE_NS, "interval", "Time between Metrics reports printing to the console, in milliseconds", ConfigOption.Type.MASKABLE, Duration.class);
    public static final ConfigNamespace METRICS_CSV_NS = new ConfigNamespace(METRICS_NS, "csv", "Configuration options for metrics reporting to CSV file");
    public static final ConfigOption<Duration> METRICS_CSV_INTERVAL = new ConfigOption<Duration>(METRICS_CSV_NS, "interval", "Time between dumps of CSV files containing Metrics data, in milliseconds", ConfigOption.Type.MASKABLE, Duration.class);
    public static final ConfigOption<String> METRICS_CSV_DIR = new ConfigOption<String>(METRICS_CSV_NS, "directory", "Metrics CSV output directory", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigNamespace METRICS_JMX_NS = new ConfigNamespace(METRICS_NS, "jmx", "Configuration options for metrics reporting through JMX");
    public static final ConfigOption<Boolean> METRICS_JMX_ENABLED = new ConfigOption<Boolean>(METRICS_JMX_NS, "enabled", "Whether to report Metrics through a JMX MBean", ConfigOption.Type.MASKABLE, false);
    public static final ConfigOption<String> METRICS_JMX_DOMAIN = new ConfigOption<String>(METRICS_JMX_NS, "domain", "The JMX domain in which to report Metrics", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigOption<String> METRICS_JMX_AGENTID = new ConfigOption<String>(METRICS_JMX_NS, "agentid", "The JMX agentId used by Metrics", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigNamespace METRICS_SLF4J_NS = new ConfigNamespace(METRICS_NS, "slf4j", "Configuration options for metrics reporting through slf4j");
    public static final ConfigOption<Duration> METRICS_SLF4J_INTERVAL = new ConfigOption<Duration>(METRICS_SLF4J_NS, "interval", "Time between slf4j logging reports of Metrics data, in milliseconds", ConfigOption.Type.MASKABLE, Duration.class);
    public static final ConfigOption<String> METRICS_SLF4J_LOGGER = new ConfigOption<String>(METRICS_SLF4J_NS, "logger", "The complete name of the Logger through which Metrics will report via Slf4j", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigNamespace METRICS_GANGLIA_NS = new ConfigNamespace(METRICS_NS, "ganglia", "Configuration options for metrics reporting through Ganglia");
    public static final ConfigOption<String> GANGLIA_HOST_OR_GROUP = new ConfigOption<String>(METRICS_GANGLIA_NS, "hostname", "The unicast host or multicast group name to which Metrics will send Ganglia data", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigOption<Duration> GANGLIA_INTERVAL = new ConfigOption<Duration>(METRICS_GANGLIA_NS, "interval", "The number of milliseconds to wait between sending Metrics data to Ganglia", ConfigOption.Type.MASKABLE, Duration.class);
    public static final ConfigOption<Integer> GANGLIA_PORT = new ConfigOption<Integer>(METRICS_GANGLIA_NS, "port", "The port to which Ganglia data are sent", ConfigOption.Type.MASKABLE, 8649);
    public static final ConfigOption<String> GANGLIA_ADDRESSING_MODE = new ConfigOption<String>(METRICS_GANGLIA_NS, "addressing-mode", "Whether to communicate to Ganglia via uni- or multicast", ConfigOption.Type.MASKABLE, "unicast", new Predicate<String>(){

        public boolean apply(@Nullable String s) {
            return s != null && s.equalsIgnoreCase("unicast") || s.equalsIgnoreCase("multicast");
        }
    });
    public static final ConfigOption<Integer> GANGLIA_TTL = new ConfigOption<Integer>(METRICS_GANGLIA_NS, "ttl", "The multicast TTL to set on outgoing Ganglia datagrams", ConfigOption.Type.MASKABLE, 1);
    public static final ConfigOption<Boolean> GANGLIA_USE_PROTOCOL_31 = new ConfigOption<Boolean>(METRICS_GANGLIA_NS, "protocol-31", "Whether to send data to Ganglia in the 3.1 protocol format", ConfigOption.Type.MASKABLE, true);
    public static final ConfigOption<String> GANGLIA_UUID = new ConfigOption<String>(METRICS_GANGLIA_NS, "uuid", "The host UUID to set on outgoing Ganglia datagrams. See https://github.com/ganglia/monitor-core/wiki/UUIDSources for information about this setting.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<String> GANGLIA_SPOOF = new ConfigOption<6>(METRICS_GANGLIA_NS, "spoof", "If non-null, it must be a valid Gmetric spoof string formatted as an IP:hostname pair. See http://sourceforge.net/apps/trac/ganglia/wiki/gmetric_spoofing for information about this setting.", ConfigOption.Type.MASKABLE, (Class<6>)String.class, new Predicate<String>(){

        public boolean apply(@Nullable String s) {
            return s != null && 0 < s.indexOf(58);
        }
    });
    public static final ConfigNamespace METRICS_GRAPHITE_NS = new ConfigNamespace(METRICS_NS, "graphite", "Configuration options for metrics reporting through Graphite");
    public static final ConfigOption<String> GRAPHITE_HOST = new ConfigOption<String>(METRICS_GRAPHITE_NS, "hostname", "The hostname to receive Graphite plaintext protocol metric data", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigOption<Duration> GRAPHITE_INTERVAL = new ConfigOption<Duration>(METRICS_GRAPHITE_NS, "interval", "The number of milliseconds to wait between sending Metrics data", ConfigOption.Type.MASKABLE, Duration.class);
    public static final ConfigOption<Integer> GRAPHITE_PORT = new ConfigOption<Integer>(METRICS_GRAPHITE_NS, "port", "The port to which Graphite data are sent", ConfigOption.Type.MASKABLE, 2003);
    public static final ConfigOption<String> GRAPHITE_PREFIX = new ConfigOption<String>(METRICS_GRAPHITE_NS, "prefix", "A Graphite-specific prefix for reported metrics", ConfigOption.Type.MASKABLE, String.class);
    public static final String SYSTEM_PROPERTIES_STORE_NAME = "system_properties";
    public static final String SYSTEM_CONFIGURATION_IDENTIFIER = "configuration";
    private final Configuration configuration;
    private final String uniqueGraphId;
    private boolean readOnly;
    private boolean flushIDs;
    private boolean forceIndexUsage;
    private boolean batchLoading;
    private int txVertexCacheSize;
    private int txDirtyVertexSize;
    private DefaultSchemaMaker defaultSchemaMaker;
    private Boolean propertyPrefetching;
    private boolean allowVertexIdSetting;
    private boolean logTransactions;
    private String metricsPrefix;
    private String unknownIndexKeyName;
    private StoreFeatures storeFeatures = null;
    private static final AtomicLong INSTANCE_COUNTER = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDatabaseConfiguration(ReadConfiguration localConfig) {
        Preconditions.checkNotNull((Object)localConfig);
        BasicConfiguration localbc = new BasicConfiguration(ROOT_NS, localConfig, BasicConfiguration.Restriction.NONE);
        ModifiableConfiguration overwrite = new ModifiableConfiguration(ROOT_NS, new CommonsConfiguration(), BasicConfiguration.Restriction.NONE);
        KeyColumnValueStoreManager storeManager = Backend.getStorageManager(localbc);
        ReadConfiguration globalConfig = null;
        try (KCVSConfiguration kcvsConfig = Backend.getStandaloneGlobalConfiguration(storeManager, localbc);){
            ModifiableConfiguration globalWrite;
            if (!localbc.has(ExpectedValueCheckingStore.LOCAL_LOCK_MEDIATOR_PREFIX, new String[0])) {
                overwrite.set(ExpectedValueCheckingStore.LOCAL_LOCK_MEDIATOR_PREFIX, storeManager.getName(), new String[0]);
            }
            if (!(globalWrite = new ModifiableConfiguration(ROOT_NS, kcvsConfig, BasicConfiguration.Restriction.GLOBAL)).isFrozen()) {
                Map<ConfigElement.PathIdentifier, Object> allOptions = localbc.getAll();
                globalWrite.setAll(Maps.filterEntries(allOptions, (Predicate)new Predicate<Map.Entry<ConfigElement.PathIdentifier, Object>>(){

                    public boolean apply(@Nullable Map.Entry<ConfigElement.PathIdentifier, Object> entry) {
                        assert (entry.getKey().element.isOption());
                        return ((ConfigOption)entry.getKey().element).isGlobal();
                    }
                }));
                Preconditions.checkArgument((!globalWrite.has(INITIAL_TITAN_VERSION, new String[0]) ? 1 : 0) != 0, (Object)"Database has already been initialized but not frozen");
                globalWrite.set(INITIAL_TITAN_VERSION, TitanConstants.VERSION, new String[0]);
                if (!localbc.has(CLUSTER_PARTITION, new String[0])) {
                    StoreFeatures f = storeManager.getFeatures();
                    boolean part = f.isDistributed() && f.isKeyOrdered();
                    globalWrite.set(CLUSTER_PARTITION, part, new String[0]);
                    log.info("Enabled partitioning", (Object)part);
                } else {
                    log.info("Disabled partitioning");
                }
                globalWrite.freezeConfiguration();
            } else {
                String version = globalWrite.get(INITIAL_TITAN_VERSION, new String[0]);
                Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"Titan version has not been initialized");
                if (!TitanConstants.VERSION.equals(version) && !TitanConstants.COMPATIBLE_VERSIONS.contains(version)) {
                    throw new TitanException("StorageBackend version is incompatible with current Titan version: " + version + " vs. " + TitanConstants.VERSION);
                }
            }
            globalConfig = kcvsConfig.asReadConfiguration();
        }
        MixedConfiguration combinedConfig = new MixedConfiguration(ROOT_NS, globalConfig, localConfig);
        this.uniqueGraphId = GraphDatabaseConfiguration.getOrGenerateUniqueInstanceId(combinedConfig);
        overwrite.set(UNIQUE_INSTANCE_ID, this.uniqueGraphId, new String[0]);
        Preconditions.checkArgument((!combinedConfig.has(LOG_SEND_DELAY, TRANSACTION_LOG) || combinedConfig.get(LOG_SEND_DELAY, TRANSACTION_LOG).isZeroLength() ? 1 : 0) != 0, (Object)"Send delay must be 0 for transaction log.");
        overwrite.set(LOG_SEND_DELAY, ZeroDuration.INSTANCE, TRANSACTION_LOG);
        Preconditions.checkArgument((boolean)combinedConfig.get(LOG_BACKEND, MANAGEMENT_LOG).equals(LOG_BACKEND.getDefaultValue()), (Object)"Must use default log backend for system log");
        Preconditions.checkArgument((!combinedConfig.has(LOG_SEND_DELAY, MANAGEMENT_LOG) || combinedConfig.get(LOG_SEND_DELAY, MANAGEMENT_LOG).isZeroLength() ? 1 : 0) != 0, (Object)"Send delay must be 0 for system log.");
        overwrite.set(LOG_SEND_DELAY, ZeroDuration.INSTANCE, MANAGEMENT_LOG);
        Preconditions.checkArgument((!combinedConfig.has(KCVSLog.LOG_KEY_CONSISTENT, MANAGEMENT_LOG) || combinedConfig.get(KCVSLog.LOG_KEY_CONSISTENT, MANAGEMENT_LOG) != false ? 1 : 0) != 0, (Object)"Management log must be configured to be key-consistent");
        overwrite.set(KCVSLog.LOG_KEY_CONSISTENT, true, MANAGEMENT_LOG);
        Preconditions.checkArgument((!combinedConfig.has(KCVSLogManager.LOG_FIXED_PARTITION, MANAGEMENT_LOG) || combinedConfig.get(KCVSLogManager.LOG_FIXED_PARTITION, MANAGEMENT_LOG) != false ? 1 : 0) != 0, (Object)"Fixed partitions must be enabled for management log");
        overwrite.set(KCVSLogManager.LOG_FIXED_PARTITION, true, MANAGEMENT_LOG);
        this.configuration = new MergedConfiguration(overwrite, combinedConfig);
        this.preLoadConfiguration();
    }

    private static String computeUniqueInstanceId(Configuration config) {
        byte[] addrBytes;
        String suffix = config.has(UNIQUE_INSTANCE_ID_SUFFIX, new String[0]) ? LongEncoding.encode(config.get(UNIQUE_INSTANCE_ID_SUFFIX, new String[0]).shortValue()) : ManagementFactory.getRuntimeMXBean().getName() + LongEncoding.encode(INSTANCE_COUNTER.incrementAndGet());
        try {
            addrBytes = Inet4Address.getLocalHost().getAddress();
        }
        catch (UnknownHostException e) {
            throw new TitanConfigurationException("Cannot determine local host", e);
        }
        String uid = new String(Hex.encodeHex((byte[])addrBytes)) + suffix;
        for (char c : ConfigElement.ILLEGAL_CHARS) {
            uid = StringUtils.replaceChars((String)uid, (char)c, (char)'-');
        }
        return uid;
    }

    public static String getOrGenerateUniqueInstanceId(Configuration config) {
        String uid;
        if (!config.has(UNIQUE_INSTANCE_ID, new String[0])) {
            uid = GraphDatabaseConfiguration.computeUniqueInstanceId(config);
            log.info("Generated {}={}", (Object)UNIQUE_INSTANCE_ID.getName(), (Object)uid);
        } else {
            uid = config.get(UNIQUE_INSTANCE_ID, new String[0]);
        }
        Preconditions.checkArgument((!StringUtils.containsAny((String)uid, (char[])ConfigElement.ILLEGAL_CHARS) ? 1 : 0) != 0, (String)"Invalid unique identifier: %s", (Object[])new Object[]{uid});
        return uid;
    }

    public static final ModifiableConfiguration buildConfiguration() {
        return new ModifiableConfiguration(ROOT_NS, new CommonsConfiguration((org.apache.commons.configuration.Configuration)new BaseConfiguration()), BasicConfiguration.Restriction.NONE);
    }

    public static final String getSystemMetricsPrefix() {
        return METRICS_SYSTEM_PREFIX_DEFAULT;
    }

    public static ModifiableConfiguration getGlobalSystemConfig(Backend backend) {
        return new ModifiableConfiguration(ROOT_NS, backend.getGlobalSystemConfig(), BasicConfiguration.Restriction.GLOBAL);
    }

    private void preLoadConfiguration() {
        this.readOnly = this.configuration.get(STORAGE_READONLY, new String[0]);
        this.flushIDs = this.configuration.get(IDS_FLUSH, new String[0]);
        this.forceIndexUsage = this.configuration.get(FORCE_INDEX_USAGE, new String[0]);
        this.batchLoading = this.configuration.get(STORAGE_BATCH, new String[0]);
        this.defaultSchemaMaker = preregisteredAutoType.get(this.configuration.get(AUTO_TYPE, new String[0]));
        if (this.batchLoading) {
            this.defaultSchemaMaker = DisableDefaultSchemaMaker.INSTANCE;
        }
        this.txVertexCacheSize = this.configuration.get(TX_CACHE_SIZE, new String[0]);
        this.txDirtyVertexSize = this.configuration.has(TX_DIRTY_SIZE, new String[0]) ? this.configuration.get(TX_DIRTY_SIZE, new String[0]) : (this.batchLoading ? 4096 : 32);
        this.propertyPrefetching = this.configuration.has(PROPERTY_PREFETCHING, new String[0]) ? this.configuration.get(PROPERTY_PREFETCHING, new String[0]) : null;
        this.allowVertexIdSetting = this.configuration.get(ALLOW_SETTING_VERTEX_ID, new String[0]);
        this.logTransactions = this.configuration.get(SYSTEM_LOG_TRANSACTIONS, new String[0]);
        this.unknownIndexKeyName = this.configuration.get(IGNORE_UNKNOWN_INDEX_FIELD, new String[0]) != false ? UKNOWN_FIELD_NAME : null;
        this.configureMetrics();
    }

    private void configureMetrics() {
        Preconditions.checkNotNull((Object)this.configuration);
        this.metricsPrefix = this.configuration.get(METRICS_PREFIX, new String[0]);
        if (!this.configuration.get(BASIC_METRICS, new String[0]).booleanValue()) {
            this.metricsPrefix = null;
        } else {
            Preconditions.checkNotNull((Object)this.metricsPrefix);
        }
        this.configureMetricsConsoleReporter();
        this.configureMetricsCsvReporter();
        this.configureMetricsJmxReporter();
        this.configureMetricsSlf4jReporter();
        this.configureMetricsGangliaReporter();
        this.configureMetricsGraphiteReporter();
    }

    private void configureMetricsConsoleReporter() {
        if (this.configuration.has(METRICS_CONSOLE_INTERVAL, new String[0])) {
            MetricManager.INSTANCE.addConsoleReporter(this.configuration.get(METRICS_CONSOLE_INTERVAL, new String[0]));
        }
    }

    private void configureMetricsCsvReporter() {
        if (this.configuration.has(METRICS_CSV_DIR, new String[0])) {
            MetricManager.INSTANCE.addCsvReporter(this.configuration.get(METRICS_CSV_INTERVAL, new String[0]), this.configuration.get(METRICS_CSV_DIR, new String[0]));
        }
    }

    private void configureMetricsJmxReporter() {
        if (this.configuration.get(METRICS_JMX_ENABLED, new String[0]).booleanValue()) {
            MetricManager.INSTANCE.addJmxReporter(this.configuration.get(METRICS_JMX_DOMAIN, new String[0]), this.configuration.get(METRICS_JMX_AGENTID, new String[0]));
        }
    }

    private void configureMetricsSlf4jReporter() {
        if (this.configuration.has(METRICS_SLF4J_INTERVAL, new String[0])) {
            MetricManager.INSTANCE.addSlf4jReporter(this.configuration.get(METRICS_SLF4J_INTERVAL, new String[0]), this.configuration.has(METRICS_SLF4J_LOGGER, new String[0]) ? this.configuration.get(METRICS_SLF4J_LOGGER, new String[0]) : null);
        }
    }

    private void configureMetricsGangliaReporter() {
        if (this.configuration.has(GANGLIA_HOST_OR_GROUP, new String[0])) {
            GMetric.UDPAddressingMode addrMode;
            String host = this.configuration.get(GANGLIA_HOST_OR_GROUP, new String[0]);
            Duration ival = this.configuration.get(GANGLIA_INTERVAL, new String[0]);
            Integer port = this.configuration.get(GANGLIA_PORT, new String[0]);
            String addrModeStr = this.configuration.get(GANGLIA_ADDRESSING_MODE, new String[0]);
            if (addrModeStr.equalsIgnoreCase("multicast")) {
                addrMode = GMetric.UDPAddressingMode.MULTICAST;
            } else if (addrModeStr.equalsIgnoreCase("unicast")) {
                addrMode = GMetric.UDPAddressingMode.UNICAST;
            } else {
                throw new AssertionError();
            }
            Boolean proto31 = this.configuration.get(GANGLIA_USE_PROTOCOL_31, new String[0]);
            int ttl = this.configuration.get(GANGLIA_TTL, new String[0]);
            UUID uuid = this.configuration.has(GANGLIA_UUID, new String[0]) ? UUID.fromString(this.configuration.get(GANGLIA_UUID, new String[0])) : null;
            String spoof = null;
            if (this.configuration.has(GANGLIA_SPOOF, new String[0])) {
                spoof = this.configuration.get(GANGLIA_SPOOF, new String[0]);
            }
            try {
                MetricManager.INSTANCE.addGangliaReporter(host, port, addrMode, ttl, proto31, uuid, spoof, ival);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void configureMetricsGraphiteReporter() {
        if (this.configuration.has(GRAPHITE_HOST, new String[0])) {
            MetricManager.INSTANCE.addGraphiteReporter(this.configuration.get(GRAPHITE_HOST, new String[0]), this.configuration.get(GRAPHITE_PORT, new String[0]), this.configuration.get(GRAPHITE_PREFIX, new String[0]), this.configuration.get(GRAPHITE_INTERVAL, new String[0]));
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean hasFlushIDs() {
        return this.flushIDs;
    }

    public boolean hasForceIndexUsage() {
        return this.forceIndexUsage;
    }

    public int getTxVertexCacheSize() {
        return this.txVertexCacheSize;
    }

    public int getTxDirtyVertexSize() {
        return this.txDirtyVertexSize;
    }

    public boolean isBatchLoading() {
        return this.batchLoading;
    }

    public String getUniqueGraphId() {
        return this.uniqueGraphId;
    }

    public String getMetricsPrefix() {
        return this.metricsPrefix;
    }

    public DefaultSchemaMaker getDefaultSchemaMaker() {
        return this.defaultSchemaMaker;
    }

    public boolean allowVertexIdSetting() {
        return this.allowVertexIdSetting;
    }

    public boolean hasPropertyPrefetching() {
        if (this.propertyPrefetching == null) {
            return this.getStoreFeatures().isDistributed();
        }
        return this.propertyPrefetching;
    }

    public String getUnknownIndexKeyName() {
        return this.unknownIndexKeyName;
    }

    public boolean hasLogTransactions() {
        return this.logTransactions;
    }

    public TimestampProvider getTimestampProvider() {
        return this.configuration.get(TIMESTAMP_PROVIDER, new String[0]);
    }

    public static List<RegisteredAttributeClass<?>> getRegisteredAttributeClasses(Configuration configuration) {
        ArrayList all = new ArrayList();
        for (String attributeId : configuration.getContainedNamespaces(CUSTOM_ATTRIBUTE_NS, new String[0])) {
            Preconditions.checkArgument((boolean)attributeId.startsWith(ATTRIBUTE_PREFIX), (String)"Invalid attribute definition: %s", (Object[])new Object[]{attributeId});
            try {
                int position = Integer.parseInt(attributeId.substring(ATTRIBUTE_PREFIX.length()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected entry of the form [attributeX] where X is a number but given" + attributeId);
            }
            Class<?> clazz = null;
            AttributeHandler serializer = null;
            String classname = configuration.get(CUSTOM_ATTRIBUTE_CLASS, attributeId);
            try {
                clazz = Class.forName(classname);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find attribute class" + classname, e);
            }
            Preconditions.checkNotNull(clazz);
            Preconditions.checkArgument((boolean)configuration.has(CUSTOM_SERIALIZER_CLASS, attributeId));
            String serializername = configuration.get(CUSTOM_SERIALIZER_CLASS, attributeId);
            try {
                Class<?> sclass = Class.forName(serializername);
                serializer = (AttributeHandler)sclass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find serializer class" + serializername);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Could not instantiate serializer class" + serializername, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not instantiate serializer class" + serializername, e);
            }
            Preconditions.checkNotNull((Object)serializer);
            RegisteredAttributeClass reg = new RegisteredAttributeClass(clazz, serializer);
            for (int i = 0; i < all.size(); ++i) {
                if (!((RegisteredAttributeClass)all.get(i)).equals(reg)) continue;
                throw new IllegalArgumentException("Duplicate attribute registration: " + all.get(i) + " and " + reg);
            }
            all.add(reg);
        }
        return all;
    }

    public VertexIDAssigner getIDAssigner(Backend backend) {
        return new VertexIDAssigner(this.configuration, backend.getIDAuthority(), backend.getStoreFeatures());
    }

    public String getBackendDescription() {
        String clazzname = this.configuration.get(STORAGE_BACKEND, new String[0]);
        if (clazzname.equalsIgnoreCase("berkeleyje")) {
            return clazzname + ":" + this.configuration.get(STORAGE_DIRECTORY, new String[0]);
        }
        return clazzname + ":" + Arrays.toString(this.configuration.get(STORAGE_HOSTS, new String[0]));
    }

    public Backend getBackend() {
        Backend backend = new Backend(this.configuration);
        backend.initialize(this.configuration);
        this.storeFeatures = backend.getStoreFeatures();
        return backend;
    }

    public StoreFeatures getStoreFeatures() {
        Preconditions.checkArgument((this.storeFeatures != null ? 1 : 0) != 0, (Object)"Cannot retrieve store features before the storage backend has been initialized");
        return this.storeFeatures;
    }

    public Serializer getSerializer() {
        return GraphDatabaseConfiguration.getSerializer(this.configuration);
    }

    public static Serializer getSerializer(Configuration configuration) {
        StandardSerializer serializer = new StandardSerializer(configuration.get(ATTRIBUTE_ALLOW_ALL_SERIALIZABLE, new String[0]));
        for (RegisteredAttributeClass<?> clazz : GraphDatabaseConfiguration.getRegisteredAttributeClasses(configuration)) {
            clazz.registerWith(serializer);
        }
        return serializer;
    }

    public boolean hasSerializeAll() {
        return this.configuration.get(ATTRIBUTE_ALLOW_ALL_SERIALIZABLE, new String[0]);
    }

    public SchemaCache getTypeCache(SchemaCache.StoreRetrieval retriever) {
        if (this.configuration.get(BASIC_METRICS, new String[0]).booleanValue()) {
            return new MetricInstrumentedSchemaCache(retriever);
        }
        return new StandardSchemaCache(retriever);
    }

    public File getHomeDirectory() {
        if (!this.configuration.has(STORAGE_DIRECTORY, new String[0])) {
            throw new UnsupportedOperationException("No home directory specified");
        }
        File dir = new File(this.configuration.get(STORAGE_DIRECTORY, new String[0]));
        Preconditions.checkArgument((boolean)dir.isDirectory(), (Object)"Not a directory");
        return dir;
    }

    public String getHomePath() {
        return GraphDatabaseConfiguration.getPath(this.getHomeDirectory());
    }

    private static File getSubDirectory(String base, String sub) {
        File subdir = new File(base, sub);
        if (!subdir.exists() && !subdir.mkdir()) {
            throw new IllegalArgumentException("Cannot create subdirectory: " + sub);
        }
        assert (subdir.exists() && subdir.isDirectory());
        return subdir;
    }

    private static String getFileName(String dir, String file) {
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        return dir + file;
    }

    public static String getPath(File dir) {
        return dir.getAbsolutePath() + File.separator;
    }

    static boolean existsFile(String file) {
        return new File(file).isFile();
    }
}

