/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util.time;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.attribute.Timestamp;
import com.thinkaurelius.titan.diskstorage.util.time.Durations;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTimestamp
implements Timestamp {
    private static final Logger log = LoggerFactory.getLogger(StandardTimestamp.class);
    private final long sinceEpoch;
    private final TimeUnit unit;

    public StandardTimestamp(long sinceEpoch, TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit));
        this.sinceEpoch = sinceEpoch;
        this.unit = unit;
    }

    @Override
    public int compareTo(Timestamp o) {
        return Durations.compare(this.sinceEpoch, this.unit, o.sinceEpoch(o.getNativeUnit()), o.getNativeUnit());
    }

    @Override
    public long sinceEpoch(TimeUnit target) {
        return target.convert(this.sinceEpoch, this.unit);
    }

    @Override
    public TimeUnit getNativeUnit() {
        return this.unit;
    }

    public int hashCode() {
        return 527 + (int)(this.sinceEpoch ^ this.sinceEpoch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardTimestamp other = (StandardTimestamp)obj;
        return other.sinceEpoch(this.unit) == this.sinceEpoch;
    }

    public String toString() {
        return String.format("Timestamp[%d %s]", this.sinceEpoch, Durations.abbreviate(this.unit));
    }
}

