/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.log;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.diskstorage.util.time.Timestamps;
import java.util.concurrent.TimeUnit;

public class ReadMarker {
    private final String identifier;
    private final long sinceEpoch;
    private final TimeUnit unit;

    private ReadMarker(String identifier, long sinceEpoch, TimeUnit unit) {
        this.identifier = identifier;
        this.sinceEpoch = sinceEpoch;
        this.unit = unit;
    }

    public boolean hasIdentifier() {
        return this.identifier != null;
    }

    public String getIdentifier() {
        Preconditions.checkArgument((this.identifier != null ? 1 : 0) != 0, (Object)"ReadMarker does not have a configured identifier");
        return this.identifier;
    }

    public Timepoint getStartTime(TimestampProvider times) {
        assert (null != this.unit);
        return times.getTime(this.sinceEpoch, this.unit);
    }

    public static ReadMarker fromNow() {
        return new ReadMarker(null, Timestamps.MICRO.getTime().getTimestamp(TimeUnit.MICROSECONDS), TimeUnit.MICROSECONDS);
    }

    public static ReadMarker fromTime(long timestamp, TimeUnit unit) {
        return new ReadMarker(null, timestamp, unit);
    }

    public static ReadMarker fromIdentifierOrTime(String id, long timestamp, TimeUnit unit) {
        return new ReadMarker(id, timestamp, unit);
    }
}

