/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking.consistentkey;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.locking.PermanentLockingException;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingStore;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.KeyColumn;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectedValueCheckingTransaction
implements StoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(ExpectedValueCheckingTransaction.class);
    private boolean isMutationStarted;
    private final StoreTransaction lockTx;
    private final StoreTransaction dataTx;
    private final Duration maxReadTime;
    private final Map<ExpectedValueCheckingStore, Map<KeyColumn, StaticBuffer>> expectedValuesByStore = new HashMap<ExpectedValueCheckingStore, Map<KeyColumn, StaticBuffer>>();

    public ExpectedValueCheckingTransaction(StoreTransaction dataTx, StoreTransaction lockTx, Duration maxReadTime) {
        this.dataTx = dataTx;
        this.lockTx = lockTx;
        this.maxReadTime = maxReadTime;
    }

    StoreTransaction getDataTransaction() {
        return this.dataTx;
    }

    StoreTransaction getLockTransaction() {
        return this.lockTx;
    }

    private void lockedOn(ExpectedValueCheckingStore store) {
        Map<KeyColumn, StaticBuffer> m = this.expectedValuesByStore.get(store);
        if (null == m) {
            m = new HashMap<KeyColumn, StaticBuffer>();
            this.expectedValuesByStore.put(store, m);
        }
    }

    void storeExpectedValue(ExpectedValueCheckingStore store, KeyColumn lockID, StaticBuffer value) {
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkNotNull((Object)lockID);
        this.lockedOn(store);
        Map<KeyColumn, StaticBuffer> m = this.expectedValuesByStore.get(store);
        assert (null != m);
        if (m.containsKey(lockID)) {
            log.debug("Multiple expected values for {}: keeping initial value {} and discarding later value {}", new Object[]{lockID, m.get(lockID), value});
        } else {
            m.put(lockID, value);
            log.debug("Store expected value for {}: {}", (Object)lockID, (Object)value);
        }
    }

    void checkExpectedValues() throws StorageException {
        for (ExpectedValueCheckingStore store : this.expectedValuesByStore.keySet()) {
            Map<KeyColumn, StaticBuffer> m = this.expectedValuesByStore.get(store);
            for (KeyColumn kc : m.keySet()) {
                this.checkSingleExpectedValue(kc, m.get(kc), store);
            }
        }
    }

    private void checkSingleExpectedValue(final KeyColumn kc, final StaticBuffer ev, final ExpectedValueCheckingStore store) throws StorageException {
        BackendOperation.executeDirect(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ExpectedValueCheckingTransaction.this.checkSingleExpectedValueUnsafe(kc, ev, store);
                return true;
            }

            public String toString() {
                return "ExpectedValueChecking";
            }
        }, this.maxReadTime);
    }

    private void checkSingleExpectedValueUnsafe(final KeyColumn kc, StaticBuffer ev, ExpectedValueCheckingStore store) throws StorageException {
        Iterable avList;
        ImmutableList evList;
        KeySliceQuery ksq = new KeySliceQuery(kc.getKey(), kc.getColumn(), BufferUtil.nextBiggerBuffer(kc.getColumn()));
        EntryList actualEntries = store.getSlice(ksq, this);
        if (null == actualEntries) {
            actualEntries = ImmutableList.of();
        }
        if (!Iterables.elementsEqual((Iterable)(evList = null == ev ? ImmutableList.of() : ImmutableList.of((Object)ev)), (Iterable)(avList = Iterables.transform((Iterable)actualEntries, (Function)new Function<Entry, StaticBuffer>(){

            public StaticBuffer apply(Entry e) {
                assert (e.getColumnAs(StaticBuffer.STATIC_FACTORY).equals(kc.getColumn()));
                return e.getValueAs(StaticBuffer.STATIC_FACTORY);
            }
        })))) {
            throw new PermanentLockingException("Expected value mismatch for " + kc + ": expected=" + evList + " vs actual=" + avList + " (store=" + store.getName() + ")");
        }
    }

    private void deleteAllLocks() throws StorageException {
        for (ExpectedValueCheckingStore s : this.expectedValuesByStore.keySet()) {
            s.deleteLocks(this);
        }
    }

    @Override
    public void rollback() throws StorageException {
        this.deleteAllLocks();
        this.dataTx.rollback();
        this.lockTx.rollback();
    }

    @Override
    public void commit() throws StorageException {
        this.dataTx.commit();
        this.deleteAllLocks();
        this.lockTx.commit();
    }

    public boolean isMutationStarted() {
        return this.isMutationStarted;
    }

    public void mutationStarted() {
        this.isMutationStarted = true;
    }

    @Override
    public BaseTransactionConfig getConfiguration() {
        return this.dataTx.getConfiguration();
    }
}

