/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking.consistentkey;

import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.configuration.MergedConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StandardStoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.locking.LockerProvider;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingStore;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingTransaction;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExpectedValueCheckingStoreManager
implements KeyColumnValueStoreManager {
    private final KeyColumnValueStoreManager storeManager;
    private final String lockStoreSuffix;
    private final LockerProvider lockerProvider;
    private final Duration maxReadTime;
    private final StoreFeatures storeFeatures;
    private final Map<String, ExpectedValueCheckingStore> stores;

    public ExpectedValueCheckingStoreManager(KeyColumnValueStoreManager storeManager, String lockStoreSuffix, LockerProvider lockerProvider, Duration maxReadTime) {
        this.storeManager = storeManager;
        this.lockStoreSuffix = lockStoreSuffix;
        this.lockerProvider = lockerProvider;
        this.maxReadTime = maxReadTime;
        this.storeFeatures = storeManager.getFeatures();
        this.stores = new HashMap<String, ExpectedValueCheckingStore>(6);
    }

    @Override
    public synchronized KeyColumnValueStore openDatabase(String name) throws StorageException {
        if (this.stores.containsKey(name)) {
            return this.stores.get(name);
        }
        KeyColumnValueStore store = this.storeManager.openDatabase(name);
        String lockerName = store.getName() + this.lockStoreSuffix;
        ExpectedValueCheckingStore wrappedStore = new ExpectedValueCheckingStore(store, this.lockerProvider.getLocker(lockerName));
        this.stores.put(name, wrappedStore);
        return wrappedStore;
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws StorageException {
        for (String store : mutations.keySet()) {
            this.stores.get(store).verifyLocksOnMutations(txh);
        }
        this.storeManager.mutateMany(mutations, ExpectedValueCheckingStore.getDataTx(txh));
    }

    @Override
    public StoreTransaction beginTransaction(BaseTransactionConfig configuration) throws StorageException {
        StoreTransaction tx = this.storeManager.beginTransaction(configuration);
        MergedConfiguration customOptions = new MergedConfiguration(this.storeFeatures.getKeyConsistentTxConfig(), configuration.getCustomOptions());
        StandardBaseTransactionConfig consistentTxCfg = new StandardBaseTransactionConfig.Builder(configuration).customOptions(customOptions).build();
        StoreTransaction consistentTx = this.storeManager.beginTransaction(consistentTxCfg);
        ExpectedValueCheckingTransaction wrappedTx = new ExpectedValueCheckingTransaction(tx, consistentTx, this.maxReadTime);
        return wrappedTx;
    }

    @Override
    public void close() throws StorageException {
        this.storeManager.close();
    }

    @Override
    public void clearStorage() throws StorageException {
        this.storeManager.clearStorage();
    }

    @Override
    public List<KeyRange> getLocalKeyPartition() throws StorageException {
        return this.storeManager.getLocalKeyPartition();
    }

    @Override
    public StoreFeatures getFeatures() {
        StandardStoreFeatures features = new StandardStoreFeatures.Builder(this.storeFeatures).locking(true).build();
        return features;
    }

    @Override
    public String getName() {
        return this.storeManager.getName();
    }
}

