/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking.consistentkey;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.locking.Locker;
import com.thinkaurelius.titan.diskstorage.locking.PermanentLockingException;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingTransaction;
import com.thinkaurelius.titan.diskstorage.util.KeyColumn;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectedValueCheckingStore
implements KeyColumnValueStore {
    public static final ConfigOption<String> LOCAL_LOCK_MEDIATOR_PREFIX = new ConfigOption<String>(GraphDatabaseConfiguration.STORAGE_NS, "local-lock-mediator-prefix", "Local prefix to disambiguate multiple local titan instances", ConfigOption.Type.LOCAL, String.class);
    private static final Logger log = LoggerFactory.getLogger(ExpectedValueCheckingStore.class);
    final KeyColumnValueStore dataStore;
    final Locker locker;

    public ExpectedValueCheckingStore(KeyColumnValueStore dataStore, Locker locker) {
        Preconditions.checkNotNull((Object)dataStore);
        this.dataStore = dataStore;
        this.locker = locker;
    }

    public KeyColumnValueStore getDataStore() {
        return this.dataStore;
    }

    static StoreTransaction getDataTx(StoreTransaction t) {
        Preconditions.checkNotNull((Object)t);
        Preconditions.checkArgument((boolean)(t instanceof ExpectedValueCheckingTransaction));
        return ((ExpectedValueCheckingTransaction)t).getDataTransaction();
    }

    static StoreTransaction getLockTx(StoreTransaction t) {
        Preconditions.checkNotNull((Object)t);
        Preconditions.checkArgument((boolean)(t instanceof ExpectedValueCheckingTransaction));
        return ((ExpectedValueCheckingTransaction)t).getLockTransaction();
    }

    @Override
    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws StorageException {
        return this.dataStore.getSlice(query, ExpectedValueCheckingStore.getDataTx(txh));
    }

    @Override
    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws StorageException {
        return this.dataStore.getSlice(keys, query, ExpectedValueCheckingStore.getDataTx(txh));
    }

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws StorageException {
        this.verifyLocksOnMutations(txh);
        this.dataStore.mutate(key, additions, deletions, ExpectedValueCheckingStore.getDataTx(txh));
    }

    void verifyLocksOnMutations(StoreTransaction txh) throws StorageException {
        ExpectedValueCheckingTransaction tx;
        if (this.locker != null && !(tx = (ExpectedValueCheckingTransaction)txh).isMutationStarted()) {
            tx.mutationStarted();
            this.locker.checkLocks(ExpectedValueCheckingStore.getLockTx(tx));
            tx.checkExpectedValues();
        }
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws StorageException {
        if (this.locker != null) {
            ExpectedValueCheckingTransaction tx = (ExpectedValueCheckingTransaction)txh;
            if (tx.isMutationStarted()) {
                throw new PermanentLockingException("Attempted to obtain a lock after mutations had been persisted");
            }
            KeyColumn lockID = new KeyColumn(key, column);
            log.debug("Attempting to acquireLock on {} ev={}", (Object)lockID, (Object)expectedValue);
            this.locker.writeLock(lockID, tx.getLockTransaction());
            tx.storeExpectedValue(this, lockID, expectedValue);
        } else {
            this.dataStore.acquireLock(key, column, expectedValue, ExpectedValueCheckingStore.getDataTx(txh));
        }
    }

    @Override
    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) throws StorageException {
        return this.dataStore.getKeys(query, ExpectedValueCheckingStore.getDataTx(txh));
    }

    @Override
    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) throws StorageException {
        return this.dataStore.getKeys(query, ExpectedValueCheckingStore.getDataTx(txh));
    }

    @Override
    public String getName() {
        return this.dataStore.getName();
    }

    @Override
    public void close() throws StorageException {
        this.dataStore.close();
    }

    void deleteLocks(ExpectedValueCheckingTransaction tx) throws StorageException {
        this.locker.deleteLocks(tx.getLockTransaction());
    }
}

