/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking.consistentkey;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.TitanConfigurationException;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.locking.AbstractLocker;
import com.thinkaurelius.titan.diskstorage.locking.LocalLockMediator;
import com.thinkaurelius.titan.diskstorage.locking.LocalLockMediators;
import com.thinkaurelius.titan.diskstorage.locking.Locker;
import com.thinkaurelius.titan.diskstorage.locking.LockerState;
import com.thinkaurelius.titan.diskstorage.locking.PermanentLockingException;
import com.thinkaurelius.titan.diskstorage.locking.TemporaryLockingException;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ConsistentKeyLockStatus;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ConsistentKeyLockerSerializer;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingStore;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.LockCleanerService;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.StandardLockCleanerService;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.TimestampRid;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.KeyColumn;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.Timer;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentKeyLocker
extends AbstractLocker<ConsistentKeyLockStatus>
implements Locker {
    private final KeyColumnValueStore store;
    private final StoreManager manager;
    private final Duration lockWait;
    private final int lockRetryCount;
    private final LockCleanerService cleanerService;
    private static final StaticBuffer zeroBuf = BufferUtil.getIntBuffer(0);
    public static final StaticBuffer LOCK_COL_START = BufferUtil.zeroBuffer(9);
    public static final StaticBuffer LOCK_COL_END = BufferUtil.oneBuffer(9);
    private static final Logger log = LoggerFactory.getLogger(ConsistentKeyLocker.class);

    private ConsistentKeyLocker(KeyColumnValueStore store, StoreManager manager, StaticBuffer rid, TimestampProvider times, ConsistentKeyLockerSerializer serializer, LocalLockMediator<StoreTransaction> llm, Duration lockWait, int lockRetryCount, Duration lockExpire, LockerState<ConsistentKeyLockStatus> lockState, LockCleanerService cleanerService) {
        super(rid, times, serializer, llm, lockState, lockExpire, log);
        this.store = store;
        this.manager = manager;
        this.lockWait = lockWait;
        this.lockRetryCount = lockRetryCount;
        this.cleanerService = cleanerService;
    }

    @Override
    protected ConsistentKeyLockStatus writeSingleLock(KeyColumn lockID, StoreTransaction txh) throws Throwable {
        StaticBuffer lockKey = this.serializer.toLockKey(lockID.getKey(), lockID.getColumn());
        StaticBuffer oldLockCol = null;
        for (int i = 0; i < this.lockRetryCount; ++i) {
            WriteResult wr = this.tryWriteLockOnce(lockKey, oldLockCol, txh);
            if (wr.isSuccessful() && wr.getDuration().compareTo(this.lockWait) <= 0) {
                Timepoint writeInstant = wr.getWriteTimestamp();
                Timepoint expireInstant = writeInstant.add(this.lockExpire);
                return new ConsistentKeyLockStatus(writeInstant, expireInstant);
            }
            oldLockCol = wr.getLockCol();
            this.handleMutationFailure(lockID, lockKey, wr, txh);
        }
        this.tryDeleteLockOnce(lockKey, oldLockCol, txh);
        throw new TemporaryStorageException("Lock write retry count exceeded");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleMutationFailure(KeyColumn lockID, StaticBuffer lockKey, WriteResult wr, StoreTransaction txh) throws Throwable {
        Throwable error = wr.getThrowable();
        if (null == error) {
            log.warn("Lock write succeeded but took too long: duration {} exceeded limit {}", (Object)wr.getDuration(), (Object)this.lockWait);
            return;
        }
        if (error instanceof TemporaryStorageException) {
            log.warn("Temporary exception during lock write", error);
            return;
        }
        log.error("Fatal exception encountered during attempted lock write", error);
        WriteResult dwr = this.tryDeleteLockOnce(lockKey, wr.getLockCol(), txh);
        if (dwr.isSuccessful()) throw error;
        log.warn("Failed to delete lock write: abandoning potentially-unreleased lock on " + lockID, dwr.getThrowable());
        throw error;
    }

    private WriteResult tryWriteLockOnce(StaticBuffer key, StaticBuffer del, StoreTransaction txh) {
        StorageException t = null;
        Timer writeTimer = this.times.getTimer().start();
        StaticBuffer newLockCol = this.serializer.toLockCol(writeTimer.getStartTime(this.timeUnit), this.rid);
        Entry newLockEntry = StaticArrayEntry.of(newLockCol, zeroBuf);
        try {
            StoreTransaction newTx = this.overrideTimestamp(txh, writeTimer.getStartTime());
            this.store.mutate(key, Arrays.asList(newLockEntry), null == del ? KeyColumnValueStore.NO_DELETIONS : Arrays.asList(del), newTx);
        }
        catch (StorageException e) {
            log.debug("Lock write attempt failed with exception", (Throwable)e);
            t = e;
        }
        writeTimer.stop();
        return new WriteResult(writeTimer.elapsed(), writeTimer.getStartTime(), newLockCol, t);
    }

    private WriteResult tryDeleteLockOnce(StaticBuffer key, StaticBuffer col, StoreTransaction txh) {
        StorageException t = null;
        Timer delTimer = this.times.getTimer().start();
        try {
            StoreTransaction newTx = this.overrideTimestamp(txh, delTimer.getStartTime());
            this.store.mutate(key, (List<Entry>)ImmutableList.of(), Arrays.asList(col), newTx);
        }
        catch (StorageException e) {
            t = e;
        }
        delTimer.stop();
        return new WriteResult(delTimer.elapsed(), delTimer.getStartTime(), null, t);
    }

    @Override
    protected void checkSingleLock(final KeyColumn kc, ConsistentKeyLockStatus ls, final StoreTransaction tx) throws StorageException, InterruptedException {
        if (ls.isChecked()) {
            return;
        }
        final Timepoint now = this.times.sleepPast(ls.getWriteTimestamp().add(this.lockWait));
        KeySliceQuery ksq = new KeySliceQuery(this.serializer.toLockKey(kc.getKey(), kc.getColumn()), LOCK_COL_START, LOCK_COL_END);
        List<Entry> claimEntries = this.getSliceWithRetries(ksq, tx);
        Iterable iter = Iterables.transform(claimEntries, (Function)new Function<Entry, TimestampRid>(){

            public TimestampRid apply(Entry e) {
                return ConsistentKeyLocker.this.serializer.fromLockColumn(e.getColumnAs(StaticBuffer.STATIC_FACTORY));
            }
        });
        iter = Iterables.filter((Iterable)iter, (Predicate)new Predicate<TimestampRid>(){

            public boolean apply(TimestampRid tr) {
                long cutoffTime = now.sub(ConsistentKeyLocker.this.lockExpire).getTimestamp(ConsistentKeyLocker.this.timeUnit);
                if (tr.getTimestamp() < cutoffTime) {
                    log.warn("Discarded expired claim on {} with timestamp {}", (Object)kc, (Object)tr.getTimestamp());
                    if (null != ConsistentKeyLocker.this.cleanerService) {
                        ConsistentKeyLocker.this.cleanerService.clean(kc, cutoffTime, tx);
                    }
                    return false;
                }
                return true;
            }
        });
        this.checkSeniority(kc, ls, iter);
        ls.setChecked();
    }

    private List<Entry> getSliceWithRetries(KeySliceQuery ksq, StoreTransaction tx) throws StorageException {
        for (int i = 0; i < this.lockRetryCount; ++i) {
            try {
                return this.store.getSlice(ksq, tx);
            }
            catch (PermanentStorageException e) {
                log.error("Failed to check locks", (Throwable)e);
                throw new PermanentLockingException(e);
            }
            catch (TemporaryStorageException e) {
                log.warn("Temporary storage failure while checking locks", (Throwable)e);
                continue;
            }
        }
        throw new TemporaryStorageException("Maximum retries (" + this.lockRetryCount + ") exceeded while checking locks");
    }

    private void checkSeniority(KeyColumn target, ConsistentKeyLockStatus ls, Iterable<TimestampRid> claimTRs) throws StorageException {
        int trCount = 0;
        for (TimestampRid tr : claimTRs) {
            ++trCount;
            if (!this.rid.equals(tr.getRid())) {
                String msg = "Lock on " + target + " already held by " + tr.getRid() + " (we are " + this.rid + ")";
                log.debug(msg);
                throw new TemporaryLockingException(msg);
            }
            if (tr.getTimestamp() == ls.getWriteTimestamp(this.timeUnit)) {
                log.debug("Checked lock {}", (Object)target);
                return;
            }
            log.warn("Skipping outdated lock on {} with our rid ({}) but mismatched timestamp (actual ts {}, expected ts {})", new Object[]{target, tr.getRid(), tr.getTimestamp(), ls.getWriteTimestamp(this.timeUnit)});
        }
        if (0 == trCount) {
            throw new TemporaryLockingException("No lock columns found for " + target);
        }
        String msg = "Read " + trCount + " locks with our rid " + this.rid + " but mismatched timestamps; no lock column contained our timestamp (" + ls.getWriteTimestamp(this.timeUnit) + ")";
        throw new PermanentStorageException(msg);
    }

    @Override
    protected void deleteSingleLock(KeyColumn kc, ConsistentKeyLockStatus ls, StoreTransaction tx) {
        ImmutableList dels = ImmutableList.of((Object)this.serializer.toLockCol(ls.getWriteTimestamp(this.timeUnit), this.rid));
        for (int i = 0; i < this.lockRetryCount; ++i) {
            try {
                StoreTransaction newTx = this.overrideTimestamp(tx, this.times.getTime());
                this.store.mutate(this.serializer.toLockKey(kc.getKey(), kc.getColumn()), (List<Entry>)ImmutableList.of(), (List<StaticBuffer>)dels, newTx);
                return;
            }
            catch (TemporaryStorageException e) {
                log.warn("Temporary storage exception while deleting lock", (Throwable)e);
                continue;
            }
            catch (StorageException e) {
                log.error("Storage exception while deleting lock", (Throwable)e);
                return;
            }
        }
    }

    private StoreTransaction overrideTimestamp(StoreTransaction tx, Timepoint commitTime) throws StorageException {
        StandardBaseTransactionConfig newCfg = new StandardBaseTransactionConfig.Builder(tx.getConfiguration()).commitTime(commitTime).build();
        return this.manager.beginTransaction(newCfg);
    }

    private static class WriteResult {
        private final Duration duration;
        private final Timepoint writeTimestamp;
        private final StaticBuffer lockCol;
        private final Throwable throwable;

        public WriteResult(Duration duration, Timepoint writeTimestamp, StaticBuffer lockCol, Throwable throwable) {
            this.duration = duration;
            this.writeTimestamp = writeTimestamp;
            this.lockCol = lockCol;
            this.throwable = throwable;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public Timepoint getWriteTimestamp() {
            return this.writeTimestamp;
        }

        public boolean isSuccessful() {
            return null == this.throwable;
        }

        public StaticBuffer getLockCol() {
            return this.lockCol;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    public static class Builder
    extends AbstractLocker.Builder<ConsistentKeyLockStatus, Builder> {
        private final KeyColumnValueStore store;
        private final StoreManager manager;
        private Duration lockWait;
        private int lockRetryCount;
        private CleanerConfig cleanerConfig = CleanerConfig.NONE;
        private LockCleanerService customCleanerService;

        public Builder(KeyColumnValueStore store, StoreManager manager) {
            this.store = store;
            this.manager = manager;
            this.lockWait = GraphDatabaseConfiguration.LOCK_WAIT.getDefaultValue();
            this.lockRetryCount = GraphDatabaseConfiguration.LOCK_RETRY.getDefaultValue();
        }

        public Builder lockWait(Duration d) {
            this.lockWait = d;
            return this.self();
        }

        public Builder lockRetryCount(int count) {
            this.lockRetryCount = count;
            return this.self();
        }

        public Builder standardCleaner() {
            this.cleanerConfig = CleanerConfig.STANDARD;
            this.customCleanerService = null;
            return this.self();
        }

        public Builder customCleaner(LockCleanerService s) {
            this.cleanerConfig = CleanerConfig.CUSTOM;
            this.customCleanerService = s;
            Preconditions.checkNotNull((Object)this.customCleanerService);
            return this.self();
        }

        public Builder fromConfig(Configuration config) {
            this.rid(new StaticArrayBuffer(config.get(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, new String[0]).getBytes()));
            String llmPrefix = config.get(ExpectedValueCheckingStore.LOCAL_LOCK_MEDIATOR_PREFIX, new String[0]);
            this.times(config.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]));
            this.mediator(LocalLockMediators.INSTANCE.get(llmPrefix, this.times));
            this.lockRetryCount(config.get(GraphDatabaseConfiguration.LOCK_RETRY, new String[0]));
            this.lockWait(config.get(GraphDatabaseConfiguration.LOCK_WAIT, new String[0]));
            this.lockExpire(config.get(GraphDatabaseConfiguration.LOCK_EXPIRE, new String[0]));
            if (config.get(GraphDatabaseConfiguration.LOCK_CLEAN_EXPIRED, new String[0]).booleanValue()) {
                this.standardCleaner();
            }
            return this;
        }

        public ConsistentKeyLocker build() {
            LockCleanerService cleaner;
            this.preBuild();
            switch (this.cleanerConfig) {
                case STANDARD: {
                    Preconditions.checkArgument((null == this.customCleanerService ? 1 : 0) != 0);
                    cleaner = new StandardLockCleanerService(this.store, this.serializer);
                    break;
                }
                case CUSTOM: {
                    Preconditions.checkArgument((null != this.customCleanerService ? 1 : 0) != 0);
                    cleaner = this.customCleanerService;
                    break;
                }
                default: {
                    cleaner = null;
                }
            }
            return new ConsistentKeyLocker(this.store, this.manager, this.rid, this.times, this.serializer, this.llm, this.lockWait, this.lockRetryCount, this.lockExpire, this.lockState, cleaner);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected LocalLockMediator<StoreTransaction> getDefaultMediator() {
            throw new TitanConfigurationException("Local lock mediator prefix must not be empty or null");
        }

        private static enum CleanerConfig {
            NONE,
            STANDARD,
            CUSTOM;

        }
    }
}

