/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue;

import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeySelector;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.LimitedSelector;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStore;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntryList;
import java.io.IOException;
import java.util.NoSuchElementException;

public class KVUtil {
    public static final RecordIterator<KeyValueEntry> EMPTY_ITERATOR = new RecordIterator<KeyValueEntry>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public KeyValueEntry next() {
            throw new NoSuchElementException();
        }

        @Override
        public void close() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public static EntryList getSlice(OrderedKeyValueStore store, StaticBuffer keyStart, StaticBuffer keyEnd, StoreTransaction txh) throws StorageException {
        return KVUtil.convert(store.getSlice(keyStart, keyEnd, KeySelector.SelectAll, txh));
    }

    public static EntryList getSlice(OrderedKeyValueStore store, StaticBuffer keyStart, StaticBuffer keyEnd, int limit, StoreTransaction txh) throws StorageException {
        return KVUtil.convert(store.getSlice(keyStart, keyEnd, new LimitedSelector(limit), txh));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntryList convert(RecordIterator<KeyValueEntry> iter) throws StorageException {
        try {
            EntryList entryList = StaticArrayEntryList.ofStaticBuffer(iter, KVEntryGetter.INSTANCE);
            return entryList;
        }
        finally {
            try {
                iter.close();
            }
            catch (IOException e) {
                throw new TemporaryStorageException(e);
            }
        }
    }

    public static class RangeKeySelector
    implements KeySelector {
        private final StaticBuffer lower;
        private final StaticBuffer upper;

        public RangeKeySelector(StaticBuffer lower, StaticBuffer upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean include(StaticBuffer key) {
            return this.lower.compareTo(key) <= 0 && this.upper.compareTo(key) > 0;
        }

        @Override
        public boolean reachedLimit() {
            return false;
        }
    }

    private static enum KVEntryGetter implements StaticArrayEntry.GetColVal<KeyValueEntry, StaticBuffer>
    {
        INSTANCE;


        @Override
        public StaticBuffer getColumn(KeyValueEntry element) {
            return element.getKey();
        }

        @Override
        public StaticBuffer getValue(KeyValueEntry element) {
            return element.getValue();
        }

        @Override
        public EntryMetaData[] getMetaSchema(KeyValueEntry element) {
            return StaticArrayEntry.EMPTY_SCHEMA;
        }

        @Override
        public Object getMetaData(KeyValueEntry element, EntryMetaData meta) {
            throw new UnsupportedOperationException("Unsupported meta data: " + (Object)((Object)meta));
        }
    }
}

