/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.inmemory;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.common.AbstractStoreTransaction;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StandardStoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.inmemory.InMemoryKeyColumnValueStore;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryStoreManager
implements KeyColumnValueStoreManager {
    private final ConcurrentHashMap<String, InMemoryKeyColumnValueStore> stores = new ConcurrentHashMap();
    private final StoreFeatures features = new StandardStoreFeatures.Builder().orderedScan(true).unorderedScan(true).keyOrdered(true).keyConsistent(GraphDatabaseConfiguration.buildConfiguration()).build();

    public InMemoryStoreManager() {
        this(Configuration.EMPTY);
    }

    public InMemoryStoreManager(Configuration configuration) {
    }

    @Override
    public StoreTransaction beginTransaction(BaseTransactionConfig config) throws StorageException {
        return new InMemoryTransaction(config);
    }

    @Override
    public void close() throws StorageException {
        for (InMemoryKeyColumnValueStore store : this.stores.values()) {
            store.close();
        }
        this.stores.clear();
    }

    @Override
    public void clearStorage() throws StorageException {
        for (InMemoryKeyColumnValueStore store : this.stores.values()) {
            store.clear();
        }
    }

    @Override
    public StoreFeatures getFeatures() {
        return this.features;
    }

    @Override
    public KeyColumnValueStore openDatabase(String name) throws StorageException {
        if (!this.stores.containsKey(name)) {
            this.stores.putIfAbsent(name, new InMemoryKeyColumnValueStore(name));
        }
        KeyColumnValueStore store = this.stores.get(name);
        Preconditions.checkNotNull((Object)store);
        return store;
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws StorageException {
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> storeMut : mutations.entrySet()) {
            KeyColumnValueStore store = this.stores.get(storeMut.getKey());
            Preconditions.checkNotNull((Object)store);
            for (Map.Entry<StaticBuffer, KCVMutation> keyMut : storeMut.getValue().entrySet()) {
                store.mutate(keyMut.getKey(), keyMut.getValue().getAdditions(), keyMut.getValue().getDeletions(), txh);
            }
        }
    }

    @Override
    public List<KeyRange> getLocalKeyPartition() throws StorageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    private class InMemoryTransaction
    extends AbstractStoreTransaction {
        public InMemoryTransaction(BaseTransactionConfig config) {
            super(config);
        }
    }
}

