/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.CachableStaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.CacheTransaction;
import com.thinkaurelius.titan.diskstorage.util.CacheMetricsAction;
import com.thinkaurelius.titan.util.stats.MetricManager;
import java.util.List;

public abstract class KCVSCache
implements KeyColumnValueStore {
    public static final List<Entry> NO_DELETIONS = ImmutableList.of();
    private final String metricsName;
    private final boolean validateKeysOnly = true;
    protected final KeyColumnValueStore store;

    protected KCVSCache(KeyColumnValueStore store, String metricsName) {
        this.metricsName = metricsName;
        Preconditions.checkNotNull((Object)store);
        this.store = store;
    }

    protected boolean hasValidateKeysOnly() {
        return true;
    }

    protected void incActionBy(int by, CacheMetricsAction action, StoreTransaction txh) {
        assert (by >= 1);
        if (this.metricsName != null && txh.getConfiguration().hasGroupName()) {
            MetricManager.INSTANCE.getCounter(txh.getConfiguration().getGroupName(), this.metricsName, action.getName()).inc((long)by);
        }
    }

    public abstract void clearCache();

    protected abstract void invalidate(StaticBuffer var1, List<CachableStaticBuffer> var2);

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws StorageException {
        throw new UnsupportedOperationException("Only supports mutateEntries()");
    }

    public void mutateEntries(StaticBuffer key, List<Entry> additions, List<Entry> deletions, StoreTransaction txh) throws StorageException {
        assert (txh instanceof CacheTransaction);
        ((CacheTransaction)txh).mutate(this, key, additions, deletions);
    }

    protected final StoreTransaction getTx(StoreTransaction txh) {
        assert (txh instanceof CacheTransaction);
        return ((CacheTransaction)txh).getWrappedTransaction();
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws StorageException {
        this.store.acquireLock(key, column, expectedValue, this.getTx(txh));
    }

    @Override
    public KeyIterator getKeys(KeyRangeQuery keyQuery, StoreTransaction txh) throws StorageException {
        return this.store.getKeys(keyQuery, this.getTx(txh));
    }

    @Override
    public KeyIterator getKeys(SliceQuery columnQuery, StoreTransaction txh) throws StorageException {
        return this.store.getKeys(columnQuery, this.getTx(txh));
    }

    @Override
    public String getName() {
        return this.store.getName();
    }

    @Override
    public void close() throws StorageException {
        this.store.close();
    }
}

