/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.LoggableTransaction;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.CachableStaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVEntryMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVSCache;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheTransaction
implements StoreTransaction,
LoggableTransaction {
    private static final Logger log = LoggerFactory.getLogger(CacheTransaction.class);
    private final StoreTransaction tx;
    private final KeyColumnValueStoreManager manager;
    private final boolean batchLoading;
    private final int persistChunkSize;
    private final Duration maxWriteTime;
    private int numMutations;
    private final Map<KCVSCache, Map<StaticBuffer, KCVEntryMutation>> mutations;

    public CacheTransaction(StoreTransaction tx, KeyColumnValueStoreManager manager, int persistChunkSize, Duration maxWriteTime, boolean batchLoading) {
        this(tx, manager, persistChunkSize, maxWriteTime, batchLoading, 2);
    }

    public CacheTransaction(StoreTransaction tx, KeyColumnValueStoreManager manager, int persistChunkSize, Duration maxWriteTime, boolean batchLoading, int expectedNumStores) {
        Preconditions.checkArgument((tx != null && manager != null && persistChunkSize > 0 ? 1 : 0) != 0);
        this.tx = tx;
        this.manager = manager;
        this.batchLoading = batchLoading;
        this.numMutations = 0;
        this.persistChunkSize = persistChunkSize;
        this.maxWriteTime = maxWriteTime;
        this.mutations = new HashMap<KCVSCache, Map<StaticBuffer, KCVEntryMutation>>(expectedNumStores);
    }

    public StoreTransaction getWrappedTransaction() {
        return this.tx;
    }

    void mutate(KCVSCache store, StaticBuffer key, List<Entry> additions, List<Entry> deletions) throws StorageException {
        KCVEntryMutation existingM;
        Preconditions.checkNotNull((Object)store);
        if (additions.isEmpty() && deletions.isEmpty()) {
            return;
        }
        KCVEntryMutation m = new KCVEntryMutation(additions, deletions);
        Map<StaticBuffer, KCVEntryMutation> storeMutation = this.mutations.get(store);
        if (storeMutation == null) {
            storeMutation = new HashMap<StaticBuffer, KCVEntryMutation>();
            this.mutations.put(store, storeMutation);
        }
        if ((existingM = storeMutation.get(key)) != null) {
            existingM.merge(m);
        } else {
            storeMutation.put(key, m);
        }
        this.numMutations += m.getTotalMutations();
        if (this.batchLoading && this.numMutations >= this.persistChunkSize) {
            this.flushInternal();
        }
    }

    private int persist(final Map<String, Map<StaticBuffer, KCVMutation>> subMutations) {
        BackendOperation.execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                CacheTransaction.this.manager.mutateMany(subMutations, CacheTransaction.this.tx);
                return true;
            }

            public String toString() {
                return "CacheMutation";
            }
        }, this.maxWriteTime);
        subMutations.clear();
        return 0;
    }

    private int mutationSize(Map<StaticBuffer, KCVEntryMutation> mutation) {
        int size = 0;
        for (KCVEntryMutation mut : mutation.values()) {
            size += mut.getTotalMutations();
        }
        return size;
    }

    private KCVMutation convert(KCVEntryMutation mutation) {
        assert (!mutation.isEmpty());
        if (!mutation.hasDeletions()) {
            return new KCVMutation(mutation.getAdditions(), KeyColumnValueStore.NO_DELETIONS);
        }
        return new KCVMutation(mutation.getAdditions(), Lists.newArrayList((Iterable)Iterables.transform(mutation.getDeletions(), KCVEntryMutation.ENTRY2COLUMN_FCT)));
    }

    private void flushInternal() throws StorageException {
        if (this.numMutations > 0) {
            for (Map<StaticBuffer, KCVEntryMutation> store : this.mutations.values()) {
                for (KCVEntryMutation kCVEntryMutation : store.values()) {
                    kCVEntryMutation.consolidate();
                }
            }
            HashMap<String, Map<StaticBuffer, KCVMutation>> subMutations = new HashMap<String, Map<StaticBuffer, KCVMutation>>(this.mutations.size());
            int numSubMutations = 0;
            for (Map.Entry entry : this.mutations.entrySet()) {
                HashMap sub = new HashMap();
                subMutations.put(((KCVSCache)entry.getKey()).getName(), sub);
                for (Map.Entry muts : ((Map)entry.getValue()).entrySet()) {
                    if (((KCVEntryMutation)muts.getValue()).isEmpty()) continue;
                    sub.put(muts.getKey(), this.convert((KCVEntryMutation)muts.getValue()));
                    if ((numSubMutations += ((KCVEntryMutation)muts.getValue()).getTotalMutations()) < this.persistChunkSize) continue;
                    numSubMutations = this.persist(subMutations);
                    sub.clear();
                    subMutations.put(((KCVSCache)entry.getKey()).getName(), sub);
                }
            }
            if (numSubMutations > 0) {
                this.persist(subMutations);
            }
            for (Map.Entry entry : this.mutations.entrySet()) {
                KCVSCache cache = (KCVSCache)entry.getKey();
                for (Map.Entry muts : ((Map)entry.getValue()).entrySet()) {
                    if (cache.hasValidateKeysOnly()) {
                        cache.invalidate((StaticBuffer)muts.getKey(), Collections.EMPTY_LIST);
                        continue;
                    }
                    KCVEntryMutation m = (KCVEntryMutation)muts.getValue();
                    ArrayList<CachableStaticBuffer> entries = new ArrayList<CachableStaticBuffer>(m.getTotalMutations());
                    for (StaticBuffer e : m.getAdditions()) {
                        assert (e instanceof CachableStaticBuffer);
                        entries.add((CachableStaticBuffer)e);
                    }
                    for (StaticBuffer e : m.getDeletions()) {
                        assert (e instanceof CachableStaticBuffer);
                        entries.add((CachableStaticBuffer)e);
                    }
                    cache.invalidate((StaticBuffer)muts.getKey(), entries);
                }
            }
            this.clear();
        }
    }

    private void clear() {
        for (Map.Entry<KCVSCache, Map<StaticBuffer, KCVEntryMutation>> entry : this.mutations.entrySet()) {
            entry.getValue().clear();
        }
        this.numMutations = 0;
    }

    @Override
    public void logMutations(DataOutput out) {
        Preconditions.checkArgument((!this.batchLoading ? 1 : 0) != 0, (Object)"Cannot log entire mutation set when batch-loading is enabled");
        VariableLong.writePositive(out, this.mutations.size());
        for (Map.Entry<KCVSCache, Map<StaticBuffer, KCVEntryMutation>> storeMuts : this.mutations.entrySet()) {
            out.writeObjectNotNull(storeMuts.getKey().getName());
            VariableLong.writePositive(out, storeMuts.getValue().size());
            for (Map.Entry<StaticBuffer, KCVEntryMutation> muts : storeMuts.getValue().entrySet()) {
                BufferUtil.writeBuffer(out, muts.getKey());
                KCVEntryMutation mut = muts.getValue();
                this.logMutatedEntries(out, mut.getAdditions());
                this.logMutatedEntries(out, mut.getDeletions());
            }
        }
    }

    private void logMutatedEntries(DataOutput out, List<Entry> entries) {
        VariableLong.writePositive(out, entries.size());
        for (Entry add : entries) {
            BufferUtil.writeEntry(out, add);
        }
    }

    @Override
    public void commit() throws StorageException {
        this.flushInternal();
        this.tx.commit();
    }

    @Override
    public void rollback() throws StorageException {
        this.clear();
        this.tx.rollback();
    }

    @Override
    public BaseTransactionConfig getConfiguration() {
        return this.tx.getConfiguration();
    }
}

