/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue;

import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;

public class StandardStoreFeatures
implements StoreFeatures {
    private final boolean unorderedScan;
    private final boolean orderedScan;
    private final boolean multiQuery;
    private final boolean locking;
    private final boolean batchMutation;
    private final boolean localKeyPartition;
    private final boolean keyOrdered;
    private final boolean distributed;
    private final boolean transactional;
    private final boolean keyConsistent;
    private final boolean timestamps;
    private final boolean ttl;
    private final boolean visibility;
    private final Configuration keyConsistentTxConfig;
    private final Configuration localKeyConsistentTxConfig;

    @Override
    public boolean hasScan() {
        return this.hasOrderedScan() || this.hasUnorderedScan();
    }

    @Override
    public boolean hasUnorderedScan() {
        return this.unorderedScan;
    }

    @Override
    public boolean hasOrderedScan() {
        return this.orderedScan;
    }

    @Override
    public boolean hasMultiQuery() {
        return this.multiQuery;
    }

    @Override
    public boolean hasLocking() {
        return this.locking;
    }

    @Override
    public boolean hasBatchMutation() {
        return this.batchMutation;
    }

    @Override
    public boolean isKeyOrdered() {
        return this.keyOrdered;
    }

    @Override
    public boolean isDistributed() {
        return this.distributed;
    }

    @Override
    public boolean hasTxIsolation() {
        return this.transactional;
    }

    @Override
    public boolean isKeyConsistent() {
        return this.keyConsistent;
    }

    @Override
    public boolean hasTimestamps() {
        return this.timestamps;
    }

    @Override
    public boolean hasTTL() {
        return this.ttl;
    }

    @Override
    public boolean hasVisibility() {
        return this.visibility;
    }

    @Override
    public Configuration getKeyConsistentTxConfig() {
        return this.keyConsistentTxConfig;
    }

    @Override
    public Configuration getLocalKeyConsistentTxConfig() {
        return this.localKeyConsistentTxConfig;
    }

    @Override
    public boolean hasLocalKeyPartition() {
        return this.localKeyPartition;
    }

    private StandardStoreFeatures(boolean unorderedScan, boolean orderedScan, boolean multiQuery, boolean locking, boolean batchMutation, boolean localKeyPartition, boolean keyOrdered, boolean distributed, boolean transactional, boolean keyConsistent, boolean timestamps, boolean ttl, boolean visibility, Configuration keyConsistentTxConfig, Configuration localKeyConsistentTxConfig) {
        this.unorderedScan = unorderedScan;
        this.orderedScan = orderedScan;
        this.multiQuery = multiQuery;
        this.locking = locking;
        this.batchMutation = batchMutation;
        this.localKeyPartition = localKeyPartition;
        this.keyOrdered = keyOrdered;
        this.distributed = distributed;
        this.transactional = transactional;
        this.keyConsistent = keyConsistent;
        this.timestamps = timestamps;
        this.ttl = ttl;
        this.visibility = visibility;
        this.keyConsistentTxConfig = keyConsistentTxConfig;
        this.localKeyConsistentTxConfig = localKeyConsistentTxConfig;
    }

    public static class Builder {
        private boolean unorderedScan;
        private boolean orderedScan;
        private boolean multiQuery;
        private boolean locking;
        private boolean batchMutation;
        private boolean localKeyPartition;
        private boolean keyOrdered;
        private boolean distributed;
        private boolean transactional;
        private boolean keyConsistent;
        private boolean timestamps;
        private boolean ttl;
        private boolean visibility;
        private Configuration keyConsistentTxConfig;
        private Configuration localKeyConsistentTxConfig;

        public Builder() {
        }

        public Builder(StoreFeatures template) {
            this.unorderedScan(template.hasUnorderedScan());
            this.orderedScan(template.hasOrderedScan());
            this.multiQuery(template.hasMultiQuery());
            this.locking(template.hasLocking());
            this.batchMutation(template.hasBatchMutation());
            this.localKeyPartition(template.hasLocalKeyPartition());
            this.keyOrdered(template.isKeyOrdered());
            this.distributed(template.isDistributed());
            this.transactional(template.hasTxIsolation());
            this.timestamps(template.hasTimestamps());
            this.ttl(template.hasTTL());
            this.visibility(template.hasVisibility());
            if (template.isKeyConsistent()) {
                this.keyConsistent(template.getKeyConsistentTxConfig(), template.getLocalKeyConsistentTxConfig());
            }
        }

        public Builder unorderedScan(boolean b) {
            this.unorderedScan = b;
            return this;
        }

        public Builder orderedScan(boolean b) {
            this.orderedScan = b;
            return this;
        }

        public Builder multiQuery(boolean b) {
            this.multiQuery = b;
            return this;
        }

        public Builder locking(boolean b) {
            this.locking = b;
            return this;
        }

        public Builder batchMutation(boolean b) {
            this.batchMutation = b;
            return this;
        }

        public Builder localKeyPartition(boolean b) {
            this.localKeyPartition = b;
            return this;
        }

        public Builder keyOrdered(boolean b) {
            this.keyOrdered = b;
            return this;
        }

        public Builder distributed(boolean b) {
            this.distributed = b;
            return this;
        }

        public Builder transactional(boolean b) {
            this.transactional = b;
            return this;
        }

        public Builder timestamps(boolean b) {
            this.timestamps = b;
            return this;
        }

        public Builder ttl(boolean b) {
            this.ttl = b;
            return this;
        }

        public Builder visibility(boolean b) {
            this.visibility = b;
            return this;
        }

        public Builder keyConsistent(Configuration c) {
            this.keyConsistent = true;
            this.keyConsistentTxConfig = c;
            return this;
        }

        public Builder keyConsistent(Configuration global, Configuration local) {
            this.keyConsistent = true;
            this.keyConsistentTxConfig = global;
            this.localKeyConsistentTxConfig = local;
            return this;
        }

        public Builder notKeyConsistent() {
            this.keyConsistent = false;
            return this;
        }

        public StandardStoreFeatures build() {
            return new StandardStoreFeatures(this.unorderedScan, this.orderedScan, this.multiQuery, this.locking, this.batchMutation, this.localKeyPartition, this.keyOrdered, this.distributed, this.transactional, this.keyConsistent, this.timestamps, this.ttl, this.visibility, this.keyConsistentTxConfig, this.localKeyConsistentTxConfig);
        }
    }
}

