/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.indexing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.Mutation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import java.util.List;
import javax.annotation.Nullable;

public class IndexMutation
extends Mutation<IndexEntry, IndexEntry> {
    private final boolean isNew;
    private final boolean isDeleted;
    public static final Function<IndexEntry, String> ENTRY2FIELD_FCT = new Function<IndexEntry, String>(){

        @Nullable
        public String apply(@Nullable IndexEntry indexEntry) {
            return indexEntry.field;
        }
    };

    public IndexMutation(List<IndexEntry> additions, List<IndexEntry> deletions, boolean isNew, boolean isDeleted) {
        super(additions, deletions);
        Preconditions.checkArgument((!isNew || !isDeleted ? 1 : 0) != 0, (Object)"Invalid status");
        this.isNew = isNew;
        this.isDeleted = isDeleted;
    }

    public IndexMutation(boolean isNew, boolean isDeleted) {
        Preconditions.checkArgument((!isNew || !isDeleted ? 1 : 0) != 0, (Object)"Invalid status");
        this.isNew = isNew;
        this.isDeleted = isDeleted;
    }

    public void merge(IndexMutation m) {
        Preconditions.checkArgument((this.isNew == m.isNew ? 1 : 0) != 0, (Object)"Incompatible new status");
        Preconditions.checkArgument((this.isDeleted == m.isDeleted ? 1 : 0) != 0, (Object)"Incompatible delete status");
        super.merge(m);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public void consolidate() {
        super.consolidate(ENTRY2FIELD_FCT, ENTRY2FIELD_FCT);
    }

    @Override
    public boolean isConsolidated() {
        return super.isConsolidated(ENTRY2FIELD_FCT, ENTRY2FIELD_FCT);
    }
}

