/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.MetaAnnotated;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class IndexEntry
implements MetaAnnotated {
    public final String field;
    public final Object value;
    private Map<EntryMetaData, Object> metadata = EntryMetaData.EMPTY_METADATA;

    public IndexEntry(String field, Object value) {
        Preconditions.checkNotNull((Object)field);
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)field));
        this.field = field;
        this.value = value;
    }

    public synchronized Object setMetaData(EntryMetaData key, Object value) {
        if (this.metadata == EntryMetaData.EMPTY_METADATA) {
            this.metadata = new EntryMetaData.Map();
        }
        return this.metadata.put(key, value);
    }

    @Override
    public boolean hasMetaData() {
        return !this.metadata.isEmpty();
    }

    @Override
    public Map<EntryMetaData, Object> getMetaData() {
        return this.metadata;
    }
}

