/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.core.TitanConfigurationException;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.IDAuthority;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.backend.KCVSConfiguration;
import com.thinkaurelius.titan.diskstorage.idmanagement.ConsistentKeyIDAuthority;
import com.thinkaurelius.titan.diskstorage.indexing.IndexInformation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexTransaction;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.CacheTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.ExpirationKCVSCache;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVSCache;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.NoKCVSCache;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManagerAdapter;
import com.thinkaurelius.titan.diskstorage.locking.Locker;
import com.thinkaurelius.titan.diskstorage.locking.LockerProvider;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ConsistentKeyLocker;
import com.thinkaurelius.titan.diskstorage.locking.consistentkey.ExpectedValueCheckingStoreManager;
import com.thinkaurelius.titan.diskstorage.log.Log;
import com.thinkaurelius.titan.diskstorage.log.LogManager;
import com.thinkaurelius.titan.diskstorage.log.ReadMarker;
import com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLogManager;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.diskstorage.util.MetricInstrumentedStore;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.transaction.TransactionConfiguration;
import com.thinkaurelius.titan.util.system.ConfigurationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Backend
implements LockerProvider {
    private static final Logger log;
    public static final String EDGESTORE_NAME = "edgestore";
    public static final String INDEXSTORE_NAME = "graphindex";
    public static final String ID_STORE_NAME = "titan_ids";
    public static final String METRICS_MERGED_STORE = "stores";
    public static final String METRICS_MERGED_CACHE = "caches";
    public static final String METRICS_CACHE_SUFFIX = ".cache";
    public static final String LOCK_STORE_SUFFIX = "_lock_";
    public static final String SYSTEM_TX_LOG_NAME = "txlog";
    public static final String SYSTEM_MGMT_LOG_NAME = "systemlog";
    public static final String TRIGGER_LOG_PREFIX = "trigger_";
    public static final double EDGESTORE_CACHE_PERCENT = 0.8;
    public static final double INDEXSTORE_CACHE_PERCENT = 0.2;
    private static final long ETERNAL_CACHE_EXPIRATION = 6307200000000L;
    public static final int THREAD_POOL_SIZE_SCALE_FACTOR = 2;
    public static final Map<String, Integer> STATIC_KEY_LENGTHS;
    private final KeyColumnValueStoreManager storeManager;
    private final KeyColumnValueStoreManager storeManagerLocking;
    private final StoreFeatures storeFeatures;
    private KCVSCache edgeStore;
    private KCVSCache indexStore;
    private IDAuthority idAuthority;
    private KCVSConfiguration systemConfig;
    private final LogManager mgmtLogManager;
    private final LogManager txLogManager;
    private final LogManager triggerLogManager;
    private final Map<String, IndexProvider> indexes;
    private final int bufferSize;
    private final Duration maxWriteTime;
    private final Duration maxReadTime;
    private final boolean cacheEnabled;
    private final ExecutorService threadPool;
    private final Function<String, Locker> lockerCreator;
    private final ConcurrentHashMap<String, Locker> lockers = new ConcurrentHashMap();
    private final Configuration configuration;
    private static final Map<String, String> REGISTERED_STORAGE_MANAGERS;
    public static final Map<String, ConfigOption> REGISTERED_STORAGE_MANAGERS_SHORTHAND;
    private static final Map<String, String> REGISTERED_INDEX_PROVIDERS;
    private static final Map<String, String> REGISTERED_LOG_MANAGERS;
    private final Function<String, Locker> CONSISTENT_KEY_LOCKER_CREATOR = new Function<String, Locker>(){

        public Locker apply(String lockerName) {
            KeyColumnValueStore lockerStore;
            try {
                lockerStore = Backend.this.storeManager.openDatabase(lockerName);
            }
            catch (StorageException e) {
                throw new TitanConfigurationException("Could not retrieve store named " + lockerName + " for locker configuration", e);
            }
            return new ConsistentKeyLocker.Builder(lockerStore, Backend.this.storeManager).fromConfig(Backend.this.configuration).build();
        }
    };
    private final Function<String, Locker> ASTYANAX_RECIPE_LOCKER_CREATOR = new Function<String, Locker>(){

        public Locker apply(String lockerName) {
            String expectedManagerName = "com.thinkaurelius.titan.diskstorage.cassandra.astyanax.AstyanaxStoreManager";
            String actualManagerName = Backend.this.storeManager.getClass().getCanonicalName();
            Preconditions.checkArgument((boolean)expectedManagerName.equals(actualManagerName), (Object)("Astyanax Recipe locker is only supported with the Astyanax storage backend (configured:" + actualManagerName + " != required:" + expectedManagerName + ")"));
            try {
                Class<?> c = Backend.this.storeManager.getClass();
                Method method = c.getMethod("openLocker", String.class);
                Object o = method.invoke((Object)Backend.this.storeManager, lockerName);
                return (Locker)o;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Could not find method when configuring locking with Astyanax Recipes");
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not access method when configuring locking with Astyanax Recipes", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not invoke method when configuring locking with Astyanax Recipes", e);
            }
        }
    };
    private final Function<String, Locker> TEST_LOCKER_CREATOR = new Function<String, Locker>(){

        public Locker apply(String lockerName) {
            return Backend.openManagedLocker("com.thinkaurelius.titan.diskstorage.util.TestLockerManager", lockerName);
        }
    };
    private final Map<String, Function<String, Locker>> REGISTERED_LOCKERS = ImmutableMap.of((Object)"consistentkey", this.CONSISTENT_KEY_LOCKER_CREATOR, (Object)"astyanaxrecipe", this.ASTYANAX_RECIPE_LOCKER_CREATOR, (Object)"test", this.TEST_LOCKER_CREATOR);

    public Backend(Configuration configuration) {
        this.configuration = configuration;
        this.storeManager = Backend.getStorageManager(configuration);
        this.indexes = Backend.getIndexes(configuration);
        this.storeFeatures = this.storeManager.getFeatures();
        this.mgmtLogManager = Backend.getLogManager(configuration, "titan", this.storeManager);
        this.txLogManager = Backend.getLogManager(configuration, "tx", this.storeManager);
        this.triggerLogManager = Backend.getLogManager(configuration, "trigger", this.storeManager);
        this.cacheEnabled = configuration.get(GraphDatabaseConfiguration.STORAGE_BATCH, new String[0]) == false && configuration.get(GraphDatabaseConfiguration.DB_CACHE, new String[0]) != false;
        int bufferSizeTmp = configuration.get(GraphDatabaseConfiguration.BUFFER_SIZE, new String[0]);
        Preconditions.checkArgument((bufferSizeTmp > 0 ? 1 : 0) != 0, (Object)"Buffer size must be positive");
        this.bufferSize = !this.storeFeatures.hasBatchMutation() ? Integer.MAX_VALUE : bufferSizeTmp;
        this.maxWriteTime = configuration.get(GraphDatabaseConfiguration.STORAGE_WRITE_WAITTIME, new String[0]);
        this.maxReadTime = configuration.get(GraphDatabaseConfiguration.STORAGE_READ_WAITTIME, new String[0]);
        if (!this.storeFeatures.hasLocking()) {
            Preconditions.checkArgument((boolean)this.storeFeatures.isKeyConsistent(), (Object)"Store needs to support some form of locking");
            this.storeManagerLocking = new ExpectedValueCheckingStoreManager(this.storeManager, LOCK_STORE_SUFFIX, this, this.maxReadTime);
        } else {
            this.storeManagerLocking = this.storeManager;
        }
        if (configuration.get(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS, new String[0]).booleanValue()) {
            int poolsize = Runtime.getRuntime().availableProcessors() * 2;
            this.threadPool = Executors.newFixedThreadPool(poolsize);
            log.info("Initiated backend operations thread pool of size {}", (Object)poolsize);
        } else {
            this.threadPool = null;
        }
        String lockBackendName = configuration.get(GraphDatabaseConfiguration.LOCK_BACKEND, new String[0]);
        if (!this.REGISTERED_LOCKERS.containsKey(lockBackendName)) {
            throw new TitanConfigurationException("Unknown lock backend \"" + lockBackendName + "\".  Known lock backends: " + Joiner.on((String)", ").join(this.REGISTERED_LOCKERS.keySet()) + ".");
        }
        this.lockerCreator = this.REGISTERED_LOCKERS.get(lockBackendName);
        Preconditions.checkNotNull(this.lockerCreator);
    }

    @Override
    public Locker getLocker(String lockerName) {
        Locker x;
        Preconditions.checkNotNull((Object)lockerName);
        Locker l = this.lockers.get(lockerName);
        if (null == l && null != (x = this.lockers.putIfAbsent(lockerName, l = (Locker)this.lockerCreator.apply((Object)lockerName)))) {
            l = x;
        }
        return l;
    }

    public void initialize(Configuration config) {
        try {
            boolean reportMetrics = this.configuration.get(GraphDatabaseConfiguration.BASIC_METRICS, new String[0]);
            KeyColumnValueStore idStore = this.storeManager.openDatabase(ID_STORE_NAME);
            if (reportMetrics) {
                idStore = new MetricInstrumentedStore(idStore, this.getMetricsStoreName(ID_STORE_NAME));
            }
            this.idAuthority = null;
            if (!this.storeFeatures.isKeyConsistent()) {
                throw new IllegalStateException("Store needs to support consistent key or transactional operations for ID manager to guarantee proper id allocations");
            }
            this.idAuthority = new ConsistentKeyIDAuthority(idStore, this.storeManager, config);
            KeyColumnValueStore edgeStoreRaw = this.storeManagerLocking.openDatabase(EDGESTORE_NAME);
            KeyColumnValueStore indexStoreRaw = this.storeManagerLocking.openDatabase(INDEXSTORE_NAME);
            if (reportMetrics) {
                edgeStoreRaw = new MetricInstrumentedStore(edgeStoreRaw, this.getMetricsStoreName(EDGESTORE_NAME));
                indexStoreRaw = new MetricInstrumentedStore(indexStoreRaw, this.getMetricsStoreName(INDEXSTORE_NAME));
            }
            if (this.cacheEnabled) {
                long cacheSizeBytes;
                double cachesize;
                long expirationTime = this.configuration.get(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]);
                Preconditions.checkArgument((expirationTime >= 0L ? 1 : 0) != 0, (String)"Invalid cache expiration time: %s", (Object[])new Object[]{expirationTime});
                if (expirationTime == 0L) {
                    expirationTime = 6307200000000L;
                }
                Preconditions.checkArgument(((cachesize = this.configuration.get(GraphDatabaseConfiguration.DB_CACHE_SIZE, new String[0]).doubleValue()) > 0.0 ? 1 : 0) != 0, (String)"Invalid cache size specified: %s", (Object[])new Object[]{cachesize});
                if (cachesize < 1.0) {
                    Runtime runtime = Runtime.getRuntime();
                    cacheSizeBytes = (long)((double)(runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory())) * cachesize);
                } else {
                    Preconditions.checkArgument((cachesize > 1000.0 ? 1 : 0) != 0, (String)"Cache size is too small: %s", (Object[])new Object[]{cachesize});
                    cacheSizeBytes = (long)cachesize;
                }
                log.info("Configuring total store cache size: {}", (Object)cacheSizeBytes);
                long cleanWaitTime = this.configuration.get(GraphDatabaseConfiguration.DB_CACHE_CLEAN_WAIT, new String[0]).intValue();
                Preconditions.checkArgument((boolean)true, (Object)"Cache percentages don't add up!");
                long edgeStoreCacheSize = Math.round((double)cacheSizeBytes * 0.8);
                long indexStoreCacheSize = Math.round((double)cacheSizeBytes * 0.2);
                this.edgeStore = new ExpirationKCVSCache(edgeStoreRaw, this.getMetricsCacheName("edgeStore", reportMetrics), expirationTime, cleanWaitTime, edgeStoreCacheSize);
                this.indexStore = new ExpirationKCVSCache(indexStoreRaw, this.getMetricsCacheName("indexStore", reportMetrics), expirationTime, cleanWaitTime, indexStoreCacheSize);
            } else {
                this.edgeStore = new NoKCVSCache(edgeStoreRaw);
                this.indexStore = new NoKCVSCache(indexStoreRaw);
            }
            this.txLogManager.openLog(SYSTEM_TX_LOG_NAME, ReadMarker.fromNow());
            this.mgmtLogManager.openLog(SYSTEM_MGMT_LOG_NAME, ReadMarker.fromNow());
            KeyColumnValueStore systemConfigStore = this.storeManagerLocking.openDatabase("system_properties");
            this.systemConfig = Backend.getGlobalConfiguration(new BackendOperation.TransactionalProvider(){

                @Override
                public StoreTransaction openTx() throws StorageException {
                    return Backend.this.storeManagerLocking.beginTransaction(StandardBaseTransactionConfig.of(Backend.this.configuration.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]), Backend.this.storeFeatures.getKeyConsistentTxConfig()));
                }

                @Override
                public void close() throws StorageException {
                }
            }, systemConfigStore, this.configuration);
        }
        catch (StorageException e) {
            throw new TitanException("Could not initialize backend", e);
        }
    }

    public Map<String, IndexInformation> getIndexInformation() {
        ImmutableMap.Builder copy = ImmutableMap.builder();
        copy.putAll(this.indexes);
        return copy.build();
    }

    public Log getSystemTxLog() {
        try {
            return this.txLogManager.openLog(SYSTEM_TX_LOG_NAME, ReadMarker.fromNow());
        }
        catch (StorageException e) {
            throw new TitanException("Could not re-open transaction log", e);
        }
    }

    public Log getSystemMgmtLog() {
        try {
            return this.mgmtLogManager.openLog(SYSTEM_MGMT_LOG_NAME, ReadMarker.fromNow());
        }
        catch (StorageException e) {
            throw new TitanException("Could not re-open management log", e);
        }
    }

    public Log getTriggerLog(String identifier) throws StorageException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)identifier));
        return this.triggerLogManager.openLog(TRIGGER_LOG_PREFIX + identifier, ReadMarker.fromNow());
    }

    public KCVSConfiguration getGlobalSystemConfig() {
        return this.systemConfig;
    }

    private String getMetricsStoreName(String storeName) {
        return this.configuration.get(GraphDatabaseConfiguration.METRICS_MERGE_STORES, new String[0]) != false ? METRICS_MERGED_STORE : storeName;
    }

    private String getMetricsCacheName(String storeName, boolean reportMetrics) {
        if (!reportMetrics) {
            return null;
        }
        return this.configuration.get(GraphDatabaseConfiguration.METRICS_MERGE_STORES, new String[0]) != false ? METRICS_MERGED_CACHE : storeName + METRICS_CACHE_SUFFIX;
    }

    public static LogManager getLogManager(Configuration config, String logName, KeyColumnValueStoreManager sm) {
        Configuration logConfig = config.restrictTo(logName);
        String backend = logConfig.get(GraphDatabaseConfiguration.LOG_BACKEND, new String[0]);
        if (backend.equalsIgnoreCase(GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue())) {
            return new KCVSLogManager(sm, logConfig);
        }
        return Backend.getLogManager(logConfig);
    }

    public static final LogManager getLogManager(Configuration config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0);
        LogManager lm = (LogManager)Backend.getImplementationClass(config, config.get(GraphDatabaseConfiguration.LOG_BACKEND, new String[0]), REGISTERED_LOG_MANAGERS);
        Preconditions.checkNotNull((Object)lm);
        return lm;
    }

    public static KeyColumnValueStoreManager getStorageManager(Configuration storageConfig) {
        StoreManager manager = (StoreManager)Backend.getImplementationClass(storageConfig, storageConfig.get(GraphDatabaseConfiguration.STORAGE_BACKEND, new String[0]), REGISTERED_STORAGE_MANAGERS);
        if (manager instanceof OrderedKeyValueStoreManager) {
            manager = new OrderedKeyValueStoreManagerAdapter((OrderedKeyValueStoreManager)manager, STATIC_KEY_LENGTHS);
        }
        Preconditions.checkArgument((boolean)(manager instanceof KeyColumnValueStoreManager), (String)"Invalid storage manager: %s", (Object[])new Object[]{manager.getClass()});
        return (KeyColumnValueStoreManager)manager;
    }

    private static KCVSConfiguration getGlobalConfiguration(BackendOperation.TransactionalProvider txProvider, KeyColumnValueStore store, Configuration config) {
        try {
            KCVSConfiguration kcvsConfig = new KCVSConfiguration(txProvider, config.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]), store, "configuration");
            kcvsConfig.setMaxOperationWaitTime(config.get(GraphDatabaseConfiguration.SETUP_WAITTIME, new String[0]));
            return kcvsConfig;
        }
        catch (StorageException e) {
            throw new TitanException("Could not open global configuration", e);
        }
    }

    public static KCVSConfiguration getStandaloneGlobalConfiguration(final KeyColumnValueStoreManager manager, final Configuration config) {
        try {
            final StoreFeatures features = manager.getFeatures();
            return Backend.getGlobalConfiguration(new BackendOperation.TransactionalProvider(){

                @Override
                public StoreTransaction openTx() throws StorageException {
                    return manager.beginTransaction(StandardBaseTransactionConfig.of(config.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]), features.getKeyConsistentTxConfig()));
                }

                @Override
                public void close() throws StorageException {
                    manager.close();
                }
            }, manager.openDatabase("system_properties"), config);
        }
        catch (StorageException e) {
            throw new TitanException("Could not open global configuration", e);
        }
    }

    private static final Map<String, IndexProvider> getIndexes(Configuration config) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String index : config.getContainedNamespaces(GraphDatabaseConfiguration.INDEX_NS, new String[0])) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)index), (String)"Invalid index name [%s]", (Object[])new Object[]{index});
            log.info("Configuring index [{}]", (Object)index);
            IndexProvider provider = (IndexProvider)Backend.getImplementationClass(config.restrictTo(index), config.get(GraphDatabaseConfiguration.INDEX_BACKEND, index), REGISTERED_INDEX_PROVIDERS);
            Preconditions.checkNotNull((Object)provider);
            builder.put((Object)index, (Object)provider);
        }
        return builder.build();
    }

    public static final <T> T getImplementationClass(Configuration config, String clazzname, Map<String, String> registeredImpls) {
        if (registeredImpls.containsKey(clazzname.toLowerCase())) {
            clazzname = registeredImpls.get(clazzname.toLowerCase());
        }
        return ConfigurationUtil.instantiate(clazzname, new Object[]{config}, new Class[]{Configuration.class});
    }

    public IDAuthority getIDAuthority() {
        Preconditions.checkNotNull((Object)this.idAuthority, (Object)"Backend has not yet been initialized");
        return this.idAuthority;
    }

    public StoreFeatures getStoreFeatures() {
        return this.storeFeatures;
    }

    public BackendTransaction beginTransaction(TransactionConfiguration configuration, KeyInformation.Retriever indexKeyRetriever) throws StorageException {
        StoreTransaction tx = this.storeManagerLocking.beginTransaction(configuration);
        CacheTransaction cacheTx = new CacheTransaction(tx, this.storeManagerLocking, this.bufferSize, this.maxWriteTime, configuration.hasEnabledBatchLoading());
        HashMap<String, IndexTransaction> indexTx = new HashMap<String, IndexTransaction>(this.indexes.size());
        for (Map.Entry<String, IndexProvider> entry : this.indexes.entrySet()) {
            indexTx.put(entry.getKey(), new IndexTransaction(entry.getValue(), indexKeyRetriever.get(entry.getKey()), configuration, this.maxWriteTime));
        }
        return new BackendTransaction(cacheTx, configuration, this.storeFeatures, this.edgeStore, this.indexStore, this.maxReadTime, indexTx, this.threadPool);
    }

    public void close() throws StorageException {
        this.mgmtLogManager.close();
        this.txLogManager.close();
        this.triggerLogManager.close();
        this.edgeStore.close();
        this.indexStore.close();
        this.idAuthority.close();
        this.systemConfig.close();
        this.storeManager.close();
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
        for (IndexProvider index : this.indexes.values()) {
            index.close();
        }
    }

    public void clearStorage() throws StorageException {
        this.mgmtLogManager.close();
        this.txLogManager.close();
        this.triggerLogManager.close();
        this.edgeStore.close();
        this.indexStore.close();
        this.idAuthority.close();
        this.systemConfig.close();
        this.storeManager.clearStorage();
        for (IndexProvider index : this.indexes.values()) {
            index.clearStorage();
        }
    }

    private static Locker openManagedLocker(String classname, String lockerName) {
        try {
            Class<?> c = Class.forName(classname);
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            Object instance = constructor.newInstance(new Object[0]);
            Method method = c.getMethod("openLocker", String.class);
            Object o = method.invoke(instance, lockerName);
            return (Locker)o;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find implementation class: " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + classname, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find method when configuring locking for: " + classname, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access method when configuring locking for: " + classname, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Could not invoke method when configuring locking for: " + classname, e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Could not instantiate implementation: " + classname, e);
        }
    }

    public static final void registerShorthands(Properties props, String prefix, Map<String, String> shorthands) {
        for (String key : props.stringPropertyNames()) {
            if (!key.toLowerCase().startsWith(prefix)) continue;
            String shorthand = key.substring(prefix.length()).toLowerCase();
            String clazz = props.getProperty(key);
            shorthands.put(shorthand, clazz);
            log.debug("Registering shorthand [{}] for [{}]", (Object)shorthand, (Object)clazz);
        }
    }

    static {
        Properties props;
        log = LoggerFactory.getLogger(Backend.class);
        STATIC_KEY_LENGTHS = new HashMap<String, Integer>(){
            {
                this.put(Backend.EDGESTORE_NAME, 8);
                this.put("edgestore_lock_", 8);
                this.put(Backend.ID_STORE_NAME, 8);
            }
        };
        REGISTERED_STORAGE_MANAGERS = new HashMap<String, String>(){
            {
                this.put("berkeleyje", "com.thinkaurelius.titan.diskstorage.berkeleyje.BerkeleyJEStoreManager");
                this.put("infinispan", "com.thinkaurelius.titan.diskstorage.infinispan.InfinispanCacheStoreManager");
                this.put("cassandrathrift", "com.thinkaurelius.titan.diskstorage.cassandra.thrift.CassandraThriftStoreManager");
                this.put("cassandra", "com.thinkaurelius.titan.diskstorage.cassandra.astyanax.AstyanaxStoreManager");
                this.put("astyanax", "com.thinkaurelius.titan.diskstorage.cassandra.astyanax.AstyanaxStoreManager");
                this.put("hbase", "com.thinkaurelius.titan.diskstorage.hbase.HBaseStoreManager");
                this.put("embeddedcassandra", "com.thinkaurelius.titan.diskstorage.cassandra.embedded.CassandraEmbeddedStoreManager");
                this.put("inmemory", "com.thinkaurelius.titan.diskstorage.keycolumnvalue.inmemory.InMemoryStoreManager");
            }
        };
        REGISTERED_STORAGE_MANAGERS_SHORTHAND = new HashMap<String, ConfigOption>(){
            {
                this.put("berkeleyje", GraphDatabaseConfiguration.STORAGE_DIRECTORY);
                this.put("hazelcast", GraphDatabaseConfiguration.STORAGE_DIRECTORY);
                this.put("hazelcastcache", GraphDatabaseConfiguration.STORAGE_DIRECTORY);
                this.put("infinispan", GraphDatabaseConfiguration.STORAGE_DIRECTORY);
                this.put("cassandra", GraphDatabaseConfiguration.STORAGE_HOSTS);
                this.put("cassandrathrift", GraphDatabaseConfiguration.STORAGE_HOSTS);
                this.put("astyanax", GraphDatabaseConfiguration.STORAGE_HOSTS);
                this.put("hbase", GraphDatabaseConfiguration.STORAGE_HOSTS);
                this.put("embeddedcassandra", GraphDatabaseConfiguration.STORAGE_CONF_FILE);
                this.put("inmemory", null);
            }
        };
        REGISTERED_INDEX_PROVIDERS = new HashMap<String, String>(){
            {
                this.put("lucene", "com.thinkaurelius.titan.diskstorage.lucene.LuceneIndex");
                this.put("elasticsearch", "com.thinkaurelius.titan.diskstorage.es.ElasticSearchIndex");
                this.put("es", "com.thinkaurelius.titan.diskstorage.es.ElasticSearchIndex");
            }
        };
        REGISTERED_LOG_MANAGERS = new HashMap<String, String>(){
            {
                this.put("default", "com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLogManager");
            }
        };
        try {
            props = new Properties();
            InputStream in = TitanFactory.class.getClassLoader().getResourceAsStream("titan.properties");
            if (in != null && in.available() > 0) {
                props.load(in);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        Backend.registerShorthands(props, "storage.", REGISTERED_STORAGE_MANAGERS);
        Backend.registerShorthands(props, "index.", REGISTERED_INDEX_PROVIDERS);
    }
}

