/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;

public class TitanId {
    public static final long toVertexId(long id) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0, (String)"Vertex id must be positive: %s", (Object[])new Object[]{id});
        Preconditions.checkArgument((IDManager.VertexIDType.NormalVertex.removePadding(Long.MAX_VALUE) >= id ? 1 : 0) != 0, (String)"Vertex id is too large: %s", (Object[])new Object[]{id});
        return IDManager.VertexIDType.NormalVertex.addPadding(id);
    }

    public static final long fromVertexId(long id) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0, (String)"Invalid vertex id provided: %s", (Object[])new Object[]{id});
        return IDManager.VertexIDType.NormalVertex.removePadding(id);
    }

    public static final long fromVertexID(TitanVertex v) {
        Preconditions.checkArgument((boolean)v.hasId(), (String)"Invalid vertex provided: %s", (Object[])new Object[]{v});
        return TitanId.fromVertexId(v.getID());
    }
}

