/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectiveConfigOptionLoader {
    private static final Logger log = LoggerFactory.getLogger(ReflectiveConfigOptionLoader.class);
    private static boolean loaded = false;

    public static void load() {
        Set scanUrls = ClasspathHelper.forJavaClassPath();
        Iterator i = scanUrls.iterator();
        while (i.hasNext()) {
            File f = new File(((URL)i.next()).getPath());
            if (!f.exists() || f.isDirectory()) {
                log.trace("Skipping classpath element {}", (Object)f);
                i.remove();
            }
            log.trace("Retaining classpath element {}", (Object)f);
        }
        ConfigurationBuilder rc = new ConfigurationBuilder().setUrls((Collection)scanUrls).setScanners(new Scanner[]{new TypeAnnotationsScanner()});
        Reflections reflections = new Reflections((Configuration)rc);
        int loadCount = 0;
        for (Class c : reflections.getTypesAnnotatedWith(PreInitializeConfigOptions.class)) {
            log.trace("Looking for ConfigOption public static fields on class {}", (Object)c);
            for (Field f : c.getDeclaredFields()) {
                boolean pub = Modifier.isPublic(f.getModifiers());
                boolean stat = Modifier.isStatic(f.getModifiers());
                boolean typeMatch = ConfigOption.class.isAssignableFrom(f.getType());
                log.trace("Properties for field \"{}\": public={} static={} assignable={}", new Object[]{f, pub, stat, typeMatch});
                if (!pub || !stat || !typeMatch) continue;
                try {
                    Object o = f.get(null);
                    Preconditions.checkNotNull((Object)o);
                    log.debug("Initialized {}={}", (Object)f, o);
                    ++loadCount;
                }
                catch (IllegalArgumentException e) {
                    log.warn("ConfigOption initialization error", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.warn("ConfigOption initialization error", (Throwable)e);
                }
            }
        }
        log.debug("Preloaded {} config options via reflections in {} ms", (Object)loadCount);
    }

    public static synchronized void loadOnce() {
        if (loaded) {
            return;
        }
        ReflectiveConfigOptionLoader.load();
        loaded = true;
    }
}

