/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.rdf.ranking;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import net.fortytwo.flow.rdf.ranking.Handler;
import net.fortytwo.flow.rdf.ranking.HandlerException;
import net.fortytwo.flow.rdf.ranking.KeepResourcesFilter;
import net.fortytwo.flow.rdf.ranking.Ranking;
import net.fortytwo.flow.rdf.ranking.WeightedVector;
import net.fortytwo.flow.rdf.ranking.WeightedVectorApproximation;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.sail.SailConnection;

public class RDFSpreadVector
implements WeightedVectorApproximation<Resource, HandlerException> {
    private static final double DECAY = 0.85;
    private final WeightedVector<Resource> vector;
    private Queue<Resource> curGen;
    private Queue<Resource> nextGen;
    private double weight;
    private final SailConnection sailConnection;
    private final Resource[] seeds;
    private final URI[] inPredicates;
    private final URI[] outPredicates;

    public RDFSpreadVector(WeightedVector<Resource> vector, URI[] inPredicates, URI[] outPredicates, SailConnection sailConnection, Resource ... seeds) {
        this.vector = vector;
        this.inPredicates = inPredicates;
        this.outPredicates = outPredicates;
        this.sailConnection = sailConnection;
        this.seeds = seeds;
        this.curGen = new LinkedList<Resource>();
        this.curGen.addAll(Arrays.asList(seeds));
        this.nextGen = new LinkedList<Resource>();
        this.weight = 1.0;
    }

    @Override
    public WeightedVector<Resource> currentResult() {
        WeightedVector<Resource> normed = new WeightedVector<Resource>(this.vector);
        for (Resource s : this.seeds) {
            normed.setWeight(s, 0.0);
        }
        normed.normalizeAsDist();
        return normed;
    }

    @Override
    public int compute(int cycles) throws HandlerException {
        for (int i = 0; i < cycles; ++i) {
            if (0 == this.curGen.size()) {
                if (0 == this.nextGen.size()) {
                    return 0;
                }
                this.weight *= 0.85;
                Queue<Resource> tmp = this.curGen;
                this.curGen = this.nextGen;
                this.nextGen = tmp;
                continue;
            }
            Resource r = this.curGen.remove();
            this.stepRelated(this.sailConnection, r, this.weight, this.vector, this.nextGen);
        }
        return cycles;
    }

    public void stepRelated(SailConnection sc, Resource resource, final double weight, final WeightedVector<Resource> result, final Queue<Resource> resources) throws HandlerException {
        if (0 < this.inPredicates.length) {
            Handler<Resource, HandlerException> inHandler = new Handler<Resource, HandlerException>(){

                @Override
                public boolean handle(Resource r) throws HandlerException {
                    result.addWeight(r, weight);
                    resources.offer(r);
                    return true;
                }
            };
            Ranking.traverseBackward(sc, new KeepResourcesFilter<HandlerException>(inHandler), resource, this.inPredicates);
        }
        if (0 < this.outPredicates.length) {
            Handler<Resource, HandlerException> outHandler = new Handler<Resource, HandlerException>(){

                @Override
                public boolean handle(Resource r) throws HandlerException {
                    result.addWeight(r, weight);
                    resources.offer(r);
                    return true;
                }
            };
            Ranking.traverseForward(sc, new KeepResourcesFilter<HandlerException>(outHandler), resource, this.outPredicates);
        }
    }
}

