/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.rdf;

import net.fortytwo.flow.Sink;
import net.fortytwo.flow.rdf.RDFSink;
import net.fortytwo.ripple.RippleException;
import org.openrdf.model.Namespace;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class SesameOutputAdapter
implements RDFSink {
    private RDFHandler handler;
    private final Sink<Statement> stSink;
    private final Sink<Namespace> nsSink;
    private final Sink<String> cmtSink;

    public SesameOutputAdapter(final RDFHandler handler) {
        this.handler = handler;
        this.stSink = new Sink<Statement>(){

            public void put(Statement st) throws RippleException {
                try {
                    handler.handleStatement(st);
                }
                catch (RDFHandlerException e) {
                    throw new RippleException((Throwable)e);
                }
            }
        };
        this.nsSink = new Sink<Namespace>(){

            public void put(Namespace ns) throws RippleException {
                try {
                    handler.handleNamespace(ns.getPrefix(), ns.getName());
                }
                catch (RDFHandlerException e) {
                    throw new RippleException((Throwable)e);
                }
            }
        };
        this.cmtSink = new Sink<String>(){

            public void put(String comment) throws RippleException {
                try {
                    handler.handleComment(comment);
                }
                catch (RDFHandlerException e) {
                    throw new RippleException((Throwable)e);
                }
            }
        };
    }

    public void startRDF() throws RDFHandlerException {
        this.handler.startRDF();
    }

    public void endRDF() throws RDFHandlerException {
        this.handler.endRDF();
    }

    @Override
    public Sink<Statement> statementSink() {
        return this.stSink;
    }

    @Override
    public Sink<Namespace> namespaceSink() {
        return this.nsSink;
    }

    @Override
    public Sink<String> commentSink() {
        return this.cmtSink;
    }
}

