/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.server;

import com.tinkerpop.rexster.gremlin.converter.ConsoleResultConverter;
import com.tinkerpop.rexster.protocol.msg.ErrorResponseMessage;
import com.tinkerpop.rexster.protocol.msg.MessageUtil;
import com.tinkerpop.rexster.protocol.msg.RexProBindings;
import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.msg.RexProMessageMeta;
import com.tinkerpop.rexster.protocol.msg.RexProScriptResult;
import com.tinkerpop.rexster.protocol.msg.ScriptRequestMessage;
import com.tinkerpop.rexster.protocol.msg.ScriptResponseMessage;
import com.tinkerpop.rexster.protocol.msg.SessionRequestMessage;
import com.tinkerpop.rexster.protocol.msg.SessionResponseMessage;
import com.tinkerpop.rexster.protocol.serializer.RexProSerializer;
import com.tinkerpop.rexster.protocol.serializer.json.JSONSerializer;
import com.tinkerpop.rexster.protocol.serializer.msgpack.MsgPackSerializer;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.MetaTemplate;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.ResultsTemplate;
import com.tinkerpop.rexster.protocol.server.IncompleteRexProRequestException;
import com.tinkerpop.rexster.protocol.server.ScriptServer;
import com.tinkerpop.rexster.protocol.server.SessionServer;
import com.tinkerpop.rexster.protocol.session.RexProSession;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.log4j.Logger;
import org.glassfish.grizzly.Buffer;
import org.msgpack.MessagePack;
import org.msgpack.template.Template;

public class RexProRequest {
    private static final Logger logger = Logger.getLogger(RexProRequest.class);
    private static final MessagePack msgpack = new MessagePack();
    private ByteBuffer requestBuffer;
    private RexsterApplication rexsterApplication;
    private final byte serializerType;
    private final byte messageType;
    private final int bodyLength;
    private final int completeMessageLength;
    private final byte[] requestBytes;
    private RexProMessage requestMessage = null;
    private static int ENVELOPE_LENGTH;
    private RexProSession session = null;
    private RexProMessage responseMessage = null;
    private byte[] responseBytes = null;
    private static byte BYTE_VERSION;
    private static byte[] BYTES_RESERVED;
    private static MsgPackSerializer msgPackSerializer;
    private static JSONSerializer jsonSerializer;

    public RexProRequest(ByteBuffer buffer, int bufferSize, RexsterApplication application) throws IncompleteRexProRequestException {
        this.requestBuffer = buffer;
        this.rexsterApplication = application;
        if (bufferSize < ENVELOPE_LENGTH) {
            throw new IncompleteRexProRequestException();
        }
        this.serializerType = this.requestBuffer.get(1);
        this.messageType = this.requestBuffer.get(6);
        this.bodyLength = this.requestBuffer.getInt(7);
        this.completeMessageLength = ENVELOPE_LENGTH + this.bodyLength;
        if (bufferSize < this.completeMessageLength) {
            throw new IncompleteRexProRequestException(String.format("Message envelope is incomplete. Message length set to %s but the buffer only contains %s", this.completeMessageLength, bufferSize));
        }
        if (this.bodyLength < 0) {
            throw new IncompleteRexProRequestException(String.format("Message body length in the envelope is negative: %s.", this.completeMessageLength));
        }
        this.requestBytes = new byte[this.bodyLength];
        buffer.position(ENVELOPE_LENGTH);
        buffer.get(this.requestBytes);
    }

    public int getCompleteRequestMessageLength() {
        return this.completeMessageLength;
    }

    public byte getRequestMessageType() {
        return this.messageType;
    }

    public byte[] getRequestMessageBytes() {
        return this.requestBytes;
    }

    public int getRequestBodyLength() {
        return this.bodyLength;
    }

    public void setSession(RexProSession session) {
        this.session = session;
    }

    public RexProMessage getRequestMessage() {
        return this.requestMessage;
    }

    protected RexProSerializer getSerializer() {
        if (this.serializerType == jsonSerializer.getSerializerId()) {
            return jsonSerializer;
        }
        return msgPackSerializer;
    }

    private void deserializeMessage() throws IOException {
        try {
            if (this.messageType == 3) {
                this.requestMessage = this.getSerializer().deserialize(this.requestBytes, ScriptRequestMessage.class);
            } else if (this.messageType == 1) {
                this.requestMessage = this.getSerializer().deserialize(this.requestBytes, SessionRequestMessage.class);
            }
            if (this.requestMessage == null) {
                logger.warn((Object)String.format("Message did not match the specified type [%s]", this.messageType));
                this.writeResponseMessage(MessageUtil.createErrorResponse(RexProMessage.EMPTY_REQUEST_AS_BYTES, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.INVALID_MESSAGE_ERROR, "Message did not match an expected type."));
            }
        }
        catch (Exception ex) {
            logger.error((Object)String.format("Error during message deserialization of a message of type [%s].", this.messageType), (Throwable)ex);
            this.writeResponseMessage(MessageUtil.createErrorResponse(RexProMessage.EMPTY_REQUEST_AS_BYTES, RexProMessage.EMPTY_SESSION_AS_BYTES, ErrorResponseMessage.INVALID_MESSAGE_ERROR, ex.toString()));
        }
    }

    public void process() {
        if (this.requestMessage != null) {
            return;
        }
        try {
            this.deserializeMessage();
        }
        catch (Exception ex) {
            logger.warn((Object)("error deserializing message: " + ex.toString()));
        }
        if (this.responseMessage != null) {
            return;
        }
        try {
            if (this.requestMessage instanceof SessionRequestMessage) {
                SessionServer sessionServer = new SessionServer(this.rexsterApplication);
                sessionServer.handleRequest((SessionRequestMessage)this.requestMessage, this);
            } else if (this.requestMessage instanceof ScriptRequestMessage) {
                ScriptServer scriptServer = new ScriptServer(this.rexsterApplication);
                scriptServer.handleRequest((ScriptRequestMessage)this.requestMessage, this);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("error processing rexpro request: " + ex.toString()));
            try {
                if (this.responseMessage == null) {
                    this.writeResponseMessage(MessageUtil.createErrorResponse(this.requestMessage.Request, this.requestMessage.Session, ErrorResponseMessage.UNKNOWN_ERROR, ex.toString()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeScriptResults(Object result) throws Exception {
        ScriptRequestMessage message = (ScriptRequestMessage)this.requestMessage;
        if (message.metaGetConsole().booleanValue()) {
            this.writeResponseMessage(RexProRequest.formatForConsoleChannel(message, this.session, result));
        } else {
            this.writeResponseMessage(RexProRequest.formatForMsgPackChannel(message, this.session, result));
        }
    }

    public void writeResponseMessage(RexProMessage response) throws IOException {
        this.responseMessage = response;
        this.serializeMessage();
    }

    private void serializeMessage() throws IOException {
        block7: {
            try {
                RexProSerializer serializer = this.getSerializer();
                if (this.responseMessage instanceof SessionResponseMessage) {
                    this.responseBytes = serializer.serialize((SessionResponseMessage)this.responseMessage, SessionResponseMessage.class);
                    break block7;
                }
                if (this.responseMessage instanceof ErrorResponseMessage) {
                    this.responseBytes = serializer.serialize((ErrorResponseMessage)this.responseMessage, ErrorResponseMessage.class);
                    break block7;
                }
                if (this.responseMessage instanceof ScriptResponseMessage) {
                    this.responseBytes = serializer.serialize((ScriptResponseMessage)this.responseMessage, ScriptResponseMessage.class);
                    break block7;
                }
                throw new Exception();
            }
            catch (Exception ex) {
                ErrorResponseMessage errorMsg = MessageUtil.createErrorResponse(this.responseMessage.Request, this.responseMessage.Session, ErrorResponseMessage.RESULT_SERIALIZATION_ERROR, "Script was successfully executed but the result of the script was not properly serialized.");
                try {
                    this.responseBytes = this.getSerializer().serialize(errorMsg, ErrorResponseMessage.class);
                    this.responseMessage = errorMsg;
                }
                catch (IOException ex2) {
                    logger.error((Object)String.format("Could not serialize error message for request [%s] session [%s].  Should have reported flag [%s] message [%s] to client", errorMsg.requestAsUUID(), errorMsg.sessionAsUUID(), errorMsg.metaGetFlag(), errorMsg.ErrorMessage));
                }
            }
        }
    }

    public int getResponseSize() {
        return ENVELOPE_LENGTH + this.responseBytes.length;
    }

    public void writeToBuffer(Buffer bb) {
        bb.put(BYTE_VERSION);
        bb.put(this.serializerType);
        bb.put(BYTES_RESERVED);
        if (this.responseMessage instanceof SessionResponseMessage) {
            bb.put((byte)2);
        } else if (this.responseMessage instanceof ErrorResponseMessage) {
            bb.put((byte)0);
        } else if (this.responseMessage instanceof ScriptResponseMessage) {
            bb.put((byte)5);
        }
        bb.putInt(this.responseBytes.length);
        bb.put(this.responseBytes);
    }

    private static ScriptResponseMessage formatForMsgPackChannel(ScriptRequestMessage specificMessage, RexProSession session, Object result) throws Exception {
        ScriptResponseMessage msgPackScriptResponseMessage = new ScriptResponseMessage();
        if (specificMessage.metaGetInSession().booleanValue()) {
            msgPackScriptResponseMessage.Session = specificMessage.Session;
        } else {
            msgPackScriptResponseMessage.setSessionAsUUID(RexProMessage.EMPTY_SESSION);
        }
        msgPackScriptResponseMessage.Request = specificMessage.Request;
        msgPackScriptResponseMessage.Results.set(result);
        if (session != null) {
            msgPackScriptResponseMessage.Bindings.putAll(session.getBindings());
        }
        msgPackScriptResponseMessage.validateMetaData();
        return msgPackScriptResponseMessage;
    }

    public static List<String> convertResultToConsoleLines(Object result) throws Exception {
        ConsoleResultConverter converter = new ConsoleResultConverter(new StringWriter());
        return converter.convert(result);
    }

    private static ScriptResponseMessage formatForConsoleChannel(ScriptRequestMessage specificMessage, RexProSession session, Object result) throws Exception {
        ScriptResponseMessage consoleScriptResponseMessage = new ScriptResponseMessage();
        if (specificMessage.metaGetInSession().booleanValue()) {
            consoleScriptResponseMessage.Session = specificMessage.Session;
        } else {
            consoleScriptResponseMessage.setSessionAsUUID(RexProMessage.EMPTY_SESSION);
        }
        consoleScriptResponseMessage.Request = specificMessage.Request;
        List<String> consoleLines = RexProRequest.convertResultToConsoleLines(result);
        consoleScriptResponseMessage.Results.set(consoleLines);
        if (session != null) {
            consoleScriptResponseMessage.Bindings.putAll(session.getBindings());
        }
        consoleScriptResponseMessage.validateMetaData();
        return consoleScriptResponseMessage;
    }

    static {
        msgpack.register(RexProMessageMeta.class, (Template)MetaTemplate.getInstance());
        msgpack.register(RexProBindings.class, (Template)RexProBindings.SerializationTemplate.getInstance());
        msgpack.register(RexProScriptResult.class, (Template)ResultsTemplate.getInstance());
        ENVELOPE_LENGTH = 11;
        BYTE_VERSION = 1;
        BYTES_RESERVED = new byte[]{0, 0, 0, 0};
        msgPackSerializer = new MsgPackSerializer();
        jsonSerializer = new JSONSerializer();
    }
}

