/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.msg;

import com.tinkerpop.rexster.client.RexProException;
import com.tinkerpop.rexster.protocol.msg.ErrorResponseMessage;
import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.msg.SessionResponseMessage;
import java.util.List;
import java.util.UUID;

public class MessageUtil {
    public static ErrorResponseMessage createErrorResponse(byte[] request, byte[] session, Integer flag, String errorMessage) {
        ErrorResponseMessage msg = new ErrorResponseMessage();
        msg.Request = request;
        msg.Session = session;
        msg.ErrorMessage = errorMessage;
        msg.metaSetFlag(flag);
        try {
            msg.validateMetaData();
        }
        catch (RexProException ex) {
            // empty catch block
        }
        return msg;
    }

    public static SessionResponseMessage createNewSession(byte[] request, List<String> languages) {
        UUID sessionKey = UUID.randomUUID();
        SessionResponseMessage responseMessage = new SessionResponseMessage();
        responseMessage.setSessionAsUUID(sessionKey);
        responseMessage.Request = request;
        responseMessage.Languages = new String[languages.size()];
        languages.toArray(responseMessage.Languages);
        return responseMessage;
    }

    public static SessionResponseMessage createEmptySession(byte[] request) {
        SessionResponseMessage responseMessage = new SessionResponseMessage();
        responseMessage.setSessionAsUUID(RexProMessage.EMPTY_SESSION);
        responseMessage.Request = request;
        responseMessage.Languages = new String[0];
        return responseMessage;
    }
}

