/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.UUID;

public class BitWorks {
    public static byte[] convertUUIDToByteArray(UUID uuid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static UUID convertByteArrayToUUID(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long mostSignificantBits = bb.getLong();
        long leastSignificantBits = bb.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertStringsToByteArray(String ... values) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            for (String value : values) {
                byte[] valueAsBytes = value.getBytes(Charset.forName("UTF-8"));
                stream.write(ByteBuffer.allocate(4).putInt(valueAsBytes.length).array());
                stream.write(valueAsBytes);
            }
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getBytesWithLength(Object result) throws IOException {
        if (result == null) {
            return null;
        }
        ByteArrayOutputStream byteOuputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOuputStream);
        try {
            objectOutputStream.writeObject(result);
            ByteBuffer bb = ByteBuffer.allocate(4 + byteOuputStream.size());
            bb.putInt(byteOuputStream.size());
            bb.put(byteOuputStream.toByteArray());
            byte[] byArray = bb.array();
            return byArray;
        }
        finally {
            objectOutputStream.close();
        }
    }
}

