/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.gremlin.converter;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import com.tinkerpop.pipes.util.structures.Pair;
import com.tinkerpop.pipes.util.structures.Row;
import com.tinkerpop.pipes.util.structures.Table;
import com.tinkerpop.rexster.gremlin.converter.ResultConverter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class JSONResultConverter
implements ResultConverter<JSONArray> {
    private final GraphSONMode mode;
    private final long offsetStart;
    private final long offsetEnd;
    private final Set<String> returnKeys;

    public JSONResultConverter(GraphSONMode mode, long offsetStart, long offsetEnd, Set<String> returnKeys) {
        this.mode = mode;
        this.offsetEnd = offsetEnd;
        this.offsetStart = offsetStart;
        this.returnKeys = returnKeys;
    }

    public JSONArray convert(Object result) throws Exception {
        return (JSONArray)this.convert(result, false).getA();
    }

    public Pair<JSONArray, Long> convert(Object result, boolean returnTotal) throws Exception {
        JSONArray results = new JSONArray();
        long counter = 0L;
        if (result == null) {
            results = null;
        } else if (result instanceof Table) {
            Table table = (Table)result;
            for (Row row : table) {
                if (counter >= this.offsetStart && counter < this.offsetEnd) {
                    results.put(this.prepareOutput(row));
                }
                if (returnTotal || counter < this.offsetEnd) {
                    ++counter;
                    continue;
                }
                break;
            }
        } else if (result instanceof Iterable) {
            for (Object o : (Iterable)result) {
                if (counter >= this.offsetStart && counter < this.offsetEnd) {
                    results.put(this.prepareOutput(o));
                }
                if (returnTotal || counter < this.offsetEnd) {
                    ++counter;
                    continue;
                }
                break;
            }
        } else if (result instanceof Iterator) {
            Iterator itty = (Iterator)result;
            while (itty.hasNext()) {
                Object current = itty.next();
                if (counter >= this.offsetStart && counter < this.offsetEnd) {
                    results.put(this.prepareOutput(current));
                }
                if (returnTotal || counter < this.offsetEnd) {
                    ++counter;
                    continue;
                }
                break;
            }
        } else {
            results.put(this.prepareOutput(result));
        }
        return new Pair((Object)results, (Object)counter);
    }

    private Object prepareOutput(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        if (object instanceof Element) {
            return GraphSONUtility.jsonFromElement((Element)((Element)object), this.returnKeys, (GraphSONMode)this.mode);
        }
        if (object instanceof Row) {
            Row row = (Row)object;
            List columnNames = row.getColumnNames();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String columnName : columnNames) {
                map.put(columnName, this.prepareOutput(row.getColumn(columnName)));
            }
            return new JSONObject(map);
        }
        if (object instanceof Map) {
            JSONObject jsonObject = new JSONObject();
            Map map = (Map)object;
            for (Object key : map.keySet()) {
                if (key instanceof Element) {
                    Element element = (Element)key;
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("_key", this.prepareOutput(element));
                    m.put("_value", this.prepareOutput(map.get(key)));
                    jsonObject.put(element.getId().toString(), (Object)new JSONObject(m));
                    continue;
                }
                jsonObject.put(key == null ? null : key.toString(), this.prepareOutput(map.get(key)));
            }
            return jsonObject;
        }
        if (object instanceof Table || object instanceof Iterable || object instanceof Iterator) {
            return this.convert(object);
        }
        if (object instanceof Number || object instanceof Boolean) {
            return object;
        }
        if (object == JSONObject.NULL) {
            return JSONObject.NULL;
        }
        return object.toString();
    }
}

