/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.client;

import com.tinkerpop.rexster.client.RexProClientFilter;
import com.tinkerpop.rexster.client.RexsterClient;
import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;

public final class RexProClientConnection {
    public static final int DEFAULT_TIMEOUT_SECONDS = 100;
    private final Connection connection;
    private final BlockingQueue<RexProMessage> responseQueue = new SynchronousQueue<RexProMessage>(true);

    public RexProClientConnection(String rexProHost, int rexProPort) {
        TCPNIOTransport transport = RexProClientConnection.getTransport(this.responseQueue);
        try {
            transport.start();
            this.connection = (Connection)transport.connect(rexProHost, rexProPort).get(10L, TimeUnit.SECONDS);
            this.connection.configureBlocking(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public RexProMessage sendMessage(RexProMessage messageToSend) throws IOException {
        return this.sendMessage(messageToSend, 100);
    }

    public RexProMessage sendMessage(RexProMessage messageToSend, int timeoutSeconds) throws IOException {
        try {
            this.connection.write((Object)new RexsterClient.MessageContainer(0, messageToSend)).get((long)timeoutSeconds, TimeUnit.SECONDS);
            return this.responseQueue.take();
        }
        catch (Exception e) {
            throw new RuntimeException("Request [" + messageToSend.getClass().getName() + "] to Rexster failed [" + this.connection + "] - " + e.getMessage(), e);
        }
    }

    public void close() {
        this.connection.close();
    }

    public static TCPNIOTransport getTransport(final BlockingQueue<RexProMessage> responseQueue) {
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new RexProClientFilter());
        filterChainBuilder.add((Filter)new BaseFilter(){

            public NextAction handleRead(FilterChainContext ctx) throws IOException {
                responseQueue.add((RexProMessage)ctx.getMessage());
                return ctx.getStopAction();
            }
        });
        TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        return transport;
    }
}

