/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.io;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.msgpack.io.Output;

public class ByteBufferOutput
implements Output {
    private ByteBuffer buffer;
    private ExpandBufferCallback callback;

    public ByteBufferOutput(ByteBuffer buffer) {
        this(buffer, null);
    }

    public ByteBufferOutput(ByteBuffer buffer, ExpandBufferCallback callback) {
        this.buffer = buffer;
        this.callback = callback;
    }

    private void reserve(int len) throws IOException {
        if (len <= this.buffer.remaining()) {
            return;
        }
        if (this.callback == null) {
            throw new BufferOverflowException();
        }
        this.buffer = this.callback.call(this.buffer, len);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.reserve(len);
        this.buffer.put(b, off, len);
    }

    @Override
    public void write(ByteBuffer bb) throws IOException {
        this.reserve(bb.remaining());
        this.buffer.put(bb);
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.reserve(1);
        this.buffer.put(v);
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.reserve(2);
        this.buffer.putShort(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.reserve(4);
        this.buffer.putInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.reserve(8);
        this.buffer.putLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.reserve(4);
        this.buffer.putFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.reserve(8);
        this.buffer.putDouble(v);
    }

    @Override
    public void writeByteAndByte(byte b, byte v) throws IOException {
        this.reserve(2);
        this.buffer.put(b);
        this.buffer.put(v);
    }

    @Override
    public void writeByteAndShort(byte b, short v) throws IOException {
        this.reserve(3);
        this.buffer.put(b);
        this.buffer.putShort(v);
    }

    @Override
    public void writeByteAndInt(byte b, int v) throws IOException {
        this.reserve(5);
        this.buffer.put(b);
        this.buffer.putInt(v);
    }

    @Override
    public void writeByteAndLong(byte b, long v) throws IOException {
        this.reserve(9);
        this.buffer.put(b);
        this.buffer.putLong(v);
    }

    @Override
    public void writeByteAndFloat(byte b, float v) throws IOException {
        this.reserve(5);
        this.buffer.put(b);
        this.buffer.putFloat(v);
    }

    @Override
    public void writeByteAndDouble(byte b, double v) throws IOException {
        this.reserve(9);
        this.buffer.put(b);
        this.buffer.putDouble(v);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() {
    }

    public static interface ExpandBufferCallback {
        public ByteBuffer call(ByteBuffer var1, int var2) throws IOException;
    }
}

