/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.ddl;

import com.google.common.collect.Maps;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.FieldMetadata;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.thrift.ThriftTypes;
import com.netflix.astyanax.thrift.ThriftUtils;
import com.netflix.astyanax.thrift.ddl.ThriftColumnFamilyDefinitionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.KsDef;
import org.apache.thrift.meta_data.FieldMetaData;

public class ThriftKeyspaceDefinitionImpl
implements KeyspaceDefinition {
    private static final Map<String, FieldMetadata> fieldsMetadata = Maps.newHashMap();
    protected KsDef ks_def;

    public ThriftKeyspaceDefinitionImpl() {
        for (Map.Entry field : KsDef.metaDataMap.entrySet()) {
            fieldsMetadata.put(((FieldMetaData)field.getValue()).fieldName, new FieldMetadata(((KsDef._Fields)field.getKey()).name(), ThriftTypes.values()[((FieldMetaData)field.getValue()).valueMetaData.type].name(), ((FieldMetaData)field.getValue()).valueMetaData.isContainer()));
        }
        this.ks_def = new KsDef();
        this.ks_def.setCf_defs(new ArrayList());
    }

    public ThriftKeyspaceDefinitionImpl(KsDef ks_def) {
        for (Map.Entry field : KsDef.metaDataMap.entrySet()) {
            fieldsMetadata.put(((FieldMetaData)field.getValue()).fieldName, new FieldMetadata(((KsDef._Fields)field.getKey()).name(), ThriftTypes.values()[((FieldMetaData)field.getValue()).valueMetaData.type].name(), ((FieldMetaData)field.getValue()).valueMetaData.isContainer()));
        }
        this.ks_def = ks_def;
    }

    public KsDef getThriftKeyspaceDefinition() {
        return this.ks_def;
    }

    public KeyspaceDefinition setName(String name) {
        this.ks_def.setName(name);
        return this;
    }

    public String getName() {
        return this.ks_def.getName();
    }

    public KeyspaceDefinition setStrategyClass(String strategyClass) {
        this.ks_def.setStrategy_class(strategyClass);
        return this;
    }

    public String getStrategyClass() {
        return this.ks_def.getStrategy_class();
    }

    public KeyspaceDefinition setStrategyOptions(Map<String, String> options) {
        this.ks_def.setStrategy_options(options);
        return this;
    }

    public Map<String, String> getStrategyOptions() {
        if (this.ks_def.getStrategy_options() == null) {
            this.ks_def.strategy_options = new HashMap();
        }
        return this.ks_def.getStrategy_options();
    }

    public KeyspaceDefinition addStrategyOption(String name, String value) {
        this.getStrategyOptions().put(name, value);
        return this;
    }

    public KeyspaceDefinition addColumnFamily(ColumnFamilyDefinition cfDef) {
        if (this.ks_def.getCf_defs() == null) {
            this.ks_def.setCf_defs(new ArrayList());
        }
        CfDef thriftCfDef = ((ThriftColumnFamilyDefinitionImpl)cfDef).getThriftColumnFamilyDefinition();
        thriftCfDef.setColumn_type("Standard");
        thriftCfDef.setKeyspace(this.ks_def.getName());
        this.ks_def.getCf_defs().add(thriftCfDef);
        return this;
    }

    public List<ColumnFamilyDefinition> getColumnFamilyList() {
        List cfdefs = this.ks_def.getCf_defs();
        ArrayList<ColumnFamilyDefinition> list = new ArrayList<ColumnFamilyDefinition>();
        for (CfDef cfdef : cfdefs) {
            list.add(new ThriftColumnFamilyDefinitionImpl(cfdef));
        }
        return list;
    }

    public ColumnFamilyDefinition getColumnFamily(String columnFamily) {
        for (CfDef cfdef : this.ks_def.getCf_defs()) {
            if (!cfdef.getName().equalsIgnoreCase(columnFamily)) continue;
            return new ThriftColumnFamilyDefinitionImpl(cfdef);
        }
        return null;
    }

    public Collection<String> getFieldNames() {
        return fieldsMetadata.keySet();
    }

    public Object getFieldValue(String name) {
        return this.ks_def.getFieldValue(KsDef._Fields.valueOf((String)name));
    }

    public KeyspaceDefinition setFieldValue(String name, Object value) {
        this.ks_def.setFieldValue(KsDef._Fields.valueOf((String)name), value);
        return this;
    }

    public Collection<FieldMetadata> getFieldsMetadata() {
        return fieldsMetadata.values();
    }

    public void setFields(Map<String, Object> options) {
        for (Map.Entry<String, FieldMetadata> field : fieldsMetadata.entrySet()) {
            String fieldName = field.getKey();
            if (!options.containsKey(fieldName)) continue;
            this.setFieldValue(field.getValue().getName(), options.get(fieldName));
        }
    }

    public Properties getProperties() throws Exception {
        return ThriftUtils.getPropertiesFromThrift(this.ks_def);
    }

    public void setProperties(Properties properties) throws Exception {
        ThriftUtils.populateObjectFromProperties(this.ks_def, properties);
    }
}

