package com.book.simplegameenginev2;

import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

public class SGActivity extends Activity
{
    public static final String TAG = "SimpleGameEngine";

    public enum SGOrientation
    {
        LANDSCAPE,
        PORTRAIT
    }

    protected SGInputPublisher mInputPublisher = null;

    public void enableFullScreen()
    {
        Window window = getWindow();
        window.addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        window.requestFeature(Window.FEATURE_NO_TITLE);

        if(android.os.Build.VERSION.SDK_INT >= 19)
        {
            window.getDecorView().setSystemUiVisibility(
                    View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
        }
    }

    public void enableKeepScreenOn()
    {
        Window window = getWindow();
        window.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
    }

    public void setOrientation(SGOrientation orientation)
    {
        switch(orientation)
        {
            case LANDSCAPE:
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
                break;
            case PORTRAIT:
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
                break;
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event)
    {
        if(mInputPublisher != null)
        {
            return mInputPublisher.onTouchEvent(event);
        }
        else
        {
            return false;
        }
    }

    public void setInputPublisher(SGInputPublisher inputPublisher) { mInputPublisher = inputPublisher; }

    public SGInputPublisher getInputPublisher() { return mInputPublisher; }

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void onDestroy()
    {
        super.onDestroy();
        Log.d(TAG, "onDestroy() chamado.");
    }

    @Override
    protected void onPause()
    {
        super.onPause();
        Log.d(TAG, "onPause() chamado.");
    }

    @Override
    protected void onRestart()
    {
        super.onRestart();
        Log.d(TAG, "onRestart() chamado.");
    }

    @Override
    protected void onResume()
    {
        super.onResume();
        Log.d(TAG, "onResume() chamado.");
    }

    @Override
    protected void onStart()
    {
        super.onStart();
        Log.d(TAG, "onStart() chamado.");
    }

    @Override
    protected void onStop()
    {
        super.onStop();
        Log.d(TAG, "onStop() chamado.");
    }
}

