package com.book.pongv4;

import android.graphics.Point;
import android.graphics.PointF;
import android.util.Log;
import android.view.MotionEvent;

import com.book.simplegameenginev4.SGInputSubscriber;
import com.book.simplegameenginev4.SGViewport;

public class GameController implements SGInputSubscriber
{
	private GameModel mModel;
	private GameView mView;

	public GameController(GameModel model, GameView view)
	{
		mModel = model;
		mView = view;
	}

	@Override
	public void onDown(MotionEvent event)
	{
	}

	@Override
	public void onScroll(MotionEvent downEvent, MotionEvent moveEvent,
	                     float distanceX, float distanceY)
	{
		if(mModel.getCurrentState() == GameModel.STATE_RUNNING)
		{
			PointF scalingFactor = mView.getRenderer().getViewport().getScalingFactor();
			mModel.movePlayer(-distanceX / scalingFactor.x, -distanceY / scalingFactor.y);
		}
	}

	@Override
	public void onUp(MotionEvent event)
	{
	}

	public GameModel getModel() { return mModel; }
}

