package com.book.pongv3;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;

import com.book.simplegameenginev3.SGEntity;
import com.book.simplegameenginev3.SGImage;
import com.book.simplegameenginev3.SGImageFactory;
import com.book.simplegameenginev3.SGRenderer;
import com.book.simplegameenginev3.SGView;

import java.util.ArrayList;

public class GameView extends SGView
{
	private boolean 		mIsDebug = false;
	private GameModel 	    mModel;
	private Rect            mTempSrcRect = new Rect();
	private SGImage         mBallImage;
	private SGImage 		mOpponentImage;
	private SGImage 		mPlayerImage;

	private GameView(Context context)
	{
		super(context);
	}

	public GameView(Context context, GameModel model)
	{
		super(context);
		mModel = model;
	}

	@Override
	public void setup()
	{
		mModel.setup();

		SGImageFactory imageFactory = getImageFactory();

		mBallImage = imageFactory.createImage("ball.png");
		mPlayerImage = imageFactory.createImage("player.png");
		mOpponentImage = imageFactory.createImage("opponent.png");
	}

	@Override
	public void step(Canvas canvas, float elapsedTimeInSeconds)
	{
		mModel.step(elapsedTimeInSeconds);

		SGRenderer renderer = getRenderer();
		renderer.beginDrawing(canvas, Color.BLACK);

		ArrayList<SGEntity> entities = mModel.getEntities();

		if(mIsDebug)
		{
			for(SGEntity currentEntity : entities)
			{
				SGEntity.DebugDrawingStyle style = currentEntity.getDebugDrawingStyle();
				if(style == SGEntity.DebugDrawingStyle.FILLED)
				{
					renderer.drawRect(currentEntity.getBoundingBox(), currentEntity.getDebugColor());
				}
				else
				{
					renderer.drawOutlineRect(currentEntity.getBoundingBox(), currentEntity.getDebugColor());
				}
			}
		}
		else
		{
			for(SGEntity currentEntity : entities)
			{
				if(currentEntity.getCategory() != "trigger")
				{
					if(currentEntity.getId() == GameModel.PLAYER_ID)
					{
						mTempSrcRect.set(0, 0, GameModel.PADDLE_WIDTH, GameModel.PADDLE_HEIGHT);
						renderer.drawImage(mPlayerImage, mTempSrcRect,
										   currentEntity.getPosition(),
										   currentEntity.getDimensions());
					}
					else if(currentEntity.getId() == GameModel.OPPONENT_ID)
					{
						mTempSrcRect.set(0, 0, GameModel.PADDLE_WIDTH, GameModel.PADDLE_HEIGHT);
						renderer.drawImage(mOpponentImage, mTempSrcRect,
										   currentEntity.getPosition(),
										   currentEntity.getDimensions());
					}
					else // (currentEntity.getId() == GameModel.BALL_ID)
					{
						mTempSrcRect.set(0, 0, GameModel.BALL_SIZE, GameModel.BALL_SIZE);
						renderer.drawImage(mBallImage, mTempSrcRect,
										   currentEntity.getPosition(),
										   currentEntity.getDimensions());
					}
				}
			}
		}
		renderer.endDrawing();
	}
}


