package com.book.pongv2;

import android.graphics.PointF;
import android.util.Log;

import com.book.simplegameenginev2.SGEntity;
import com.book.simplegameenginev2.SGTrigger;
import com.book.simplegameenginev2.SGWorld;

public class TrgRightGoal extends SGTrigger
{
	public TrgRightGoal(SGWorld world, PointF position, PointF dimensions)
	{
		super(world, GameModel.TRG_RIGHT_GOAL_ID, position, dimensions);
	}

	@Override
	public void onHit(SGEntity entity, float elapsedTimeInSeconds)
	{
		GameModel model = (GameModel)getWorld();

		model.increasePlayerScore();

		Log.d("PongV2", "Jogador marca um ponto!");
		model.logScore();

		model.setCurrentState(GameModel.STATE_GOAL);
	}
}

